/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.ui.context.IProjectContext;
import org.eclipse.vorto.codegen.ui.progresstask.IProgressTask;
import org.eclipse.vorto.codegen.ui.tasks.EclipseProjectGenerator;
import org.eclipse.vorto.codegen.ui.tasks.LocationWrapper;

public class VortoProjectCreationTask
implements IProgressTask {
    private static final String ERROR_MESSAGE = "Problem when creating project, error: ";
    private String errorMessage = "";
    private String projectName;
    private String workspaceLocation;
    public static final String XTEXT_NATURE = "org.eclipse.xtext.ui.shared.xtextNature";
    public static final String[] ALL_MODEL_FOLDERS = new String[]{"datatypes", "functionblocks", "infomodels", "mappings"};
    private IProjectContext context = null;

    public VortoProjectCreationTask(IProjectContext context) {
        this.projectName = context.getProjectName();
        this.workspaceLocation = context.getWorkspaceLocation();
        this.context = context;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                EclipseProjectGenerator generator = new EclipseProjectGenerator(new LocationWrapper(this.workspaceLocation, this.projectName));
                generator.addNature(XTEXT_NATURE);
                generator.addNature("org.eclipse.vorto.vortonature");
                String[] stringArray = ALL_MODEL_FOLDERS;
                int n = ALL_MODEL_FOLDERS.length;
                int n2 = 0;
                while (n2 < n) {
                    String folder = stringArray[n2];
                    generator.addFolder(folder);
                    ++n2;
                }
                generator.generate((Object)this.context, InvocationContext.simpleInvocationContext(), monitor);
                IProject iProject = generator.getProject();
                iProject.refreshLocal(1, monitor);
            }
            catch (CoreException e) {
                this.errorMessage = e.getMessage();
                throw new RuntimeException(ERROR_MESSAGE + e.getMessage(), e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

