/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.coap.server.templates;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class JsonTransformerTemplate
implements IFileTemplate<InformationModel> {
    private String targetPath;
    private String classPackage;

    public JsonTransformerTemplate(String targetPath, String classPackage) {
        this.targetPath = targetPath;
        this.classPackage = classPackage;
    }

    public String getFileName(InformationModel context) {
        return "JsonTransformer.java";
    }

    public String getPath(InformationModel context) {
        return this.targetPath;
    }

    public String getContent(InformationModel context, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)this.classPackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import com.fasterxml.jackson.core.JsonProcessingException;");
        _builder.newLine();
        _builder.append((Object)"import com.fasterxml.jackson.databind.ObjectMapper;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import java.io.IOException;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* This implements an Transformer for JSON (Java Simple Object Notation) Created by laj7rng on 15.12.15.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public class JsonTransformer {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"ObjectMapper mapper;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public JsonTransformer() {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"mapper = new ObjectMapper();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public byte[] serialize(Object value) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"byte[] serialized = null;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"serialized = mapper.writeValueAsBytes(value);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} catch (JsonProcessingException e) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"e.printStackTrace();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return serialized;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public Object deserialize(Class<?> valueType, byte[] src) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"Object value = null;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"value = mapper.readValue(src, valueType);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} catch (IOException e) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"e.printStackTrace();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return value;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

