/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.prosystfi.tasks;

import org.eclipse.vorto.codegen.api.AbstractTemplateGeneratorTask;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.examples.templates.java.JavaEnumTemplate;
import org.eclipse.vorto.core.api.model.datatype.Enum;

public class JavaEnumGeneratorTask
extends AbstractTemplateGeneratorTask<Enum> {
    private String javaFileExtension;
    private String targetPath;
    private String enumPackage;

    public JavaEnumGeneratorTask(String javaFileExtension, String srcBase, String enumPackage) {
        this.javaFileExtension = javaFileExtension;
        this.enumPackage = enumPackage;
        this.targetPath = String.valueOf(srcBase) + '/' + enumPackage.replace('.', '/');
    }

    public String getFileName(Enum en) {
        return String.valueOf(en.getName()) + this.javaFileExtension;
    }

    public String getPath(Enum en) {
        return this.targetPath;
    }

    public ITemplate<Enum> getTemplate() {
        return new JavaEnumTemplate(this.enumPackage);
    }
}

