/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.DateConstantExpression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.jpa.jpql.Declaration;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.internal.jpa.jpql.NumericTypeComparator;
import org.eclipse.persistence.internal.jpa.jpql.ReportQueryVisitor;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryDeclaration;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.AsOfClause;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CastExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConnectByClause;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DatabaseType;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkAnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.ExtractExpression;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.HierarchicalQueryClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.OnClause;
import org.eclipse.persistence.jpa.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.OrderSiblingsByClause;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.RegexpExpression;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StartWithClause;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TableExpression;
import org.eclipse.persistence.jpa.jpql.parser.TableVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.jpql.parser.UnionClause;
import org.eclipse.persistence.jpa.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.ReportQuery;

final class ExpressionBuilderVisitor
implements EclipseLinkExpressionVisitor {
    private ChildrenExpressionVisitor childrenExpressionVisitor;
    private boolean nullAllowed;
    private Comparator<Class<?>> numericTypeComparator;
    private final JPQLQueryContext queryContext;
    private org.eclipse.persistence.expressions.Expression queryExpression;
    private final Class<?>[] type = new Class[1];
    private WhenClauseExpressionVisitor whenClauseExpressionVisitor;

    ExpressionBuilderVisitor(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    private void appendJoinVariables(Expression expression, ReportQuery subquery) {
        this.queryExpression = null;
        for (String variableName : this.collectOuterIdentificationVariables()) {
            org.eclipse.persistence.expressions.Expression innerExpression = this.queryContext.getQueryExpression(variableName);
            org.eclipse.persistence.expressions.Expression outerExpression = this.queryContext.getParent().getQueryExpressionImp(variableName);
            org.eclipse.persistence.expressions.Expression equalExpression = innerExpression.equal(outerExpression);
            this.queryExpression = this.queryExpression == null ? equalExpression : this.queryExpression.and(equalExpression);
        }
        if (this.queryExpression != null) {
            org.eclipse.persistence.expressions.Expression whereClause = subquery.getSelectionCriteria();
            whereClause = whereClause != null ? whereClause.and(this.queryExpression) : this.queryExpression;
            subquery.setSelectionCriteria(whereClause);
        }
    }

    org.eclipse.persistence.expressions.Expression buildExpression(Expression expression, Class<?>[] type) {
        Class<?> oldType = this.type[0];
        org.eclipse.persistence.expressions.Expression oldQueryExpression = this.queryExpression;
        try {
            this.type[0] = null;
            this.queryExpression = null;
            expression.accept((ExpressionVisitor)this);
            type[0] = this.type[0];
            org.eclipse.persistence.expressions.Expression expression2 = this.queryExpression;
            return expression2;
        }
        finally {
            this.type[0] = oldType;
            this.queryExpression = oldQueryExpression;
        }
    }

    org.eclipse.persistence.expressions.Expression buildGroupByExpression(CollectionValuedPathExpression expression) {
        try {
            PathResolver resolver = new PathResolver();
            resolver.length = expression.pathSize() - 1;
            resolver.nullAllowed = false;
            resolver.checkMappingType = false;
            expression.accept((ExpressionVisitor)resolver);
            org.eclipse.persistence.expressions.Expression expression2 = resolver.localExpression;
            return expression2;
        }
        finally {
            this.type[0] = null;
            this.queryExpression = null;
        }
    }

    org.eclipse.persistence.expressions.Expression buildModifiedPathExpression(StateFieldPathExpression expression) {
        try {
            PathResolver resolver = new PathResolver();
            resolver.length = expression.pathSize();
            resolver.checkMappingType = true;
            expression.accept((ExpressionVisitor)resolver);
            org.eclipse.persistence.expressions.Expression expression2 = resolver.localExpression;
            return expression2;
        }
        finally {
            this.type[0] = null;
            this.queryExpression = null;
        }
    }

    ReportQuery buildSubquery(SimpleSelectStatement expression) {
        ReportQuery subquery = new ReportQuery();
        this.queryContext.newSubQueryContext((Expression)expression, subquery);
        try {
            ReportQueryVisitor visitor = new ReportQueryVisitor(this.queryContext, subquery);
            expression.accept((ExpressionVisitor)visitor);
            this.type[0] = visitor.type;
            this.appendJoinVariables((Expression)expression, subquery);
            ReportQuery reportQuery = subquery;
            return reportQuery;
        }
        finally {
            this.queryContext.disposeSubqueryContext();
        }
    }

    private List<Expression> children(Expression expression) {
        ChildrenExpressionVisitor visitor = this.childrenExpressionVisitor();
        try {
            expression.accept((ExpressionVisitor)visitor);
            LinkedList<Expression> linkedList = new LinkedList<Expression>(visitor.expressions);
            return linkedList;
        }
        finally {
            visitor.expressions.clear();
        }
    }

    private ChildrenExpressionVisitor childrenExpressionVisitor() {
        if (this.childrenExpressionVisitor == null) {
            this.childrenExpressionVisitor = new ChildrenExpressionVisitor();
        }
        return this.childrenExpressionVisitor;
    }

    private Set<String> collectOuterIdentificationVariables() {
        HashSet<String> variableNames = new HashSet<String>(this.queryContext.getUsedIdentificationVariables());
        for (Declaration declaration : this.queryContext.getDeclarations()) {
            variableNames.remove(declaration.getVariableName());
        }
        return variableNames;
    }

    public void visit(AbsExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = ExpressionMath.abs(this.queryExpression);
    }

    public void visit(AbstractSchemaName expression) {
        ClassDescriptor descriptor = this.queryContext.getDescriptor(expression.getText());
        this.type[0] = descriptor.getJavaClass();
        this.queryExpression = new ExpressionBuilder(this.type[0]);
    }

    public void visit(AdditionExpression expression) {
        ArrayList types = new ArrayList(2);
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        types.add(this.type[0]);
        expression.getRightExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        types.add(this.type[0]);
        this.queryExpression = ExpressionMath.add(leftExpression, rightExpression);
        Collections.sort(types, NumericTypeComparator.instance());
        this.type[0] = (Class)types.get(0);
    }

    public void visit(AllOrAnyExpression expression) {
        ReportQuery subquery = this.buildSubquery((SimpleSelectStatement)expression.getExpression());
        String identifier = expression.getIdentifier();
        this.queryExpression = this.queryContext.getBaseExpression();
        if (identifier == "ALL") {
            this.queryExpression = this.queryExpression.all(subquery);
        } else if (identifier == "SOME") {
            this.queryExpression = this.queryExpression.some(subquery);
        } else if (identifier == "ANY") {
            this.queryExpression = this.queryExpression.any(subquery);
        }
    }

    public void visit(AndExpression expression) {
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        expression.getRightExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        this.queryExpression = leftExpression.and(rightExpression);
        this.type[0] = Boolean.class;
    }

    public void visit(ArithmeticFactor expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression arithmeticFactor = this.queryExpression;
        this.queryExpression = new ConstantExpression(0, new ExpressionBuilder());
        this.queryExpression = ExpressionMath.subtract(this.queryExpression, arithmeticFactor);
    }

    public void visit(AsOfClause expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(AvgFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.average();
        this.type[0] = Double.class;
    }

    public void visit(BadExpression expression) {
    }

    public void visit(BetweenExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression resultExpression = this.queryExpression;
        expression.getLowerBoundExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression lowerBoundExpression = this.queryExpression;
        expression.getUpperBoundExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression upperBoundExpression = this.queryExpression;
        this.queryExpression = expression.hasNot() ? resultExpression.notBetween(lowerBoundExpression, upperBoundExpression) : resultExpression.between(lowerBoundExpression, upperBoundExpression);
        this.type[0] = Boolean.class;
    }

    public void visit(CaseExpression expression) {
        org.eclipse.persistence.expressions.Expression caseOperandExpression = null;
        if (expression.hasCaseOperand()) {
            expression.getCaseOperand().accept((ExpressionVisitor)this);
            caseOperandExpression = this.queryExpression;
        }
        WhenClauseExpressionVisitor visitor = this.whenClauseExpressionVisitor();
        try {
            expression.getWhenClauses().accept((ExpressionVisitor)visitor);
            expression.getElseExpression().accept((ExpressionVisitor)this);
            org.eclipse.persistence.expressions.Expression elseExpression = this.queryExpression;
            visitor.types.add(this.type[0]);
            if (caseOperandExpression != null) {
                this.queryExpression = caseOperandExpression.caseStatement(visitor.whenClauses, elseExpression);
            } else {
                this.queryExpression = this.queryContext.getBaseExpression();
                this.queryExpression = this.queryExpression.caseStatement(visitor.whenClauses, elseExpression);
            }
            this.type[0] = this.queryContext.typeResolver().compareCollectionEquivalentTypes(visitor.types);
        }
        finally {
            visitor.dispose();
        }
    }

    public void visit(CastExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        Expression databaseType = expression.getDatabaseType();
        this.queryExpression = this.queryExpression.cast(databaseType.toParsedText());
        this.type[0] = Object.class;
    }

    public void visit(CoalesceExpression expression) {
        ArrayList<org.eclipse.persistence.expressions.Expression> expressions = new ArrayList<org.eclipse.persistence.expressions.Expression>();
        LinkedList types = new LinkedList();
        for (Expression child : expression.getExpression().children()) {
            child.accept((ExpressionVisitor)this);
            expressions.add(this.queryExpression);
            types.add(this.type[0]);
        }
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = this.queryExpression.coalesce(expressions);
        this.type[0] = this.queryContext.typeResolver().compareCollectionEquivalentTypes(types);
    }

    public void visit(CollectionExpression expression) {
    }

    public void visit(CollectionMemberDeclaration expression) {
        expression.getCollectionValuedPathExpression().accept((ExpressionVisitor)this);
    }

    public void visit(CollectionMemberExpression expression) {
        expression.getEntityExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression entityExpression = this.queryExpression;
        if (expression.hasNot()) {
            CollectionValuedPathExpression pathExpression = (CollectionValuedPathExpression)expression.getCollectionValuedPathExpression();
            pathExpression.getIdentificationVariable().accept((ExpressionVisitor)this);
            org.eclipse.persistence.expressions.Expression parentExpression = this.queryExpression;
            ExpressionBuilder newBuilder = new ExpressionBuilder();
            org.eclipse.persistence.expressions.Expression collectionBase = newBuilder;
            int i = 1;
            while (i < pathExpression.pathSize() - 1) {
                collectionBase = collectionBase.get(pathExpression.getPath(i));
                ++i;
            }
            String lastPath = pathExpression.getPath(pathExpression.pathSize() - 1);
            org.eclipse.persistence.expressions.Expression criteria = newBuilder.equal(parentExpression).and(collectionBase.anyOf(lastPath).equal(entityExpression));
            ReportQuery subQuery = new ReportQuery();
            subQuery.setShouldRetrieveFirstPrimaryKey(true);
            subQuery.setSelectionCriteria(criteria);
            subQuery.setReferenceClass(((ExpressionBuilder)parentExpression).getQueryClass());
            this.queryExpression = parentExpression.notExists(subQuery);
        } else {
            expression.getCollectionValuedPathExpression().accept((ExpressionVisitor)this);
            this.queryExpression = this.queryExpression.equal(entityExpression);
        }
    }

    public void visit(CollectionValuedPathExpression expression) {
        this.visitPathExpression((AbstractPathExpression)expression, this.nullAllowed, expression.pathSize());
    }

    public void visit(ComparisonExpression expression) {
        ComparisonExpressionVisitor visitor = new ComparisonExpressionVisitor();
        expression.getLeftExpression().accept((ExpressionVisitor)visitor);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        expression.getRightExpression().accept((ExpressionVisitor)visitor);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        String comparaison = expression.getComparisonOperator();
        if (comparaison == "=") {
            this.queryExpression = leftExpression.equal(rightExpression);
        } else if (comparaison == "<>" || comparaison == "!=") {
            this.queryExpression = leftExpression.notEqual(rightExpression);
        } else if (comparaison == "<") {
            this.queryExpression = leftExpression.lessThan(rightExpression);
        } else if (comparaison == "<=") {
            this.queryExpression = leftExpression.lessThanEqual(rightExpression);
        } else if (comparaison == ">") {
            this.queryExpression = leftExpression.greaterThan(rightExpression);
        } else if (comparaison == ">=") {
            this.queryExpression = leftExpression.greaterThanEqual(rightExpression);
        } else {
            throw new IllegalArgumentException("The comparison operator is unknown: " + comparaison);
        }
        this.type[0] = Boolean.class;
    }

    public void visit(ConcatExpression expression) {
        List<Expression> expressions = this.children(expression.getExpression());
        org.eclipse.persistence.expressions.Expression newExpression = null;
        for (Expression child : expressions) {
            child.accept((ExpressionVisitor)this);
            newExpression = newExpression == null ? this.queryExpression : newExpression.concat(this.queryExpression);
        }
        this.queryExpression = newExpression;
        this.type[0] = Boolean.class;
    }

    public void visit(ConnectByClause expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(ConstructorExpression expression) {
    }

    public void visit(CountFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.count();
        this.type[0] = Long.class;
    }

    public void visit(DatabaseType expression) {
    }

    public void visit(DateTime expression) {
        if (expression.isJDBCDate()) {
            this.queryExpression = this.queryContext.getBaseExpression();
            this.queryExpression = new DateConstantExpression(expression.getText(), this.queryExpression);
            String text = expression.getText();
            this.type[0] = text.startsWith("{d") ? Date.class : (text.startsWith("{ts") ? Timestamp.class : (text.startsWith("{t") ? Time.class : Object.class));
        } else {
            this.queryExpression = this.queryContext.getBaseExpression();
            if (expression.isCurrentDate()) {
                this.queryExpression = this.queryExpression.currentDateDate();
                this.type[0] = Date.class;
            } else if (expression.isCurrentTime()) {
                this.queryExpression = this.queryExpression.currentTime();
                this.type[0] = Time.class;
            } else if (expression.isCurrentTimestamp()) {
                this.queryExpression = this.queryExpression.currentTimeStamp();
                this.type[0] = Timestamp.class;
            } else {
                throw new IllegalArgumentException("The DateTime is unknown: " + expression);
            }
        }
    }

    public void visit(DeleteClause expression) {
    }

    public void visit(DeleteStatement expression) {
    }

    public void visit(DivisionExpression expression) {
        ArrayList types = new ArrayList(2);
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        types.add(this.type[0]);
        expression.getRightExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        types.add(this.type[0]);
        this.queryExpression = ExpressionMath.divide(leftExpression, rightExpression);
        Collections.sort(types, NumericTypeComparator.instance());
        this.type[0] = (Class)types.get(0);
    }

    public void visit(EmptyCollectionComparisonExpression expression) {
        CollectionValuedPathExpression collectionPath = (CollectionValuedPathExpression)expression.getExpression();
        int lastPathIndex = collectionPath.pathSize() - 1;
        String name = collectionPath.getPath(lastPathIndex);
        this.visitPathExpression((AbstractPathExpression)collectionPath, false, lastPathIndex);
        this.queryExpression = expression.hasNot() ? this.queryExpression.notEmpty(name) : this.queryExpression.isEmpty(name);
        this.type[0] = Boolean.class;
    }

    public void visit(EntityTypeLiteral expression) {
        ClassDescriptor descriptor = this.queryContext.getDescriptor(expression.getEntityTypeName());
        this.type[0] = descriptor.getJavaClass();
        this.queryExpression = new ConstantExpression(this.type[0], this.queryContext.getBaseExpression());
    }

    public void visit(EntryExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        MapEntryExpression entryExpression = new MapEntryExpression(this.queryExpression);
        entryExpression.returnMapEntry();
        this.queryExpression = entryExpression;
        this.type[0] = Map.Entry.class;
    }

    public void visit(ExistsExpression expression) {
        ReportQuery subquery = this.buildSubquery((SimpleSelectStatement)expression.getExpression());
        for (ReportItem item : subquery.getItems()) {
            org.eclipse.persistence.expressions.Expression expr = item.getAttributeExpression();
            subquery.addNonFetchJoinedAttribute(expr);
        }
        subquery.clearItems();
        ConstantExpression one = new ConstantExpression(1, new ExpressionBuilder());
        subquery.addItem("one", one);
        subquery.dontUseDistinct();
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = expression.hasNot() ? this.queryExpression.notExists(subquery) : this.queryExpression.exists(subquery);
        this.type[0] = Boolean.class;
    }

    public void visit(ExtractExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.extract(expression.getDatePart());
        this.type[0] = Object.class;
    }

    public void visit(FromClause expression) {
    }

    public void visit(FunctionExpression expression) {
        String identifier = expression.getIdentifier();
        String functionName = expression.getUnquotedFunctionName();
        if (identifier == "COLUMN") {
            expression.getExpression().accept((ExpressionVisitor)this);
            this.queryExpression = this.queryExpression.getField(functionName);
        } else {
            List<Expression> expressions = this.children(expression.getExpression());
            if (expressions.isEmpty()) {
                this.queryExpression = this.queryContext.getBaseExpression();
                this.queryExpression = identifier == "SQL" ? this.queryExpression.literal(functionName) : this.queryExpression.getFunction(functionName);
            } else {
                ArrayList<org.eclipse.persistence.expressions.Expression> queryExpressions = new ArrayList<org.eclipse.persistence.expressions.Expression>(expressions.size());
                for (Expression child : expressions) {
                    child.accept((ExpressionVisitor)this);
                    queryExpressions.add(this.queryExpression);
                }
                this.queryExpression = (org.eclipse.persistence.expressions.Expression)queryExpressions.remove(0);
                this.queryExpression = identifier == "SQL" ? this.queryExpression.sql(functionName, queryExpressions) : (identifier == "OPERATOR" ? this.queryExpression.operator(functionName, queryExpressions) : this.queryExpression.getFunctionWithArguments(functionName, queryExpressions));
            }
        }
        this.type[0] = Object.class;
    }

    public void visit(GroupByClause expression) {
    }

    public void visit(HavingClause expression) {
        expression.getConditionalExpression().accept((ExpressionVisitor)this);
    }

    public void visit(HierarchicalQueryClause expression) {
    }

    public void visit(IdentificationVariable expression) {
        StateFieldPathExpression stateFieldPathExpression;
        if (expression.isVirtual() && (stateFieldPathExpression = expression.getStateFieldPathExpression()) != null) {
            stateFieldPathExpression.accept((ExpressionVisitor)this);
            return;
        }
        String variableName = expression.getVariableName();
        this.queryExpression = this.queryContext.findQueryExpression(variableName);
        Declaration declaration = this.queryContext.findDeclaration(variableName);
        if (declaration != null) {
            if (this.queryExpression == null) {
                declaration.getBaseExpression().accept((ExpressionVisitor)this);
                this.queryContext.addQueryExpression(variableName, this.queryExpression);
            }
            if (declaration.getType() == JPQLQueryDeclaration.Type.RANGE) {
                this.type[0] = declaration.getDescriptor().getJavaClass();
            }
        }
    }

    public void visit(IdentificationVariableDeclaration expression) {
    }

    public void visit(IndexExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.index();
        this.type[0] = Integer.class;
    }

    public void visit(InExpression expression) {
        InExpressionExpressionBuilder visitor1 = new InExpressionExpressionBuilder();
        expression.getExpression().accept((ExpressionVisitor)visitor1);
        InExpressionBuilder visitor2 = new InExpressionBuilder();
        visitor2.hasNot = expression.hasNot();
        visitor2.singleInputParameter = expression.isSingleInputParameter();
        visitor2.leftExpression = this.queryExpression;
        expression.getInItems().accept((ExpressionVisitor)visitor2);
        this.type[0] = Boolean.class;
    }

    public void visit(InputParameter expression) {
        String parameterName = expression.getParameter();
        Class<?> type = this.queryContext.getParameterType(expression);
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = this.queryExpression.getParameter(parameterName.substring(1), type);
        this.queryContext.addInputParameter(expression, this.queryExpression);
    }

    public void visit(Join expression) {
        try {
            this.nullAllowed = expression.isLeftJoin();
            expression.getJoinAssociationPath().accept((ExpressionVisitor)this);
        }
        finally {
            this.nullAllowed = false;
        }
    }

    public void visit(JPQLExpression expression) {
    }

    public void visit(KeyExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = new MapEntryExpression(this.queryExpression);
    }

    public void visit(KeywordExpression expression) {
        Boolean value;
        String keyword = expression.getText();
        if (keyword == "NULL") {
            value = null;
            this.type[0] = Object.class;
        } else if (keyword == "TRUE") {
            value = Boolean.TRUE;
            this.type[0] = Boolean.class;
        } else {
            value = Boolean.FALSE;
            this.type[0] = Boolean.class;
        }
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = new ConstantExpression(value, this.queryExpression);
    }

    public void visit(LengthExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.length();
        this.type[0] = Integer.class;
    }

    public void visit(LikeExpression expression) {
        expression.getStringExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression firstExpression = this.queryExpression;
        expression.getPatternValue().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression patternValue = this.queryExpression;
        if (expression.hasEscapeCharacter()) {
            expression.getEscapeCharacter().accept((ExpressionVisitor)this);
            this.queryExpression = firstExpression.like(patternValue, this.queryExpression);
        } else {
            this.queryExpression = firstExpression.like(patternValue);
        }
        if (expression.hasNot()) {
            this.queryExpression = this.queryExpression.not();
        }
        this.type[0] = Boolean.class;
    }

    public void visit(LocateExpression expression) {
        expression.getFirstExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression findExpression = this.queryExpression;
        expression.getSecondExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression findInExpression = this.queryExpression;
        expression.getThirdExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression startPositionExpression = this.queryExpression;
        this.queryExpression = startPositionExpression != null ? findInExpression.locate(findExpression, startPositionExpression) : findInExpression.locate(findExpression);
        this.type[0] = Integer.class;
    }

    public void visit(LowerExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.toLowerCase();
        this.type[0] = String.class;
    }

    public void visit(MaxFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.maximum();
    }

    public void visit(MinFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.minimum();
    }

    public void visit(ModExpression expression) {
        expression.getFirstExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        expression.getSecondExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        this.queryExpression = ExpressionMath.mod(leftExpression, rightExpression);
        this.type[0] = Integer.class;
    }

    public void visit(MultiplicationExpression expression) {
        ArrayList types = new ArrayList(2);
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        types.add(this.type[0]);
        expression.getRightExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        types.add(this.type[0]);
        this.queryExpression = ExpressionMath.multiply(leftExpression, rightExpression);
        Collections.sort(types, NumericTypeComparator.instance());
        this.type[0] = (Class)types.get(0);
    }

    public void visit(NotExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.not();
        this.type[0] = Boolean.class;
    }

    public void visit(NullComparisonExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = expression.hasNot() ? this.queryExpression.notNull() : this.queryExpression.isNull();
        this.type[0] = Boolean.class;
    }

    public void visit(NullExpression expression) {
        this.queryExpression = null;
        this.type[0] = null;
    }

    public void visit(NullIfExpression expression) {
        expression.getFirstExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression firstExpression = this.queryExpression;
        Class<?> actualType = this.type[0];
        expression.getSecondExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression secondExpression = this.queryExpression;
        this.queryExpression = firstExpression.nullIf(secondExpression);
        this.type[0] = actualType;
    }

    public void visit(NumericLiteral expression) {
        this.type[0] = this.queryContext.getType((Expression)expression);
        String text = expression.getText();
        if (this.type[0] == Long.class && (text.endsWith("L") || text.endsWith("l"))) {
            text = text.substring(0, text.length() - 1);
        }
        Number number = (Number)this.queryContext.newInstance(this.type[0], String.class, text);
        this.queryExpression = new ConstantExpression(number, this.queryContext.getBaseExpression());
    }

    public void visit(ObjectExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(OnClause expression) {
        expression.getConditionalExpression().accept((ExpressionVisitor)this);
    }

    public void visit(OrderByClause expression) {
    }

    public void visit(OrderByItem expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        switch (expression.getOrdering()) {
            case ASC: {
                this.queryExpression = this.queryExpression.ascending();
                break;
            }
            case DESC: {
                this.queryExpression = this.queryExpression.descending();
            }
        }
        switch (expression.getNullOrdering()) {
            case NULLS_FIRST: {
                this.queryExpression = this.queryExpression.nullsFirst();
                break;
            }
            case NULLS_LAST: {
                this.queryExpression = this.queryExpression.nullsLast();
            }
        }
    }

    public void visit(OrderSiblingsByClause expression) {
        expression.getOrderByItems().accept((ExpressionVisitor)this);
    }

    public void visit(OrExpression expression) {
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        expression.getRightExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        this.queryExpression = leftExpression.or(rightExpression);
        this.type[0] = Boolean.class;
    }

    public void visit(RangeVariableDeclaration expression) {
        IdentificationVariable variable = (IdentificationVariable)expression.getIdentificationVariable();
        Declaration declaration = this.queryContext.getDeclaration(variable.getVariableName());
        switch (declaration.getType()) {
            case CLASS_NAME: 
            case RANGE: {
                this.type[0] = declaration.getDescriptor().getJavaClass();
                this.queryExpression = new ExpressionBuilder(this.type[0]);
                break;
            }
            case SUBQUERY: {
                this.type[0] = null;
                this.queryExpression = declaration.getQueryExpression();
                break;
            }
            default: {
                expression.getRootObject().accept((ExpressionVisitor)this);
            }
        }
    }

    public void visit(RegexpExpression expression) {
        expression.getStringExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression firstExpression = this.queryExpression;
        expression.getPatternValue().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression patternValue = this.queryExpression;
        this.queryExpression = firstExpression.regexp(patternValue);
        this.type[0] = Boolean.class;
    }

    public void visit(ResultVariable expression) {
        expression.getSelectExpression().accept((ExpressionVisitor)this);
        IdentificationVariable identificationVariable = (IdentificationVariable)expression.getResultVariable();
        String variableName = identificationVariable.getVariableName();
        this.queryContext.addQueryExpression(variableName, this.queryExpression);
    }

    public void visit(SelectClause expression) {
    }

    public void visit(SelectStatement expression) {
    }

    public void visit(SimpleFromClause expression) {
    }

    public void visit(SimpleSelectClause expression) {
    }

    public void visit(SimpleSelectStatement expression) {
        ReportQuery subquery = this.buildSubquery(expression);
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = this.queryExpression.subQuery(subquery);
    }

    public void visit(SizeExpression expression) {
        CollectionValuedPathExpression pathExpression = (CollectionValuedPathExpression)expression.getExpression();
        int lastIndex = pathExpression.pathSize() - 1;
        this.visitPathExpression((AbstractPathExpression)pathExpression, false, lastIndex - 1);
        String name = pathExpression.getPath(lastIndex);
        this.queryExpression = this.queryExpression.size(name);
        this.type[0] = Integer.class;
    }

    public void visit(SqrtExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = ExpressionMath.sqrt(this.queryExpression);
        this.type[0] = Double.class;
    }

    public void visit(StartWithClause expression) {
        expression.getConditionalExpression().accept((ExpressionVisitor)this);
    }

    public void visit(StateFieldPathExpression expression) {
        this.visitPathExpression((AbstractPathExpression)expression, false, expression.pathSize());
    }

    public void visit(StringLiteral expression) {
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = new ConstantExpression(expression.getUnquotedText(), this.queryExpression);
        this.type[0] = String.class;
    }

    public void visit(SubExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(SubstringExpression expression) {
        expression.getFirstExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression firstExpression = this.queryExpression;
        expression.getSecondExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression secondExpression = this.queryExpression;
        expression.getThirdExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression thirdExpression = this.queryExpression;
        this.queryExpression = thirdExpression != null ? firstExpression.substring(secondExpression, thirdExpression) : firstExpression.substring(secondExpression);
        this.type[0] = String.class;
    }

    public void visit(SubtractionExpression expression) {
        ArrayList types = new ArrayList(2);
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        types.add(this.type[0]);
        expression.getRightExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        types.add(this.type[0]);
        this.queryExpression = ExpressionMath.subtract(leftExpression, rightExpression);
        Collections.sort(types, NumericTypeComparator.instance());
        this.type[0] = (Class)types.get(0);
    }

    public void visit(SumFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.sum();
        this.type[0] = this.queryContext.typeResolver().convertSumFunctionType(this.type[0]);
    }

    public void visit(TableExpression expression) {
        String tableName = this.queryContext.literal(expression.getExpression(), LiteralType.STRING_LITERAL);
        tableName = ExpressionTools.unquote((String)tableName);
        this.queryExpression = this.queryContext.getBaseExpression().getTable(tableName);
    }

    public void visit(TableVariableDeclaration expression) {
    }

    public void visit(TreatExpression expression) {
        expression.getCollectionValuedPathExpression().accept((ExpressionVisitor)this);
        EntityTypeLiteral entityTypeLiteral = (EntityTypeLiteral)expression.getEntityType();
        ClassDescriptor entityType = this.queryContext.getDescriptor(entityTypeLiteral.getEntityTypeName());
        this.queryExpression = this.queryExpression.treat(entityType.getJavaClass());
    }

    public void visit(TrimExpression expression) {
        expression.getTrimCharacter().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression trimCharacter = this.queryExpression;
        expression.getExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression stringExpression = this.queryExpression;
        switch (expression.getSpecification()) {
            case LEADING: {
                if (trimCharacter != null) {
                    this.queryExpression = stringExpression.leftTrim(trimCharacter);
                    break;
                }
                this.queryExpression = stringExpression.leftTrim();
                break;
            }
            case TRAILING: {
                if (trimCharacter != null) {
                    this.queryExpression = stringExpression.rightTrim(trimCharacter);
                    break;
                }
                this.queryExpression = stringExpression.rightTrim();
                break;
            }
            default: {
                this.queryExpression = trimCharacter != null ? stringExpression.trim(trimCharacter) : stringExpression.trim();
            }
        }
        this.type[0] = String.class;
    }

    public void visit(TypeExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.type();
    }

    public void visit(UnionClause expression) {
    }

    public void visit(UnknownExpression expression) {
        this.queryExpression = null;
    }

    public void visit(UpdateClause expression) {
    }

    public void visit(UpdateItem expression) {
    }

    public void visit(UpdateStatement expression) {
    }

    public void visit(UpperExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.toUpperCase();
        this.type[0] = String.class;
    }

    public void visit(ValueExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(WhenClause expression) {
    }

    public void visit(WhereClause expression) {
        expression.getConditionalExpression().accept((ExpressionVisitor)this);
    }

    private void visitPathExpression(AbstractPathExpression expression, boolean nullAllowed, int lastIndex) {
        PathResolver resolver = new PathResolver();
        resolver.length = lastIndex;
        resolver.nullAllowed = nullAllowed;
        resolver.checkMappingType = false;
        resolver.localExpression = null;
        resolver.descriptor = null;
        expression.accept((ExpressionVisitor)resolver);
        this.queryExpression = resolver.localExpression;
    }

    private WhenClauseExpressionVisitor whenClauseExpressionVisitor() {
        if (this.whenClauseExpressionVisitor == null) {
            this.whenClauseExpressionVisitor = new WhenClauseExpressionVisitor();
        }
        return this.whenClauseExpressionVisitor;
    }

    private static class ChildrenExpressionVisitor
    extends AnonymousExpressionVisitor {
        List<Expression> expressions = new ArrayList<Expression>();

        ChildrenExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            for (Expression child : expression.children()) {
                this.expressions.add(child);
            }
        }

        public void visit(NullExpression expression) {
        }

        protected void visit(Expression expression) {
            this.expressions.add(expression);
        }
    }

    private class ComparisonExpressionVisitor
    extends EclipseLinkAnonymousExpressionVisitor {
        private ComparisonExpressionVisitor() {
        }

        public void visit(IdentificationVariable expression) {
            ClassDescriptor descriptor;
            boolean found = false;
            if (!expression.isVirtual() && (descriptor = ExpressionBuilderVisitor.this.queryContext.getDescriptor(expression.getText())) != null) {
                ((ExpressionBuilderVisitor)ExpressionBuilderVisitor.this).type[0] = descriptor.getJavaClass();
                ExpressionBuilderVisitor.this.queryExpression = new ConstantExpression(ExpressionBuilderVisitor.this.type[0], ExpressionBuilderVisitor.this.queryContext.getBaseExpression());
                found = true;
            }
            if (!found) {
                expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            }
        }

        protected void visit(Expression expression) {
            expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
        }
    }

    private class InExpressionBuilder
    extends EclipseLinkAnonymousExpressionVisitor {
        private boolean hasNot;
        private org.eclipse.persistence.expressions.Expression leftExpression;
        private boolean singleInputParameter;

        InExpressionBuilder() {
        }

        public void visit(CollectionExpression expression) {
            ArrayList<org.eclipse.persistence.expressions.Expression> expressions = new ArrayList<org.eclipse.persistence.expressions.Expression>();
            InItemExpressionVisitor visitor = new InItemExpressionVisitor();
            for (Expression child : expression.children()) {
                child.accept((ExpressionVisitor)visitor);
                expressions.add(ExpressionBuilderVisitor.this.queryExpression);
            }
            if (this.hasNot) {
                ExpressionBuilderVisitor.this.queryExpression = this.leftExpression.notIn(expressions);
            } else {
                ExpressionBuilderVisitor.this.queryExpression = this.leftExpression.in(expressions);
            }
        }

        public void visit(IdentificationVariable expression) {
            ClassDescriptor descriptor;
            boolean found = false;
            if (!expression.isVirtual() && (descriptor = ExpressionBuilderVisitor.this.queryContext.getDescriptor(expression.getText())) != null) {
                ((ExpressionBuilderVisitor)ExpressionBuilderVisitor.this).type[0] = descriptor.getJavaClass();
                ExpressionBuilderVisitor.this.queryExpression = new ConstantExpression(ExpressionBuilderVisitor.this.type[0], ExpressionBuilderVisitor.this.queryContext.getBaseExpression());
                found = true;
            }
            if (!found) {
                expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            }
        }

        public void visit(InputParameter expression) {
            if (this.singleInputParameter) {
                String parameterName = expression.getParameter();
                ExpressionBuilderVisitor.this.queryExpression = ExpressionBuilderVisitor.this.queryContext.getBaseExpression();
                ExpressionBuilderVisitor.this.queryExpression = ExpressionBuilderVisitor.this.queryExpression.getParameter(parameterName.substring(1), Collection.class);
                ExpressionBuilderVisitor.this.queryContext.addInputParameter(expression, ExpressionBuilderVisitor.this.queryExpression);
                if (this.hasNot) {
                    ExpressionBuilderVisitor.this.queryExpression = this.leftExpression.notIn(ExpressionBuilderVisitor.this.queryExpression);
                } else {
                    ExpressionBuilderVisitor.this.queryExpression = this.leftExpression.in(ExpressionBuilderVisitor.this.queryExpression);
                }
            } else {
                this.visit((Expression)expression);
            }
        }

        protected void visit(Expression expression) {
            expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            ArrayList<org.eclipse.persistence.expressions.Expression> expressions = new ArrayList<org.eclipse.persistence.expressions.Expression>();
            expressions.add(ExpressionBuilderVisitor.this.queryExpression);
            if (this.hasNot) {
                ExpressionBuilderVisitor.this.queryExpression = this.leftExpression.notIn(expressions);
            } else {
                ExpressionBuilderVisitor.this.queryExpression = this.leftExpression.in(expressions);
            }
        }

        public void visit(SimpleSelectStatement expression) {
            ReportQuery subquery = ExpressionBuilderVisitor.this.buildSubquery(expression);
            if (this.hasNot) {
                ExpressionBuilderVisitor.this.queryExpression = this.leftExpression.notIn(subquery);
            } else {
                ExpressionBuilderVisitor.this.queryExpression = this.leftExpression.in(subquery);
            }
        }

        private class InItemExpressionVisitor
        extends AnonymousExpressionVisitor {
            private InItemExpressionVisitor() {
            }

            public void visit(IdentificationVariable expression) {
                ClassDescriptor descriptor = ExpressionBuilderVisitor.this.queryContext.getDescriptor(expression.getVariableName());
                ExpressionBuilderVisitor.this.queryExpression = ExpressionBuilderVisitor.this.queryContext.getBaseExpression();
                ExpressionBuilderVisitor.this.queryExpression = new ConstantExpression(descriptor.getJavaClass(), ExpressionBuilderVisitor.this.queryExpression);
            }

            public void visit(CollectionExpression expression) {
                LinkedList<org.eclipse.persistence.expressions.Expression> children = new LinkedList<org.eclipse.persistence.expressions.Expression>();
                for (Expression child : expression.children()) {
                    child.accept((ExpressionVisitor)this);
                    children.add(ExpressionBuilderVisitor.this.queryExpression);
                }
                ExpressionBuilderVisitor.this.queryExpression = new ConstantExpression(children, ExpressionBuilderVisitor.this.queryContext.getBaseExpression());
            }

            public void visit(SubExpression expression) {
                expression.getExpression().accept((ExpressionVisitor)this);
            }

            protected void visit(Expression expression) {
                expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            }
        }
    }

    private class InExpressionExpressionBuilder
    extends EclipseLinkAnonymousExpressionVisitor {
        private InExpressionExpressionBuilder() {
        }

        public void visit(CollectionExpression expression) {
            LinkedList<org.eclipse.persistence.expressions.Expression> children = new LinkedList<org.eclipse.persistence.expressions.Expression>();
            for (Expression child : expression.children()) {
                child.accept((ExpressionVisitor)this);
                children.add(ExpressionBuilderVisitor.this.queryExpression);
            }
            ExpressionBuilderVisitor.this.queryExpression = new ConstantExpression(children, ExpressionBuilderVisitor.this.queryContext.getBaseExpression());
        }

        public void visit(Expression expression) {
            expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
        }

        public void visit(SubExpression expression) {
            expression.getExpression().accept((ExpressionVisitor)this);
        }
    }

    private class PathResolver
    extends AbstractEclipseLinkExpressionVisitor {
        boolean checkMappingType;
        private Declaration declaration;
        private ClassDescriptor descriptor;
        int length;
        org.eclipse.persistence.expressions.Expression localExpression;
        boolean nullAllowed;

        private PathResolver() {
        }

        private void resolveColumn(AbstractPathExpression expression) {
            String path = expression.getPath(1);
            this.localExpression = this.localExpression.getField(path);
        }

        protected boolean resolveEnumConstant(AbstractPathExpression expression) {
            String fullPath = expression.toParsedText();
            Class<?> enumType = ExpressionBuilderVisitor.this.queryContext.getEnumType(fullPath);
            if (enumType != null) {
                ((ExpressionBuilderVisitor)ExpressionBuilderVisitor.this).type[0] = enumType;
                String path = expression.getPath(expression.pathSize() - 1);
                Enum<?> enumConstant = this.retrieveEnumConstant(enumType, path);
                this.localExpression = new ConstantExpression(enumConstant, new ExpressionBuilder());
                return true;
            }
            return false;
        }

        private void resolvePath(AbstractPathExpression expression) {
            int index = expression.hasVirtualIdentificationVariable() ? 0 : 1;
            int count = this.length;
            while (index < count) {
                String path = expression.getPath(index);
                DatabaseMapping mapping = this.descriptor.getObjectBuilder().getMappingForAttributeName(path);
                boolean last = index + 1 == count;
                boolean collectionMapping = false;
                if (mapping != null) {
                    if (ExpressionBuilderVisitor.this.type != null) {
                        ((ExpressionBuilderVisitor)ExpressionBuilderVisitor.this).type[0] = ExpressionBuilderVisitor.this.queryContext.calculateMappingType(mapping);
                    }
                    collectionMapping = mapping.isCollectionMapping();
                    if (!last) {
                        this.descriptor = mapping.getReferenceDescriptor();
                    } else if (this.checkMappingType) {
                        this.nullAllowed = mapping.isForeignReferenceMapping();
                    }
                } else {
                    QueryKey queryKey = this.descriptor.getQueryKeyNamed(path);
                    if (queryKey == null) break;
                    if (ExpressionBuilderVisitor.this.type != null) {
                        ((ExpressionBuilderVisitor)ExpressionBuilderVisitor.this).type[0] = ExpressionBuilderVisitor.this.queryContext.calculateQueryKeyType(queryKey);
                    }
                    collectionMapping = queryKey.isCollectionQueryKey();
                    if (!last && queryKey.isForeignReferenceQueryKey()) {
                        ForeignReferenceQueryKey referenceQueryKey = (ForeignReferenceQueryKey)queryKey;
                        this.descriptor = ExpressionBuilderVisitor.this.queryContext.getDescriptor(referenceQueryKey.getReferenceClass());
                    }
                }
                this.localExpression = collectionMapping ? (last && this.nullAllowed ? this.localExpression.anyOfAllowingNone(path) : this.localExpression.anyOf(path)) : (last && this.nullAllowed ? this.localExpression.getAllowingNull(path) : this.localExpression.get(path));
                ++index;
            }
        }

        private void resolveVirtualPath(AbstractPathExpression expression) {
            String path = expression.getPath(1);
            this.localExpression = this.localExpression.get(path);
        }

        private Enum<?> retrieveEnumConstant(Class<?> type, String name) {
            Enum[] enumArray = (Enum[])type.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum enumConstant = enumArray[n2];
                if (name.equals(enumConstant.name())) {
                    return enumConstant;
                }
                ++n2;
            }
            return null;
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.visitPathExpression((AbstractPathExpression)expression);
        }

        public void visit(EntryExpression expression) {
            IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
            String variableName = identificationVariable.getVariableName();
            this.declaration = ExpressionBuilderVisitor.this.queryContext.findDeclaration(variableName);
            this.declaration.getBaseExpression().accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            this.localExpression = ExpressionBuilderVisitor.this.queryExpression;
            MapEntryExpression entryExpression = new MapEntryExpression(this.localExpression);
            entryExpression.returnMapEntry();
            this.localExpression = entryExpression;
        }

        public void visit(IdentificationVariable expression) {
            expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            this.localExpression = ExpressionBuilderVisitor.this.queryExpression;
            if (this.localExpression != null) {
                this.declaration = ExpressionBuilderVisitor.this.queryContext.findDeclaration(expression.getVariableName());
                this.descriptor = this.declaration.getDescriptor();
            }
        }

        public void visit(KeyExpression expression) {
            IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
            identificationVariable.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            this.localExpression = new MapEntryExpression(ExpressionBuilderVisitor.this.queryExpression);
            this.descriptor = ExpressionBuilderVisitor.this.queryContext.resolveDescriptor((Expression)expression);
        }

        public void visit(StateFieldPathExpression expression) {
            this.visitPathExpression((AbstractPathExpression)expression);
        }

        public void visit(TreatExpression expression) {
            expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            this.localExpression = ExpressionBuilderVisitor.this.queryExpression;
            this.descriptor = ExpressionBuilderVisitor.this.queryContext.resolveDescriptor((Expression)expression);
        }

        public void visit(ValueExpression expression) {
            IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
            identificationVariable.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            this.localExpression = ExpressionBuilderVisitor.this.queryExpression;
            this.declaration = ExpressionBuilderVisitor.this.queryContext.findDeclaration(identificationVariable.getVariableName());
            this.descriptor = this.declaration.getDescriptor();
        }

        private void visitPathExpression(AbstractPathExpression expression) {
            boolean result;
            expression.getIdentificationVariable().accept((ExpressionVisitor)this);
            if (this.declaration != null && this.declaration.getType() == JPQLQueryDeclaration.Type.SUBQUERY) {
                this.resolveVirtualPath(expression);
                return;
            }
            if (this.localExpression == null && (result = this.resolveEnumConstant(expression))) {
                return;
            }
            if (this.declaration != null && this.declaration.getType() == JPQLQueryDeclaration.Type.TABLE) {
                this.resolveColumn(expression);
                return;
            }
            this.resolvePath(expression);
        }
    }

    private class WhenClauseExpressionVisitor
    extends AbstractExpressionVisitor {
        final List<Class<?>> types = new LinkedList();
        Map<org.eclipse.persistence.expressions.Expression, org.eclipse.persistence.expressions.Expression> whenClauses = new LinkedHashMap<org.eclipse.persistence.expressions.Expression, org.eclipse.persistence.expressions.Expression>();

        WhenClauseExpressionVisitor() {
        }

        void dispose() {
            this.types.clear();
            this.whenClauses.clear();
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren((ExpressionVisitor)this);
        }

        public void visit(WhenClause expression) {
            expression.getWhenExpression().accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            org.eclipse.persistence.expressions.Expression whenExpression = ExpressionBuilderVisitor.this.queryExpression;
            this.types.add(ExpressionBuilderVisitor.this.type[0]);
            expression.getThenExpression().accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            org.eclipse.persistence.expressions.Expression thenExpression = ExpressionBuilderVisitor.this.queryExpression;
            this.whenClauses.put(whenExpression, thenExpression);
        }
    }
}

