/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.internal.context;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.nosql.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkConvertValidator
implements JptValidator {
    protected final EclipseLinkConvert convert;

    public EclipseLinkConvertValidator(EclipseLinkConvert convert) {
        this.convert = convert;
    }

    protected AttributeMapping getAttributeMapping() {
        return this.convert.getParent();
    }

    protected EclipseLinkPersistenceUnit getPersistenceUnit() {
        return this.convert.getPersistenceUnit();
    }

    public boolean validate(List<IMessage> messages, IReporter reporter) {
        return this.validateConverterName(messages);
    }

    private boolean validateConverterName(List<IMessage> messages) {
        String converterName = this.convert.getConverterName();
        if (converterName == null) {
            return true;
        }
        if (IterableTools.contains(this.getPersistenceUnit().getUniqueConverterNames(), (Object)converterName)) {
            return true;
        }
        if (ArrayTools.contains((Object[])EclipseLinkConvert.RESERVED_CONVERTER_NAMES, (Object)converterName)) {
            return true;
        }
        messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "ID_MAPPING_UNRESOLVED_CONVERTER_NAME", new String[]{converterName, this.getAttributeMapping().getName()}, (JpaNode)this.getAttributeMapping(), this.getValidationTextRange()));
        return false;
    }

    protected TextRange getValidationTextRange() {
        return this.getAttributeMapping().getPersistentAttribute().isVirtual() ? this.getVirtualValidationTextRange() : this.convert.getValidationTextRange();
    }

    protected TextRange getVirtualValidationTextRange() {
        return this.getAttributeMapping().getPersistentAttribute().getValidationTextRange();
    }
}

