/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.internal.context.java;

import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkChangeTrackingAnnotation;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkChangeTracking;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkChangeTrackingType;

public class JavaEclipseLinkChangeTracking
extends AbstractJavaJpaContextNode
implements EclipseLinkChangeTracking {
    protected EclipseLinkChangeTrackingType specifiedType = this.buildSpecifiedType();

    public JavaEclipseLinkChangeTracking(JavaTypeMapping parent) {
        super((JpaContextNode)parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedType_(this.buildSpecifiedType());
    }

    public EclipseLinkChangeTrackingType getType() {
        return this.specifiedType != null ? this.specifiedType : this.getDefaultType();
    }

    public EclipseLinkChangeTrackingType getSpecifiedType() {
        return this.specifiedType;
    }

    public void setSpecifiedType(EclipseLinkChangeTrackingType type) {
        if (this.valuesAreDifferent((Object)type, (Object)this.specifiedType)) {
            EclipseLinkChangeTrackingAnnotation annotation = this.getChangeTrackingAnnotation();
            if (type == null) {
                if (annotation != null) {
                    this.removeChangeTrackingAnnotation();
                }
            } else {
                if (annotation == null) {
                    annotation = this.addChangeTrackingAnnotation();
                }
                annotation.setValue(EclipseLinkChangeTrackingType.toJavaResourceModel(type));
            }
            this.setSpecifiedType_(type);
        }
    }

    protected void setSpecifiedType_(EclipseLinkChangeTrackingType type) {
        EclipseLinkChangeTrackingType old = this.specifiedType;
        this.specifiedType = type;
        this.firePropertyChanged("specifiedType", (Object)old, (Object)type);
    }

    protected EclipseLinkChangeTrackingType buildSpecifiedType() {
        EclipseLinkChangeTrackingAnnotation annotation = this.getChangeTrackingAnnotation();
        if (annotation == null) {
            return null;
        }
        ChangeTrackingType value = annotation.getValue();
        return value == null ? DEFAULT_TYPE : EclipseLinkChangeTrackingType.fromJavaResourceModel(value);
    }

    public EclipseLinkChangeTrackingType getDefaultType() {
        return DEFAULT_TYPE;
    }

    protected EclipseLinkChangeTrackingAnnotation getChangeTrackingAnnotation() {
        return (EclipseLinkChangeTrackingAnnotation)this.getJavaResourceType().getAnnotation(this.getChangeTrackingAnnotationName());
    }

    protected EclipseLinkChangeTrackingAnnotation addChangeTrackingAnnotation() {
        return (EclipseLinkChangeTrackingAnnotation)this.getJavaResourceType().addAnnotation(this.getChangeTrackingAnnotationName());
    }

    protected void removeChangeTrackingAnnotation() {
        this.getJavaResourceType().removeAnnotation(this.getChangeTrackingAnnotationName());
    }

    protected String getChangeTrackingAnnotationName() {
        return "org.eclipse.persistence.annotations.ChangeTracking";
    }

    public JavaTypeMapping getParent() {
        return (JavaTypeMapping)super.getParent();
    }

    protected JavaTypeMapping getTypeMapping() {
        return this.getParent();
    }

    protected JavaPersistentType getPersistentType() {
        return this.getTypeMapping().getPersistentType();
    }

    protected JavaResourceType getJavaResourceType() {
        return this.getPersistentType().getJavaResourceType();
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getAnnotationTextRange();
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange();
    }

    protected TextRange getAnnotationTextRange() {
        EclipseLinkChangeTrackingAnnotation annotation = this.getChangeTrackingAnnotation();
        return annotation == null ? null : annotation.getTextRange();
    }
}

