/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextNode;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkNamedConverterAnnotation;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.nosql.eclipselink.core.context.java.JavaEclipseLinkConverterContainer;
import org.eclipse.jpt.nosql.eclipselink.core.context.orm.OrmEclipseLinkConverterContainer;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.nosql.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaEclipseLinkConverter<A extends EclipseLinkNamedConverterAnnotation>
extends AbstractJavaJpaContextNode
implements EclipseLinkConverter {
    protected final A converterAnnotation;
    protected String name;

    protected JavaEclipseLinkConverter(JpaContextNode parent, A converterAnnotation) {
        super(parent);
        this.converterAnnotation = converterAnnotation;
        this.name = converterAnnotation.getName();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.converterAnnotation.getName());
    }

    public void update() {
        super.update();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.converterAnnotation.setName(name);
        this.setName_(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    public JavaEclipseLinkConverterContainer getParent() {
        return (JavaEclipseLinkConverterContainer)super.getParent();
    }

    public A getConverterAnnotation() {
        return this.converterAnnotation;
    }

    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    @Override
    public char getEnclosingTypeSeparator() {
        return '.';
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public boolean supportsValidationMessages() {
        return MappingTools.nodeIsInternalSource((JpaContextNode)this, this.getConverterAnnotation());
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateName(messages);
    }

    protected void validateName(List<IMessage> messages) {
        if (StringTools.isBlank((String)this.name)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_NAME_UNDEFINED", EMPTY_STRING_ARRAY, (JpaNode)this, this.getNameTextRange()));
            return;
        }
        if (ArrayTools.contains((Object[])EclipseLinkConvert.RESERVED_CONVERTER_NAMES, (Object)this.name)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "RESERVED_CONVERTER_NAME", EMPTY_STRING_ARRAY, (JpaNode)this, this.getNameTextRange()));
        }
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.converterAnnotation.getTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.getConverterAnnotation().getNameTextRange());
    }

    public boolean isEquivalentTo(JpaNamedContextNode node) {
        return this != node && this.getType() == node.getType() && ObjectTools.equals((Object)this.name, (Object)node.getName());
    }

    public abstract void convertTo(OrmEclipseLinkConverterContainer var1);

    public abstract void delete();
}

