/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.wizards.gen;

import com.mongodb.MongoException;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.ui.JptCommonUiImages;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.internal.util.TableLayoutComposite;
import org.eclipse.jpt.common.utility.internal.StringMatcher;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.wizards.gen.JptJpaUiWizardsEntityGenMessages;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.plugin.JptNoSQLEclipseLinkUiPlugin;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.wizards.gen.GenerateDynamicEntitiesFromNoSqlDb;
import org.eclipse.persistence.tools.gen.nosql.mongo.MongoEntityGenerator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionSelectorWizardPage
extends WizardPage {
    private static final int TABLE_COLUMN_INDEX = 0;
    private JpaProject jpaProject;
    private ORMGenCustomizer customizer;
    private boolean updatePersistenceXml = false;
    private boolean isDynamic;
    private CheckboxTableViewer collectionTable;
    private Button updatePersistenceXmlCheckBox;
    private Button refreshCollectionsButton;
    private Button selectAllButton;
    private Button deselectAllButton;
    private Text searchText;
    private TableFilter filter;
    private WorkspaceJob fetchCollectionsJob;
    protected final ResourceManager resourceManager;

    public CollectionSelectorWizardPage(JpaProject jpaProject, ResourceManager resourceManager, boolean isDynamic) {
        super("CollectionSelectorWizardPage");
        this.jpaProject = jpaProject;
        this.resourceManager = resourceManager;
        this.isDynamic = isDynamic;
        this.setTitle("Select Collections");
        this.setMessage("Select collections to be used for generation");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setPageComplete(true);
        this.setControl((Control)this.buildTopLevelControl(parent));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateSelectionState();
            this.doStatusUpdate();
        }
    }

    public final void performHelp() {
    }

    public GenerateDynamicEntitiesFromNoSqlDb getWizard() {
        return (GenerateDynamicEntitiesFromNoSqlDb)super.getWizard();
    }

    protected final IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }

    private Composite buildTopLevelControl(Composite parent) {
        this.customizer = this.getWizard().createORMGenCustomizer(null);
        Composite composite = new Composite(parent, 0);
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createCollectionSelectionControl(composite, nColumns);
        if (!this.isDynamic) {
            this.updatePersistenceXmlCheckBox = this.buildUpdatePersistenceXmlCheckBox(composite);
            this.fillColumns((Control)this.updatePersistenceXmlCheckBox, 3);
        }
        new Label(composite, 0);
        this.buildRestoreDefaultsButton(composite);
        this.getHelpSystem().setHelp(this.collectionTable.getControl(), JpaHelpContextIds.DIALOG_GENERATE_ENTITIES_TABLES);
        return composite;
    }

    private void createCollectionSelectionControl(Composite parent, int columns) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        Label tableLabel = new Label(parent, 0);
        tableLabel.setLayoutData((Object)gridData);
        tableLabel.setText("&Collections");
        this.searchText = this.buildSearchText(parent);
        new Label(parent, 0);
        new Label(parent, 0);
        TableLayoutComposite layout = new TableLayoutComposite(parent, 0);
        this.addColumnLayoutData(layout);
        this.filter = new TableFilter();
        this.collectionTable = this.buildCheckboxTableViewer(this.buildTable((Composite)layout));
        this.collectionTable.addFilter((ViewerFilter)this.filter);
        this.createButtonComposite(parent);
        this.initCollectionsSelectionControl(Collections.<String>emptyList());
    }

    private void createButtonComposite(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)data);
        this.selectAllButton = this.buildSelectAllButton(buttonComposite);
        this.deselectAllButton = this.buildDeselectAllButton(buttonComposite);
        this.refreshCollectionsButton = this.buildRefreshCollectionsButton(buttonComposite);
    }

    private String getCustomizerProperty(String propertyName) {
        return this.customizer.getProperty(propertyName, null, null);
    }

    private boolean updatePersistenceXml() {
        return this.updatePersistenceXml;
    }

    private void setShouldUpdatePersistenceXml(boolean updatePersistenceXml) {
        this.updatePersistenceXml = updatePersistenceXml;
        this.doStatusUpdate();
    }

    private void restoreUpdatePersistenceXmlDefault() {
        this.updatePersistenceXmlCheckBox.setSelection(true);
        this.setShouldUpdatePersistenceXml(true);
    }

    private void selectAllCollections() {
        this.collectionTable.setAllChecked(true);
        this.doStatusUpdate();
    }

    private void deselectAllCollections() {
        this.collectionTable.setAllChecked(false);
        this.doStatusUpdate();
    }

    private void refreshCollections() {
        this.updateTablesListViewer(Collections.<String>emptyList());
        this.updateSelectionState();
    }

    private void initCollectionsSelectionControl(Collection<String> possibleCollections) {
        this.collectionTable.setInput(possibleCollections);
    }

    private Table buildTable(Composite parent) {
        Table table = new Table(parent, 68388);
        TableColumn tableNameColumn = new TableColumn(table, 0, 0);
        tableNameColumn.setText("Collection");
        tableNameColumn.setResizable(true);
        table.addKeyListener((KeyListener)this.buildTableKeyListener());
        GridData gridData = new GridData(1808);
        gridData.heightHint = SWTUtil.getTableHeightHint((Table)table, (int)20);
        gridData.widthHint = 250;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        Color backgroundColor = new Color((Device)parent.getDisplay(), 255, 0, 0);
        parent.setLayoutData((Object)gridData);
        parent.setBackground(backgroundColor);
        backgroundColor.dispose();
        return table;
    }

    private CheckboxTableViewer buildCheckboxTableViewer(Table parent) {
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(parent);
        tableViewer.setUseHashlookup(true);
        tableViewer.setLabelProvider(this.buildCollectionTableLabelProvider());
        tableViewer.setContentProvider(this.buildCollectionTableContentProvider());
        tableViewer.setComparator(new ViewerComparator());
        tableViewer.addPostSelectionChangedListener(this.buildTableSelectionChangedListener());
        return tableViewer;
    }

    private Button buildUpdatePersistenceXmlCheckBox(Composite parent) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_updatePersistenceXml);
        checkBox.setSelection(this.updatePersistenceXml());
        checkBox.addSelectionListener(this.buildUpdatePersistenceXmlSelectionListener());
        return checkBox;
    }

    private Button buildRestoreDefaultsButton(Composite parent) {
        Button button = new Button(parent, 8);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        button.setLayoutData((Object)gridData);
        button.setText(JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_Restore_Defaults);
        button.addSelectionListener(this.buildRestoreDefaultsSelectionListener());
        return button;
    }

    private Button buildSelectAllButton(Composite parent) {
        Button button = this.buildSelectionButton(parent, JptJpaUiMessages.General_selectAll, this.resourceManager.createImage(JptCommonUiImages.SELECT_ALL_BUTTON));
        button.addSelectionListener(this.buildSelectAllSelectionListener());
        return button;
    }

    private Button buildDeselectAllButton(Composite parent) {
        Button button = this.buildSelectionButton(parent, JptJpaUiMessages.General_deselectAll, this.resourceManager.createImage(JptCommonUiImages.DESELECT_ALL_BUTTON));
        button.addSelectionListener(this.buildDeselectAllSelectionListener());
        return button;
    }

    private Button buildRefreshCollectionsButton(Composite parent) {
        Button button = this.buildSelectionButton(parent, JptJpaUiMessages.General_refresh, this.resourceManager.createImage(JptCommonUiImages.REFRESH_BUTTON));
        button.addSelectionListener(this.buildRefreshCollectionsSelectionListener());
        return button;
    }

    private Button buildSelectionButton(Composite parent, String toolTipText, Image buttonImage) {
        Button button = new Button(parent, 8);
        button.setToolTipText(toolTipText);
        button.setImage(buttonImage);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return button;
    }

    private void addColumnLayoutData(TableLayoutComposite layout) {
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    private void fillColumns(Control c, int columns) {
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = columns;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        c.setLayoutData((Object)layoutData);
    }

    private IBaseLabelProvider buildCollectionTableLabelProvider() {
        return new CollectionTableLabelProvider();
    }

    private IContentProvider buildCollectionTableContentProvider() {
        return new CollectionTableContentProvider();
    }

    private Text buildSearchText(Composite parent) {
        GridData gridData = new GridData(768);
        Text text = new Text(parent, 2944);
        text.setMessage(JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_tableSearch);
        text.setLayoutData((Object)gridData);
        text.addSelectionListener(this.buildClearSearchTextSelectionListener());
        text.addKeyListener(this.buildSearchTextKeyListener());
        return text;
    }

    private void handleTablesListSelectionChanged(SelectionChangedEvent event) {
        this.doStatusUpdate();
    }

    private KeyAdapter buildTableKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B && e.stateMask == 0) {
                    CollectionSelectorWizardPage.this.editEntityNameIfPossible();
                    e.doit = false;
                }
            }
        };
    }

    private ISelectionChangedListener buildTableSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CollectionSelectorWizardPage.this.handleTablesListSelectionChanged(event);
            }
        };
    }

    private SelectionListener buildUpdatePersistenceXmlSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CollectionSelectorWizardPage.this.setShouldUpdatePersistenceXml(CollectionSelectorWizardPage.this.updatePersistenceXmlCheckBox.getSelection());
            }
        };
    }

    private SelectionListener buildRestoreDefaultsSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (CollectionSelectorWizardPage.this.customizer != null && CollectionSelectorWizardPage.this.customizer.getFile() != null) {
                    if (CollectionSelectorWizardPage.this.customizer.getFile().exists()) {
                        CollectionSelectorWizardPage.this.customizer.getFile().delete();
                    }
                    CollectionSelectorWizardPage.this.deselectAllCollections();
                    CollectionSelectorWizardPage.this.restoreUpdatePersistenceXmlDefault();
                }
            }
        };
    }

    private SelectionListener buildSelectAllSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CollectionSelectorWizardPage.this.selectAllCollections();
            }
        };
    }

    private SelectionListener buildDeselectAllSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CollectionSelectorWizardPage.this.deselectAllCollections();
            }
        };
    }

    private SelectionListener buildRefreshCollectionsSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CollectionSelectorWizardPage.this.refreshCollections();
            }
        };
    }

    private SelectionListener buildClearSearchTextSelectionListener() {
        return new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CollectionSelectorWizardPage.this.filter.setPattern("");
                CollectionSelectorWizardPage.this.collectionTable.refresh();
            }
        };
    }

    private KeyListener buildSearchTextKeyListener() {
        return new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                CollectionSelectorWizardPage.this.filter.setPattern(CollectionSelectorWizardPage.this.searchText.getText());
                CollectionSelectorWizardPage.this.collectionTable.refresh();
            }
        };
    }

    private void editEntityNameIfPossible() {
        Object[] selected = ((IStructuredSelection)this.collectionTable.getSelection()).toArray();
        if (selected.length != 1) {
            return;
        }
    }

    private Collection<String> getSelectedCollections() {
        ArrayList<String> selectedCollections = new ArrayList<String>();
        Object[] objectArray = this.collectionTable.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedTable = objectArray[n2];
            selectedCollections.add((String)selectedTable);
            ++n2;
        }
        return selectedCollections;
    }

    private boolean hasCollectionSelected() {
        return this.collectionTable != null ? this.getSelectedCollections().size() > 0 : false;
    }

    private void updateTablesListViewer(Collection<String> possibleCollections) {
        if (this.collectionTable != null) {
            this.initCollectionsSelectionControl(possibleCollections);
        }
    }

    private boolean tableInitialized() {
        return this.collectionTable != null && this.collectionTable.getTable().getItemCount() > 0;
    }

    private boolean fetchCollectionsJobIsRunning() {
        return this.fetchCollectionsJob != null;
    }

    private WorkspaceJob buildFetchCollectionsJob() {
        final ArrayList collections = new ArrayList();
        WorkspaceJob workspaceJob = new WorkspaceJob("Get Collections"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Fetching Collections", (int)75);
                try {
                    try {
                        subMonitor.beginTask("NoSql DB", 100);
                        subMonitor.subTask("Fetching collections");
                        subMonitor.worked(20);
                        collections.addAll(this.possibleCollections());
                        subMonitor.worked(95);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        subMonitor.done();
                        return iStatus;
                    }
                }
                finally {
                    subMonitor.done();
                }
                return Status.OK_STATUS;
            }

            private Collection<String> possibleCollections() {
                try {
                    MongoEntityGenerator generator = new MongoEntityGenerator(CollectionSelectorWizardPage.this.getCustomizerProperty("hostText"), Integer.parseInt(CollectionSelectorWizardPage.this.getCustomizerProperty("portText")), CollectionSelectorWizardPage.this.getCustomizerProperty("databaseNameText"), Integer.parseInt(CollectionSelectorWizardPage.this.getCustomizerProperty("rowSampleSizeText")));
                    return generator.listCollectionNames();
                }
                catch (NumberFormatException e) {
                    JptNoSQLEclipseLinkUiPlugin.instance().logError(e);
                }
                catch (MongoException e) {
                    JptNoSQLEclipseLinkUiPlugin.instance().logError(e);
                }
                catch (UnknownHostException e) {
                    JptNoSQLEclipseLinkUiPlugin.instance().logError(e);
                }
                return Collections.emptyList();
            }
        };
        workspaceJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        CollectionSelectorWizardPage.this.updateTablesListViewer(collections);
                    }
                });
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
                CollectionSelectorWizardPage.this.fetchCollectionsJob = null;
            }
        });
        return workspaceJob;
    }

    private void doStatusUpdate() {
        if (!this.hasCollectionSelected()) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_statusUpdate_taskName, 10);
                        Collection ret = CollectionSelectorWizardPage.this.getSelectedCollections();
                        ArrayList<String> collectionNames = new ArrayList<String>();
                        for (String t : ret) {
                            collectionNames.add(t);
                        }
                        CollectionSelectorWizardPage.this.customizer.setTableNames(collectionNames);
                        CollectionSelectorWizardPage.this.customizer.setUpdatePersistenceXml(CollectionSelectorWizardPage.this.updatePersistenceXml);
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                JptNoSQLEclipseLinkUiPlugin.instance().logError(e);
            }
        }
    }

    private void updateSelectionState() {
        if (!this.fetchCollectionsJobIsRunning() && !this.tableInitialized()) {
            this.fetchCollectionsJob = this.buildFetchCollectionsJob();
            this.fetchCollectionsJob.schedule();
        }
        if (this.collectionTable != null && this.customizer != null) {
            this.restoreWizardState();
        }
        this.doStatusUpdate();
    }

    private boolean restoreWizardState() {
        List preSelectedTableNames;
        boolean pageComplete = false;
        if (this.updatePersistenceXmlCheckBox != null) {
            this.updatePersistenceXmlCheckBox.setSelection(this.customizer.updatePersistenceXml());
        }
        if ((preSelectedTableNames = this.customizer.getTableNames()) != null && preSelectedTableNames.size() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (String s : preSelectedTableNames) {
                set.add(s);
            }
            TableItem[] items = this.collectionTable.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                String element = (String)item.getData();
                if (element != null) {
                    boolean check = set.contains(element);
                    if (item.getChecked() != check) {
                        item.setChecked(check);
                        pageComplete = true;
                    }
                }
                ++i;
            }
        }
        return pageComplete;
    }

    private class CollectionTableContentProvider
    implements IStructuredContentProvider {
        CollectionTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }
    }

    private class CollectionTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        CollectionTableLabelProvider() {
        }

        public String getText(Object element) {
            return (String)element;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return (String)element;
                }
            }
            throw new IllegalArgumentException("invalid column index: " + columnIndex);
        }
    }

    private class TableFilter
    extends ViewerFilter {
        private String pattern;
        private StringMatcher matcher;
        private static final String ALL = "*";

        private TableFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String collection = (String)element;
            if (this.pattern == null || this.pattern.length() == 0) {
                return true;
            }
            if (CollectionSelectorWizardPage.this.collectionTable.getChecked((Object)collection)) {
                return true;
            }
            return this.matcher.match(collection);
        }

        protected void setPattern(String newPattern) {
            if (newPattern == null || newPattern.trim().length() == 0) {
                this.matcher = new StringMatcher(ALL, true, false);
            } else {
                this.pattern = String.valueOf(newPattern) + ALL;
                this.matcher = new StringMatcher(this.pattern, true, false);
            }
        }
    }
}

