/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.util.jdt;

import java.util.ArrayList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class AttributeAnnotationTools {
    public static IField[] persistableFields(IType type) {
        try {
            return AttributeAnnotationTools.persistableFieldsUnhandled(type);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static IField[] persistableFieldsUnhandled(IType type) throws JavaModelException {
        IField[] fields = type.getFields();
        int len = fields.length;
        ArrayList<IField> persistableFields = new ArrayList<IField>(len);
        int i = 0;
        while (i < len) {
            IField field = fields[i];
            if (AttributeAnnotationTools.fieldIsPersistable(field)) {
                persistableFields.add(field);
            }
            ++i;
        }
        return persistableFields.toArray(new IField[persistableFields.size()]);
    }

    public static boolean fieldIsPersistable(IField field) {
        try {
            return AttributeAnnotationTools.fieldIsPersistableUnhandled(field);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean fieldIsPersistableUnhandled(IField field) throws JavaModelException {
        int flags = field.getFlags();
        if (Flags.isStatic((int)flags)) {
            return false;
        }
        if (Flags.isPublic((int)flags)) {
            return false;
        }
        if (Flags.isTransient((int)flags)) {
            return false;
        }
        return !Flags.isFinal((int)flags);
    }

    public static IMethod[] persistablePropertyGetters(IType type) {
        try {
            return AttributeAnnotationTools.persistablePropertyGettersUnhandled(type);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static IMethod[] persistablePropertyGettersUnhandled(IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        int len = methods.length;
        ArrayList<IMethod> persistableMethods = new ArrayList<IMethod>(len);
        int i = 0;
        while (i < len) {
            IMethod method = methods[i];
            if (AttributeAnnotationTools.methodIsPersistablePropertyGetter(method)) {
                persistableMethods.add(method);
            }
            ++i;
        }
        return persistableMethods.toArray(new IMethod[persistableMethods.size()]);
    }

    public static boolean methodIsPersistablePropertyGetter(IMethod method) {
        try {
            return AttributeAnnotationTools.methodIsPersistablePropertyGetterUnhandled(method);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean methodIsPersistablePropertyGetterUnhandled(IMethod method) throws JavaModelException {
        if (AttributeAnnotationTools.methodHasBadModifiers(method)) {
            return false;
        }
        String returnType = method.getReturnType();
        if (returnType.equals("V")) {
            return false;
        }
        if (method.getNumberOfParameters() != 0) {
            return false;
        }
        String methodName = method.getElementName();
        int beginIndex = 0;
        if (methodName.startsWith("get")) {
            beginIndex = 3;
        } else if (methodName.startsWith("is") && returnType.equals("Z")) {
            beginIndex = 2;
        } else {
            return false;
        }
        String capitalizedAttributeName = method.getElementName().substring(beginIndex);
        IMethod setMethod = method.getDeclaringType().getMethod("set" + capitalizedAttributeName, new String[]{returnType});
        if (!setMethod.exists()) {
            return false;
        }
        if (AttributeAnnotationTools.methodHasBadModifiers(setMethod)) {
            return false;
        }
        return setMethod.getReturnType().equals("V");
    }

    private static boolean methodHasBadModifiers(IMethod method) throws JavaModelException {
        if (method.isConstructor()) {
            return true;
        }
        int flags = method.getFlags();
        if (Flags.isStatic((int)flags)) {
            return true;
        }
        if (Flags.isFinal((int)flags)) {
            return true;
        }
        return !Flags.isPublic((int)flags) && !Flags.isProtected((int)flags);
    }
}

