/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.dali.db.RepositoryConnectionListener;
import org.eclipse.dali.db.wrappers.ConnectionInfoWrapper;
import org.eclipse.dali.db.wrappers.NullConnectionInfoWrapper;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManager;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerListener;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;

public class ConnectionRepository {
    private static ConnectionRepository INSTANCE;
    private ConnectionManager connectionManager;
    private Collection connectionInfoWrappers;
    private boolean infoCollectionIsInitialized;
    private RepositoryConnectionListener connectionListener;

    private ConnectionRepository() {
        this.initialize();
    }

    public static ConnectionRepository instance() {
        if (INSTANCE == null) {
            INSTANCE = new ConnectionRepository();
        }
        return INSTANCE;
    }

    protected void initialize() {
        this.connectionManager = RDBCorePlugin.getDefault().getConnectionManager();
        this.infoCollectionIsInitialized = false;
    }

    public Collection getAllConnectionInfo() {
        if (!this.infoCollectionIsInitialized) {
            this.infoCollectionIsInitialized = true;
            this.connectionInfoWrappers = this.getAllNamedConnectionInfo();
        }
        return this.connectionInfoWrappers;
    }

    public Iterator allConnectionInfo() {
        return this.getAllConnectionInfo().iterator();
    }

    private Collection getAllNamedConnectionInfo() {
        Object[] infos = this.connectionManager.getAllNamedConnectionInfo();
        return ConnectionInfoWrapper.wrapAll(CollectionTools.iterator((Object[])infos));
    }

    public ConnectionInfoWrapper getConnectionInfoNamed(String infoName) {
        Iterator i = this.allConnectionInfo();
        while (i.hasNext()) {
            ConnectionInfoWrapper info = (ConnectionInfoWrapper)i.next();
            if (!info.getName().equalsIgnoreCase(infoName)) continue;
            return info;
        }
        return NullConnectionInfoWrapper.instance();
    }

    void add(ConnectionInfo info) {
        for (ConnectionInfoWrapper wrapper : this.getAllConnectionInfo()) {
            if (!wrapper.wraps(info)) continue;
            return;
        }
        this.getAllConnectionInfo().add(new ConnectionInfoWrapper(info));
    }

    void remove(String name) {
        ConnectionInfoWrapper info = this.getConnectionInfoNamed(name);
        this.getAllConnectionInfo().remove(info);
    }

    public ConnectionInfoWrapper connectTo(String dbName, String userName, String password) throws Exception {
        for (ConnectionInfoWrapper info : this.getAllConnectionInfo()) {
            if (!info.getDatabaseName().equalsIgnoreCase(dbName)) continue;
            if (info.isConnected()) {
                return info;
            }
            info.connect(userName, password);
            return info;
        }
        return null;
    }

    public ConnectionInfoWrapper createConnectionInfo(String databaseName, String databaseVersion, String connectionName) throws Exception {
        DatabaseDefinition dbdefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(databaseName, databaseVersion);
        ConnectionInfo info = this.connectionManager.createConnectionInfo(dbdefinition, connectionName);
        return info == null ? null : new ConnectionInfoWrapper(info);
    }

    public void removeConnectionInfo(String connectionName) {
        this.connectionManager.removeConnectionInfo(connectionName);
    }

    void initializeListeners() {
        this.connectionListener = new RepositoryConnectionListener(this);
        this.addListener(this.connectionListener);
    }

    void removeListeners() {
        if (this.connectionListener != null) {
            this.connectionListener.dispose();
            this.removeListener(this.connectionListener);
            this.connectionListener = null;
        }
    }

    public void addListener(ConnectionManagerListener listerner) {
        this.connectionManager.addListener(listerner);
    }

    public void removeListener(ConnectionManagerListener listerner) {
        this.connectionManager.removeListener(listerner);
    }
}

