/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.core.Embeddable;
import org.eclipse.dali.core.Entity;
import org.eclipse.dali.core.MappedSuperclass;
import org.eclipse.dali.core.NullPersistentTypeFlavor;
import org.eclipse.dali.core.PersistentType;
import org.eclipse.dali.core.PersistentTypeFlavor;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.PersistentTypeItemProvider;
import org.eclipse.dali.ui.views.EmbeddableComposite;
import org.eclipse.dali.ui.views.EntityComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.MappedSuperclassComposite;
import org.eclipse.dali.ui.views.ScrolledPageContent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public class PersistentTypeComposite
extends Composite
implements IPersistenceComposite {
    private PersistentType persistentType;
    private PersistentTypeItemProvider persistentTypeItemProvider;
    private ComboViewer persistentTypeFlavorCombo;
    public static final String NULL_FLAVOR_COMBO_CHOICE = "Not Persistent";
    public static final String ENTITY_FLAVOR_COMBO_CHOICE = "Entity";
    public static final String EMBEDDABLE_FLAVOR_COMBO_CHOICE = "Embeddable";
    public static final String MAPPED_SUPERCLASS_FLAVOR_COMBO_CHOICE = "Mapped Superclass";
    private PageBook typePageBook;
    private Composite nullComposite;
    private EntityComposite entityComposite;
    private EmbeddableComposite embeddableComposite;
    private MappedSuperclassComposite mappedSuperclassComposite;
    private EditingDomain editingDomain;
    private INotifyChangedListener persistentTypeListener;
    private boolean populating;
    static /* synthetic */ Class class$0;

    public PersistentTypeComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.persistentTypeItemProvider = (PersistentTypeItemProvider)adapterFactory.createPersistentTypeAdapter();
        this.initializeLayout(adapterFactory);
    }

    private void initializeLayout(DaliItemProviderAdapterFactory adapterFactory) {
        this.setLayout((Layout)new FillLayout());
        ScrolledPageContent pageContent = new ScrolledPageContent(this);
        GridLayout layout = new GridLayout(2, false);
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        Label mappingTypeLabel = new Label(composite, 16384);
        mappingTypeLabel.setText("Map As:");
        this.persistentTypeFlavorCombo = this.buildPersistentTypeFlavorCombo(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.persistentTypeFlavorCombo.getCombo().setLayoutData((Object)gridData);
        this.typePageBook = new PageBook(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.typePageBook.setLayoutData((Object)gridData);
        this.nullComposite = new Composite((Composite)this.typePageBook, 0);
        this.entityComposite = new EntityComposite((Composite)this.typePageBook, this.editingDomain, adapterFactory);
        this.embeddableComposite = new EmbeddableComposite((Composite)this.typePageBook, this.editingDomain, adapterFactory);
        this.mappedSuperclassComposite = new MappedSuperclassComposite((Composite)this.typePageBook, this.editingDomain, adapterFactory);
        this.typePageBook.showPage((Control)this.entityComposite);
    }

    private ComboViewer buildPersistentTypeFlavorCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add((Object)NULL_FLAVOR_COMBO_CHOICE);
        viewer.add((Object)ENTITY_FLAVOR_COMBO_CHOICE);
        viewer.add((Object)EMBEDDABLE_FLAVOR_COMBO_CHOICE);
        viewer.add((Object)MAPPED_SUPERCLASS_FLAVOR_COMBO_CHOICE);
        viewer.setSelection((ISelection)new StructuredSelection((Object)NULL_FLAVOR_COMBO_CHOICE));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PersistentTypeComposite.this.persistentTypeFlavorChanged(event);
            }
        });
        return viewer;
    }

    private void persistentTypeFlavorChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof StructuredSelection) {
            String selection = (String)((StructuredSelection)event.getSelection()).getFirstElement();
            if (selection.equals(NULL_FLAVOR_COMBO_CHOICE)) {
                this.persistentType.setFlavorKey((PersistentTypeFlavor.Key)NullPersistentTypeFlavor.Key.INSTANCE);
            } else if (selection.equals(ENTITY_FLAVOR_COMBO_CHOICE)) {
                this.persistentType.setFlavorKey((PersistentTypeFlavor.Key)Entity.Key.INSTANCE);
            } else if (selection.equals(EMBEDDABLE_FLAVOR_COMBO_CHOICE)) {
                this.persistentType.setFlavorKey((PersistentTypeFlavor.Key)Embeddable.Key.INSTANCE);
            } else if (selection.equals(MAPPED_SUPERCLASS_FLAVOR_COMBO_CHOICE)) {
                this.persistentType.setFlavorKey((PersistentTypeFlavor.Key)MappedSuperclass.Key.INSTANCE);
            }
        }
    }

    public void populate(EObject persistentType) {
        this.populating = true;
        if (this.persistentType != null) {
            this.persistentType.eAdapters().remove((Object)this.persistentTypeItemProvider);
            this.persistentTypeItemProvider.removeListener(this.getPersistentTypeListener());
        }
        this.persistentType = (PersistentType)persistentType;
        if (this.persistentType == null) {
            this.populate((PersistentTypeFlavor)null);
            return;
        }
        this.persistentTypeItemProvider.addListener(this.getPersistentTypeListener());
        this.persistentType.eAdapters().add((Object)this.persistentTypeItemProvider);
        this.populate(this.persistentType.getFlavor());
        this.populating = false;
    }

    private void populate(PersistentTypeFlavor persistentTypeFlavor) {
        PersistentTypeFlavor.Key flavorKey;
        this.unpopulateSubPanels();
        PersistentTypeFlavor.Key key = flavorKey = persistentTypeFlavor == null ? null : persistentTypeFlavor.getKey();
        if (flavorKey == null) {
            return;
        }
        if (NullPersistentTypeFlavor.Key.INSTANCE.equals(flavorKey)) {
            this.typePageBook.showPage((Control)this.nullComposite);
            this.persistentTypeFlavorCombo.setSelection((ISelection)new StructuredSelection((Object)NULL_FLAVOR_COMBO_CHOICE));
        } else if (Entity.Key.INSTANCE.equals(flavorKey)) {
            this.typePageBook.showPage((Control)this.entityComposite);
            this.entityComposite.populate((EObject)persistentTypeFlavor);
            this.persistentTypeFlavorCombo.setSelection((ISelection)new StructuredSelection((Object)ENTITY_FLAVOR_COMBO_CHOICE));
        } else if (Embeddable.Key.INSTANCE.equals(flavorKey)) {
            this.typePageBook.showPage((Control)this.embeddableComposite);
            this.embeddableComposite.populate((EObject)persistentTypeFlavor);
            this.persistentTypeFlavorCombo.setSelection((ISelection)new StructuredSelection((Object)EMBEDDABLE_FLAVOR_COMBO_CHOICE));
        } else if (MappedSuperclass.Key.INSTANCE.equals(flavorKey)) {
            this.typePageBook.showPage((Control)this.mappedSuperclassComposite);
            this.mappedSuperclassComposite.populate((EObject)persistentTypeFlavor);
            this.persistentTypeFlavorCombo.setSelection((ISelection)new StructuredSelection((Object)MAPPED_SUPERCLASS_FLAVOR_COMBO_CHOICE));
        }
    }

    private void unpopulateSubPanels() {
        this.entityComposite.populate(null);
        this.embeddableComposite.populate(null);
        this.mappedSuperclassComposite.populate(null);
    }

    private INotifyChangedListener getPersistentTypeListener() {
        if (this.persistentTypeListener == null) {
            this.persistentTypeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeatureID(PersistentType.class) == 3) {
                        PersistentTypeFlavor flavor = (PersistentTypeFlavor)notification.getNewValue();
                        Display.getDefault().asyncExec(new Runnable(this, flavor){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ PersistentTypeFlavor val$flavor;
                            {
                                this.this$1 = var1_1;
                                this.val$flavor = persistentTypeFlavor;
                            }

                            public void run() {
                                PersistentTypeComposite.access$1(2.access$0(this.this$1), this.val$flavor);
                            }
                        });
                    }
                }

                static /* synthetic */ PersistentTypeComposite access$0(2 var0) {
                    return var0.PersistentTypeComposite.this;
                }
            };
        }
        return this.persistentTypeListener;
    }

    public boolean setFocus() {
        super.setFocus();
        return this.persistentTypeFlavorCombo.getCombo().setFocus();
    }

    public void dispose() {
        this.persistentTypeItemProvider.removeListener(this.persistentTypeListener);
        super.dispose();
    }

    static /* synthetic */ void access$1(PersistentTypeComposite persistentTypeComposite, PersistentTypeFlavor persistentTypeFlavor) {
        persistentTypeComposite.populate(persistentTypeFlavor);
    }
}

