/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.TableGenerator;
import org.eclipse.dali.core.impl.PersistenceProjectImpl;
import org.eclipse.dali.db.wrappers.ConnectionInfoWrapper;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.GeneratorItemProvider;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.ui.views.GeneratorComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TableGeneratorComposite
extends GeneratorComposite
implements IPersistenceComposite {
    Group tableGeneratorGroup;
    private Combo tableNameCombo;
    private ModifyListener tableNameComboListener;
    static /* synthetic */ Class class$0;

    protected TableGeneratorComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, editingDomain, adapterFactory);
        this.initializeLayout();
    }

    protected GeneratorItemProvider createGeneratorItemProvider(DaliItemProviderAdapterFactory adapterFactory) {
        return (GeneratorItemProvider)adapterFactory.createTableGeneratorAdapter();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.tableGeneratorGroup = new Group((Composite)this, 16);
        this.tableGeneratorGroup.setText("Table Generator");
        this.tableGeneratorGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableGeneratorGroup.setLayoutData((Object)gridData);
        Label tableGeneratorLabel = new Label((Composite)this.tableGeneratorGroup, 16384);
        tableGeneratorLabel.setText("Name:");
        this.nameViewer = this.buildNameViewer((Composite)this.tableGeneratorGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.nameViewer.getTextWidget().setLayoutData((Object)gridData);
        Label tableNameLabel = new Label((Composite)this.tableGeneratorGroup, 16384);
        tableNameLabel.setText("Table:");
        this.tableNameCombo = this.buildTableNameCombo((Composite)this.tableGeneratorGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableNameCombo.setLayoutData((Object)gridData);
    }

    private Combo buildTableNameCombo(Composite parent) {
        Combo combo = new Combo(parent, 4);
        combo.add("");
        combo.select(0);
        combo.addModifyListener(this.getTableNameListener());
        return combo;
    }

    private ModifyListener getTableNameListener() {
        if (this.tableNameComboListener == null) {
            this.tableNameComboListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (TableGeneratorComposite.this.populating) {
                        return;
                    }
                    String text = ((Combo)e.getSource()).getText();
                    if (text != null && TableGeneratorComposite.this.tableNameCombo.getItemCount() > 0 && text.equals(TableGeneratorComposite.this.tableNameCombo.getItem(0))) {
                        text = null;
                    }
                    TableGeneratorComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)TableGeneratorComposite.this.editingDomain, (Object)TableGeneratorComposite.this.getGenerator(), (Object)DaliPackage.eINSTANCE.getTableGenerator_SpecifiedTableName(), (Object)text));
                }
            };
        }
        return this.tableNameComboListener;
    }

    protected void generatorChanged(Notification notification) {
        super.generatorChanged(notification);
        if (notification.getFeatureID(TableGenerator.class) == 9) {
            final String tableName = notification.getNewStringValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (tableName == null) {
                        TableGeneratorComposite.this.tableNameCombo.select(0);
                    } else if (!TableGeneratorComposite.this.tableNameCombo.getText().equals(tableName)) {
                        TableGeneratorComposite.this.tableNameCombo.setText(tableName);
                    }
                }
            });
        }
    }

    public void populate(EObject model) {
        super.populate(model);
        this.populating = true;
        if (model == null) {
            this.populating = false;
            return;
        }
        this.populateTableNameCombo();
        this.populating = false;
    }

    private void populateTableNameCombo() {
        String tableName;
        this.populating = true;
        if (this.getGenerator() == null) {
            return;
        }
        PersistenceProjectImpl persistenceProject = this.getGenerator().getPersistenceProject();
        ConnectionInfoWrapper connectionInfo = persistenceProject.getConnectionInfo();
        this.tableNameCombo.setItem(0, "Default");
        if (connectionInfo.isConnected()) {
            this.tableNameCombo.remove(1, this.tableNameCombo.getItemCount() - 1);
            Iterator tables = connectionInfo.userTableNames(persistenceProject.getSchemaName());
            Iterator i = CollectionTools.sort((List)CollectionTools.list((Iterator)tables)).iterator();
            while (i.hasNext()) {
                this.tableNameCombo.add((String)i.next());
            }
        }
        if ((tableName = this.getTableGenerator().getSpecifiedTableName()) != null) {
            if (!this.tableNameCombo.getText().equals(tableName)) {
                this.tableNameCombo.setText(tableName);
            }
        } else {
            this.tableNameCombo.select(0);
        }
        this.populating = false;
    }

    protected TableGenerator getTableGenerator() {
        return (TableGenerator)this.getGenerator();
    }

    protected void clear() {
        super.clear();
        this.tableNameCombo.select(0);
    }
}

