/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.List;
import org.eclipse.dali.orm.Column;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.Table;
import org.eclipse.dali.orm.VersionMapping;
import org.eclipse.dali.orm.adapters.IVersionMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.dali.orm.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.orm.impl.AttributeMappingImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class VersionMappingImpl
extends AttributeMappingImpl
implements VersionMapping {
    protected Column column = null;
    static /* synthetic */ Class class$0;

    protected VersionMappingImpl() {
    }

    protected VersionMappingImpl(IVersionMappingModelAdapter modelAdapter) {
        super(modelAdapter);
        this.column = OrmFactory.eINSTANCE.createColumn(modelAdapter.createColumnModelAdapter());
        ((InternalEObject)this.column).eInverseAdd((InternalEObject)this, -1, null, null);
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.VERSION_MAPPING;
    }

    public Column getColumn() {
        return this.column;
    }

    public NotificationChain basicSetColumn(Column newColumn, NotificationChain msgs) {
        Column oldColumn = this.column;
        this.column = newColumn;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldColumn, (Object)newColumn);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetColumn(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getColumn();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.column != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class baseClass) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.ColumnHolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (baseClass == clazz) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.ColumnHolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (baseClass == clazz) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public boolean supportsColumn() {
        return true;
    }

    public String getKey() {
        return "version";
    }

    public void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.addVersionMappedToNonPrimaryTableProblemTo(problems);
        this.addVersionMappingIncorrectTypeProblemTo(problems);
        this.getColumn().addProblemsTo(problems);
    }

    private void addVersionMappedToNonPrimaryTableProblemTo(List problems) {
        String tableName = this.column.getTableName();
        Table table = this.getPersistentAttribute().getTypeMapping().getTable();
        if (table == null || tableName.equals(table.getName())) {
            return;
        }
        problems.add(this.buildProblem("Version mappings must be mapped to the primary table", this.getTextRange()));
    }

    private void addVersionMappingIncorrectTypeProblemTo(List problems) {
        Attribute attribute = ((JavaPersistentAttributeModelAdapter)this.getPersistentAttribute().getModelAdapter()).getAttribute();
        if (attribute.typeIs("int")) {
            return;
        }
        if (attribute.typeIs("java.lang.Integer")) {
            return;
        }
        if (attribute.typeIs("short")) {
            return;
        }
        if (attribute.typeIs("java.lang.Short")) {
            return;
        }
        if (attribute.typeIs("long")) {
            return;
        }
        if (attribute.typeIs("java.lang.Long")) {
            return;
        }
        if (attribute.typeIs("java.sql.Timestamp")) {
            return;
        }
        problems.add(this.buildProblem("Version mapping type must be int, Integer, short, Short, long, Long, or Timestamp", this.getTextRange()));
    }
}

