/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.selection.listener;

import org.eclipse.dali.ui.composites.PageBookManager;
import org.eclipse.dali.ui.composites.PersistentOutlineComposite;
import org.eclipse.dali.ui.selection.listener.PageBookSelectionListener;
import org.eclipse.dali.ui.selection.notification.ISelectionNotification;
import org.eclipse.dali.ui.selection.notification.SelectionNotificationEvent;
import org.eclipse.dali.ui.views.PersistenceOutlineView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class PersistentOutlineSelectionListener
extends PageBookSelectionListener {
    private EClass eClass;
    private PersistenceOutlineView outlineView;

    public PersistentOutlineSelectionListener(PageBookManager aPageBookManager, EClass anEClass, PersistenceOutlineView anOutlineView) {
        super(aPageBookManager, anEClass);
        this.eClass = anEClass;
        this.outlineView = anOutlineView;
    }

    public void selectionChanged(ISelectionNotification aNotification) {
        Object eventView = aNotification.getEventView();
        SelectionNotificationEvent event = aNotification.getEvent();
        if (event == SelectionNotificationEvent.OPENED || event == SelectionNotificationEvent.ACTIVATED || event == SelectionNotificationEvent.INITIALIZED || event == SelectionNotificationEvent.BROUGHT_TO_TOP) {
            if (this.pageBookManager.contains(eventView) || aNotification.isDeselection()) {
                this.pageBookManager.activate(eventView);
            } else {
                EObject eObj = aNotification.getSelectionForType(this.eClass);
                PersistentOutlineComposite outline = new PersistentOutlineComposite(this.pageBookManager.getComposite(), 0, eObj, this.outlineView);
                this.pageBookManager.put(eventView, outline);
            }
        } else if (event == SelectionNotificationEvent.CLOSED) {
            this.pageBookManager.remove(eventView);
        }
    }
}

