/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.orm.OneToOneMapping;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.RelationshipMappingItemProvider;
import org.eclipse.dali.orm.provider.SingleRelationshipMappingItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.JoinColumnComposite;
import org.eclipse.dali.ui.views.RelationshipMappingComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public class OneToOneMappingComposite
extends RelationshipMappingComposite
implements IPersistenceComposite {
    protected Combo mappedByCombo;
    private JoinColumnComposite joinColumnComposite;
    static /* synthetic */ Class class$0;

    protected OneToOneMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, editingDomain, adapterFactory);
        this.initializeLayout();
    }

    protected RelationshipMappingItemProvider createRelationshipMappingItemProvider(OrmItemProviderAdapterFactory adapterFactory) {
        return (RelationshipMappingItemProvider)adapterFactory.createOneToOneMappingAdapter();
    }

    private void initializeLayout() {
        this.setLayout((Layout)new FillLayout(512));
        TabFolder folder = new TabFolder((Composite)this, 128);
        Control generalControl = this.buildGeneralTab(folder);
        TabItem generalTab = new TabItem(folder, 0);
        generalTab.setText(DaliUiMessages.OneToOneMappingComposite_general);
        generalTab.setControl(generalControl);
        Control joinTableControl = this.buildJoinColumnsTab(folder);
        TabItem joinTableTab = new TabItem(folder, 0);
        joinTableTab.setText(DaliUiMessages.OneToOneMappingComposite_joinColumns);
        joinTableTab.setControl(joinTableControl);
        folder.setSelection(0);
    }

    private Control buildGeneralTab(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label targetEntityLabel = new Label(composite, 16384);
        targetEntityLabel.setText(DaliUiMessages.OneToOneMappingComposite_targetEntity);
        this.targetEntityCombo = this.buildTargetEntityCombo(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.targetEntityCombo.setLayoutData((Object)gridData);
        this.buildTargetEntitySelectionButton(composite);
        Label cascadeTypeLabel = new Label(composite, 16384);
        cascadeTypeLabel.setText(DaliUiMessages.OneToOneMappingComposite_cascadeType);
        this.cascadeTypeComboViewer = this.buildCascadeTypeCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cascadeTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label fetchTypeLabel = new Label(composite, 16384);
        fetchTypeLabel.setText(DaliUiMessages.OneToOneMappingComposite_fetchType);
        this.fetchTypeComboViewer = this.buildFetchTypeCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fetchTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label optionalLabel = new Label(composite, 16384);
        optionalLabel.setText(DaliUiMessages.OneToOneMappingComposite_optional);
        this.optionalComboViewer = this.buildOptionalCombo(composite);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.optionalComboViewer.getCombo().setLayoutData((Object)gridData);
        Label mappedByLabel = new Label(composite, 16384);
        mappedByLabel.setText(DaliUiMessages.OneToOneMappingComposite_mappedBy);
        this.mappedByCombo = this.buildMappedByCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.mappedByCombo.setLayoutData((Object)gridData);
        return composite;
    }

    private Control buildJoinColumnsTab(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout());
        this.joinColumnComposite = new JoinColumnComposite(composite, this.editingDomain, this.adapterFactory, (SingleRelationshipMappingItemProvider)this.adapterFactory.createManyToOneMappingAdapter());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.joinColumnComposite.setLayoutData(gridData);
        return composite;
    }

    private Combo buildMappedByCombo(Composite parent) {
        Combo combo = new Combo(parent, 2052);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OneToOneMappingComposite.this.populating) {
                    return;
                }
                String mappedBy = ((Combo)e.getSource()).getText();
                if (mappedBy.equals("")) {
                    mappedBy = null;
                    if (OneToOneMappingComposite.this.getOneToOneMapping().getMappedBy() == null || OneToOneMappingComposite.this.getOneToOneMapping().getMappedBy().equals("")) {
                        return;
                    }
                }
                if (OneToOneMappingComposite.this.getOneToOneMapping().getMappedBy() == null || !OneToOneMappingComposite.this.getOneToOneMapping().getMappedBy().equals(mappedBy)) {
                    OneToOneMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)OneToOneMappingComposite.this.editingDomain, (Object)OneToOneMappingComposite.this.getOneToOneMapping(), (Object)OrmPackage.eINSTANCE.getNonOwningMapping_MappedBy(), (Object)mappedBy));
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)combo, "org.eclipse.dali.ui.mapping_mappedBy");
        return combo;
    }

    private OneToOneMapping getOneToOneMapping() {
        return (OneToOneMapping)this.relationshipMapping;
    }

    public void populate(EObject model) {
        super.populate(model);
        this.populating = true;
        if (this.mappedByCombo.getItemCount() > 0) {
            this.mappedByCombo.removeAll();
        }
        if (model != null) {
            this.populateMappedByCombo();
            this.joinColumnComposite.populate((EObject)this.relationshipMapping);
        } else {
            this.joinColumnComposite.populate(null);
        }
        this.populating = false;
    }

    private void populateMappedByCombo() {
        String mappedBy = this.getOneToOneMapping().getMappedBy();
        Iterator i = this.getOneToOneMapping().possibleMappedByAttributeNames();
        while (i.hasNext()) {
            this.mappedByCombo.add((String)i.next());
        }
        if (mappedBy != null && !this.mappedByCombo.getText().equals(mappedBy)) {
            this.mappedByCombo.setText(mappedBy);
        }
    }

    protected void mappingTypeChanged(Notification notification) {
        super.mappingTypeChanged(notification);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.RelationshipMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 9) {
            final String mappedBy = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (OneToOneMappingComposite.this.mappedByCombo.getText() == null || !OneToOneMappingComposite.this.mappedByCombo.getText().equals(mappedBy)) {
                        if (mappedBy == null) {
                            OneToOneMappingComposite.this.mappedByCombo.setText("");
                        } else {
                            OneToOneMappingComposite.this.mappedByCombo.setText(mappedBy);
                        }
                    }
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        this.joinColumnComposite.dispose();
    }

    public static class OneToOneMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
            return new OneToOneMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

