/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.selection.tracker;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.dali.ui.selection.notification.SelectionNotificationEvent;
import org.eclipse.dali.ui.selection.resolver.DaliSelectionResolver;
import org.eclipse.dali.ui.selection.tracker.SelectionTracker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class ViewerSelectionTracker
extends SelectionTracker {
    private Viewer viewer;
    private static DaliSelectionResolver RESOLVER = new DaliSelectionResolver();

    public ViewerSelectionTracker(Viewer aViewer) {
        aViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer = aViewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.viewer.getControl().isFocusControl()) {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            Iterator itr = selection.iterator();
            while (itr.hasNext()) {
                EObject eObj = (EObject)itr.next();
                Collection col = RESOLVER.resolve(eObj);
                this.notifyChanged(SelectionNotificationEvent.SELECTION_CHANGED, eObj, col, this.viewer);
            }
        }
    }
}

