/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.orm.AttributeOverride;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.SecondaryTable;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IAttributeOverrideModelAdapter;
import org.eclipse.dali.orm.adapters.IEntityModelAdapter;
import org.eclipse.dali.orm.adapters.IInheritanceModelAdapter;
import org.eclipse.dali.orm.adapters.ISecondaryTableModelAdapter;
import org.eclipse.dali.orm.adapters.ITableModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.IJavaTypeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAttributeOverrideModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaInheritanceModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaSecondaryTableModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaTableModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;

public class JavaEntityModelAdapter
implements IEntityModelAdapter,
IJavaTypeMappingModelAdapter {
    private Type type;
    private StringAnnotationElementAdapter specifiedNameAdapter;
    private Entity entity;

    public JavaEntityModelAdapter(Type type) {
        this.type = type;
        this.specifiedNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedNameElementInfo());
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.entity = (Entity)typeMapping;
    }

    public void engage() {
        this.addAnnotation();
    }

    public void disengage() {
        this.removeAnnotation();
        this.entity = null;
    }

    public IInheritanceModelAdapter createInheritanceModelAdapter() {
        return new JavaInheritanceModelAdapter(this.type());
    }

    public ITableModelAdapter createTableModelAdapter() {
        return new JavaTableModelAdapter(this.type());
    }

    private JavaTableModelAdapter getTableModelAdapter() {
        return (JavaTableModelAdapter)this.entity.getTable().getModelAdapter();
    }

    private JavaInheritanceModelAdapter getInheritanceModelAdapter() {
        return (JavaInheritanceModelAdapter)this.entity.getInheritance().getModelAdapter();
    }

    public void addAnnotation() {
        CompilationUnit astRoot = this.type.createASTRoot();
        this.type.addAnnotation("Entity", astRoot);
    }

    public void removeAnnotation() {
        CompilationUnit astRoot = this.type.createASTRoot();
        this.type.removeAnnotation("Entity", astRoot);
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaEntityModelAdapter.this.getEntity().setSpecifiedName(newValue);
            }

            public String persValue() {
                return JavaEntityModelAdapter.this.getEntity().getSpecifiedName();
            }

            public String annotationElementName() {
                return "name";
            }

            public String annotationName() {
                return "Entity";
            }

            public Member member() {
                return JavaEntityModelAdapter.this.type;
            }

            public String defaultValue() {
                return null;
            }

            public boolean removeAnnotationIfEmpty() {
                return false;
            }
        };
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultName();
        this.updatePersSpecifiedName(astRoot);
        this.getInheritanceModelAdapter().updatePersModel(astRoot);
        this.getTableModelAdapter().updatePersModel(astRoot);
        this.updatePersSecondaryTables(astRoot);
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
        this.updatePersAttributeOverrides(astRoot);
        this.getInheritanceModelAdapter().postUpdatePersModel(astRoot);
        this.getTableModelAdapter().postUpdatePersModel(astRoot);
        this.postUpdatePersSecondaryTables(astRoot);
        this.postUpdatePersAttributeOverrides(astRoot);
    }

    private void postUpdatePersSecondaryTables(CompilationUnit astRoot) {
        Iterator i = this.getEntity().getSecondaryTables().iterator();
        while (i.hasNext()) {
            ((JavaSecondaryTableModelAdapter)((SecondaryTable)i.next()).getModelAdapter()).postUpdatePersModel(astRoot);
        }
    }

    private void postUpdatePersAttributeOverrides(CompilationUnit astRoot) {
        Iterator i = this.getEntity().getAttributeOverrides().iterator();
        while (i.hasNext()) {
            ((JavaAttributeOverrideModelAdapter)((AttributeOverride)i.next()).getModelAdapter()).postUpdatePersModel(astRoot);
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    protected void updatePersSpecifiedName(CompilationUnit astRoot) {
        this.specifiedNameAdapter.updatePersElement(astRoot);
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.entity.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.entity.setDefaultName(name);
        }
    }

    protected Type type() {
        return this.type;
    }

    private ISecondaryTableModelAdapter buildSecondaryTableModelAdapter() {
        return new JavaSecondaryTableModelAdapter(this.type);
    }

    private void updatePersSecondaryTables(CompilationUnit astRoot) {
        Annotation secondaryTableAnnotation = this.type().getAnnotation("SecondaryTable", astRoot);
        int numSecondaryTables = 0;
        if (secondaryTableAnnotation != null) {
            if (this.getEntity().getSecondaryTables().size() <= numSecondaryTables) {
                SecondaryTable secondaryTable = OrmFactory.eINSTANCE.createSecondaryTable(this.buildSecondaryTableModelAdapter());
                ((JavaSecondaryTableModelAdapter)secondaryTable.getModelAdapter()).updatePersModel(astRoot);
                this.getEntity().getSecondaryTables().add((Object)secondaryTable);
            } else {
                ((JavaSecondaryTableModelAdapter)((SecondaryTable)this.getEntity().getSecondaryTables().get(numSecondaryTables)).getModelAdapter()).updatePersModel(astRoot);
            }
            ++numSecondaryTables;
        } else {
            Annotation secondaryTablesAnnotation = this.type().getAnnotation("SecondaryTables", astRoot);
            if (secondaryTablesAnnotation != null) {
                MemberValuePair valueValuePair;
                Expression valueExpression = null;
                if (secondaryTablesAnnotation.getNodeType() == 79) {
                    valueExpression = ((SingleMemberAnnotation)secondaryTablesAnnotation).getValue();
                } else if (secondaryTablesAnnotation.getNodeType() == 77 && (valueValuePair = ASTTools.getMemberValuePair(secondaryTablesAnnotation, "value")) != null) {
                    valueExpression = valueValuePair.getValue();
                }
                if (valueExpression != null) {
                    if (valueExpression.getNodeType() == 77) {
                        if (((NormalAnnotation)valueExpression).getTypeName().getFullyQualifiedName().equals("SecondaryTable")) {
                            if (this.getEntity().getSecondaryTables().size() <= numSecondaryTables) {
                                SecondaryTable secondaryTable = OrmFactory.eINSTANCE.createSecondaryTable(this.buildSecondaryTableModelAdapter());
                                ((JavaSecondaryTableModelAdapter)secondaryTable.getModelAdapter()).updatePersModel(astRoot);
                                this.getEntity().getSecondaryTables().add((Object)secondaryTable);
                            } else {
                                ((JavaSecondaryTableModelAdapter)((SecondaryTable)this.getEntity().getSecondaryTables().get(numSecondaryTables)).getModelAdapter()).updatePersModel(astRoot);
                            }
                            ++numSecondaryTables;
                        }
                    } else if (valueExpression.getNodeType() == 4) {
                        Iterator i = ((ArrayInitializer)valueExpression).expressions().iterator();
                        while (i.hasNext()) {
                            Expression expression = (Expression)i.next();
                            if (expression.getNodeType() != 77 || !((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals("SecondaryTable")) continue;
                            if (this.getEntity().getSecondaryTables().size() <= numSecondaryTables) {
                                SecondaryTable secondaryTable = OrmFactory.eINSTANCE.createSecondaryTable(this.buildSecondaryTableModelAdapter());
                                ((JavaSecondaryTableModelAdapter)secondaryTable.getModelAdapter()).updatePersModel(astRoot);
                                this.getEntity().getSecondaryTables().add((Object)secondaryTable);
                            } else {
                                ((JavaSecondaryTableModelAdapter)((SecondaryTable)this.getEntity().getSecondaryTables().get(numSecondaryTables)).getModelAdapter()).updatePersModel(astRoot);
                            }
                            ++numSecondaryTables;
                        }
                    }
                }
            }
        }
        if (numSecondaryTables < this.getEntity().getSecondaryTables().size()) {
            int i = this.getEntity().getSecondaryTables().size();
            while (i > numSecondaryTables) {
                this.getEntity().getSecondaryTables().remove(i - 1);
                --i;
            }
        }
    }

    private AttributeOverride attributeOverrideNamed(String attributeName) {
        Iterator overrides = this.getEntity().getAttributeOverrides().iterator();
        while (overrides.hasNext()) {
            AttributeOverride override = (AttributeOverride)overrides.next();
            if (override.getName() == null || !override.getName().equals(attributeName)) continue;
            return override;
        }
        return null;
    }

    private boolean existsInJava(AttributeOverride override, CompilationUnit astRoot) {
        String overrideName = override.getName();
        if (overrideName == null) {
            return false;
        }
        Iterator attributeNames = this.getEntity().inheritedAttributeNames();
        while (attributeNames.hasNext()) {
            String attributeName = (String)attributeNames.next();
            if (!overrideName.equals(attributeName)) continue;
            return true;
        }
        Iterator overrideAnnotations = this.attributeOverrideNormalAnnotations(astRoot).iterator();
        while (overrideAnnotations.hasNext()) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)overrideAnnotations.next();
            if (!overrideName.equals(this.nameFromAttributeOverrideAnnotation(normalAnnotation))) continue;
            return true;
        }
        return false;
    }

    private void updatePersAttributeOverrides(CompilationUnit astRoot) {
        ArrayList<AttributeOverride> overridesToRemove = new ArrayList<AttributeOverride>();
        Iterator overrides = this.getEntity().getAttributeOverrides().iterator();
        while (overrides.hasNext()) {
            AttributeOverride override = (AttributeOverride)overrides.next();
            if (!this.existsInJava(override, astRoot)) {
                overridesToRemove.add(override);
                continue;
            }
            ((JavaAttributeOverrideModelAdapter)override.getModelAdapter()).updatePersModel(astRoot);
        }
        this.getEntity().getAttributeOverrides().removeAll(overridesToRemove);
        Iterator i = this.attributeOverrideNormalAnnotations(astRoot).iterator();
        while (i.hasNext()) {
            this.addOrUpdatePersAttributeOverrideFrom((NormalAnnotation)i.next(), astRoot);
        }
        Iterator attributes = this.getEntity().inheritedAttributeNames();
        while (attributes.hasNext()) {
            String attributeName = (String)attributes.next();
            AttributeOverride existingOverride = this.attributeOverrideNamed(attributeName);
            if (existingOverride != null) continue;
            this.createAttributeOverride(attributeName);
        }
    }

    private Collection attributeOverrideNormalAnnotations(CompilationUnit astRoot) {
        ArrayList<Annotation> overrideAnnotations = new ArrayList<Annotation>();
        Annotation attributeOverridesAnnotation = this.type.getAnnotation("AttributeOverrides", astRoot);
        if (attributeOverridesAnnotation != null) {
            MemberValuePair valueValuePair;
            Expression valueExpression = null;
            if (attributeOverridesAnnotation.isSingleMemberAnnotation()) {
                valueExpression = ((SingleMemberAnnotation)attributeOverridesAnnotation).getValue();
            } else if (attributeOverridesAnnotation.isNormalAnnotation() && (valueValuePair = ASTTools.getMemberValuePair((NormalAnnotation)attributeOverridesAnnotation, "value")) != null) {
                valueExpression = valueValuePair.getValue();
            }
            if (valueExpression == null) {
                return overrideAnnotations;
            }
            if (valueExpression.getNodeType() == 77) {
                if (((NormalAnnotation)valueExpression).getTypeName().getFullyQualifiedName().equals("AttributeOverride")) {
                    overrideAnnotations.add((Annotation)valueExpression);
                }
            } else if (valueExpression.getNodeType() == 4) {
                List expressions = ((ArrayInitializer)valueExpression).expressions();
                int i = 0;
                while (i < expressions.size()) {
                    Expression expression = (Expression)expressions.get(i);
                    if (expression.getNodeType() == 77 && ((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals("AttributeOverride")) {
                        overrideAnnotations.add((Annotation)expression);
                    }
                    ++i;
                }
            }
        } else {
            Annotation attributeOverrideAnnotation = this.type.getAnnotation("AttributeOverride", astRoot);
            if (attributeOverrideAnnotation != null && attributeOverrideAnnotation.getNodeType() == 77) {
                overrideAnnotations.add(attributeOverrideAnnotation);
            }
        }
        return overrideAnnotations;
    }

    private void addOrUpdatePersAttributeOverrideFrom(NormalAnnotation attributeOverrideAnnotation, CompilationUnit astRoot) {
        AttributeOverride attributeOverride;
        String attributeName = this.nameFromAttributeOverrideAnnotation(attributeOverrideAnnotation);
        Iterator attributeOverrides = this.getEntity().getAttributeOverrides().iterator();
        while (attributeOverrides.hasNext()) {
            attributeOverride = (AttributeOverride)attributeOverrides.next();
            if (!attributeOverride.getName().equals(attributeName)) continue;
            ((JavaAttributeOverrideModelAdapter)attributeOverride.getModelAdapter()).updatePersModel(astRoot);
            return;
        }
        attributeOverride = this.createAttributeOverride(attributeName);
        attributeOverride.setSpecifiedName(attributeName);
    }

    private String nameFromAttributeOverrideAnnotation(NormalAnnotation attributeOverrideAnnotation) {
        MemberValuePair nameValuePair = ASTTools.getMemberValuePair(attributeOverrideAnnotation, "name");
        String attributeName = null;
        if (nameValuePair != null && nameValuePair.getValue().getNodeType() == 45) {
            attributeName = ((StringLiteral)nameValuePair.getValue()).getLiteralValue();
        }
        return attributeName;
    }

    public void specifiedNameChanged() {
        this.updateJavaSpecifiedName();
    }

    private void updateJavaSpecifiedName() {
        this.specifiedNameAdapter.updateJavaElement();
    }

    protected String defaultName() {
        return this.javaDefaultName();
    }

    private String javaDefaultName() {
        return this.type.getName();
    }

    public ITextRange tableTextRange() {
        return this.getTableModelAdapter().getTextRange();
    }

    public ITextRange getTextRange() {
        return this.type.getTextRange(this.getEntity().getAnnotationName());
    }

    public AttributeOverride createAttributeOverride(String attributeName) {
        JavaAttributeOverrideModelAdapter attributeOverrideModelAdapter = new JavaAttributeOverrideModelAdapter(this.buildAttributeOverrideOwner());
        AttributeOverride attributeOverride = OrmFactory.eINSTANCE.createAttributeOverride(attributeOverrideModelAdapter);
        attributeOverride.setDefaultName(attributeName);
        attributeOverrideModelAdapter.engage(this.type, this.type.createASTRoot());
        this.getEntity().getAttributeOverrides().add((Object)attributeOverride);
        return attributeOverride;
    }

    private IAttributeOverrideModelAdapter.AttributeOverrideOwner buildAttributeOverrideOwner() {
        return new IAttributeOverrideModelAdapter.AttributeOverrideOwner(){

            public TypeMapping getTypeMapping() {
                return JavaEntityModelAdapter.this.getEntity();
            }
        };
    }
}

