/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.orm.AccessType;
import org.eclipse.dali.orm.Embeddable;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.PersistenceSourceRefElement;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IEmbeddableModelAdapter;
import org.eclipse.dali.orm.adapters.IEntityModelAdapter;
import org.eclipse.dali.orm.adapters.INullTypeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.IPersistentTypeModelAdapter;
import org.eclipse.dali.orm.adapters.ITypeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.xml.IXMLTypeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.xml.XMLPersistentAttributeModelAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLPersistentTypeModelAdapter
implements IPersistentTypeModelAdapter {
    private PersistentType persistentType;
    private IDOMElement entityElement;
    private IXMLTypeMappingModelAdapter typeMappingModelAdapter;
    private static final String CLASS_TAG = "p:class";
    private static final String ACCESS_TAG = "p:access";

    public static PersistentAttribute persistentAttributeFor(PersistentType persistentType, IDOMElement entityElement) {
        Iterator i = persistentType.getPersistentAttributes().iterator();
        while (i.hasNext()) {
            PersistentAttribute mapping = (PersistentAttribute)i.next();
            if (!((XMLPersistentAttributeModelAdapter)mapping.getModelAdapter()).persistentAttributeFor(entityElement)) continue;
            return mapping;
        }
        return null;
    }

    public XMLPersistentTypeModelAdapter(IDOMElement entityElement) {
        this.entityElement = entityElement;
    }

    public void setPersistentType(PersistentType persistentType) {
        this.persistentType = persistentType;
    }

    public INullTypeMappingModelAdapter createNullTypeMappingModelAdapter() {
        return null;
    }

    public IEntityModelAdapter createEntityModelAdapter() {
        return null;
    }

    public IEmbeddableModelAdapter createEmbeddableModelAdapter() {
        return null;
    }

    public ITypeMappingModelAdapter createMappedSuperclassModelAdapter() {
        return null;
    }

    public void engage(PersistentType persistentType) {
        this.persistentType = persistentType;
        this.entityElement.addAdapter(new INodeAdapter(){

            public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }
        });
        this.updatePersModel();
    }

    public void disengage() {
    }

    private void disengageTypeMappingModelAdapter() {
    }

    public PersistentType getPersistentType() {
        return this.persistentType;
    }

    public void modelChanged(IStructuredModel model) {
        this.updatePersModel();
        this.typeMappingModelAdapter.modelChanged(model);
    }

    private void updatePersModel() {
        this.updatePersTypeMapping();
        this.updatePersClassName();
        this.updatePersAccessType();
        this.updatePersMappings();
    }

    private void updatePersClassName() {
        String persClassName;
        String xmlClassName = this.xmlClassName();
        if (!xmlClassName.equals(persClassName = this.persistentType.getClassName())) {
            this.persistentType.setClassName(xmlClassName);
        }
    }

    private String xmlClassName() {
        IDOMElement element;
        Node node;
        NodeList elements = this.entityElement.getElementsByTagName(CLASS_TAG);
        if (elements.getLength() > 0 && (node = (element = (IDOMElement)elements.item(0)).getFirstChild()).getNodeType() == 3) {
            return node.getNodeValue();
        }
        return "";
    }

    private void updatePersTypeMapping() {
        TypeMapping.Key persTypeMappingKey;
        TypeMapping.Key xmlTypeMappingKey = this.xmlTypeMappingKey();
        if (xmlTypeMappingKey.equals(persTypeMappingKey = this.persistentType.getTypeMappingKey())) {
            return;
        }
        this.persistentType.setTypeMappingKey(xmlTypeMappingKey);
    }

    private TypeMapping.Key xmlTypeMappingKey() {
        String tagName = this.entityElement.getLocalName();
        if (tagName.equals("entity")) {
            return Entity.Key.INSTANCE;
        }
        if (tagName.equals("embeddable")) {
            return Embeddable.Key.INSTANCE;
        }
        throw new IllegalStateException();
    }

    private void updatePersAccessType() {
        AccessType xmlAccessType = this.xmlAccessType();
        AccessType persAccessType = this.persistentType.getAccessType();
        if (xmlAccessType != null && xmlAccessType != persAccessType) {
            this.persistentType.setAccessType(xmlAccessType);
        }
    }

    private AccessType xmlAccessType() {
        Node node;
        IDOMElement accessElement;
        NodeList accessElements = this.entityElement.getElementsByTagName(ACCESS_TAG);
        if (accessElements.getLength() > 0 && (accessElement = (IDOMElement)accessElements.item(0)) != null && (node = accessElement.getFirstChild()).getNodeType() == 3) {
            String accessType = node.getNodeValue();
            if (accessType.equals("FIELD")) {
                return AccessType.FIELD_LITERAL;
            }
            if (accessType.equals("PROPERTY")) {
                return AccessType.PROPERTY_LITERAL;
            }
        }
        return AccessType.DEFAULT_LITERAL;
    }

    private void updatePersMappings() {
        IDOMElement[] mappingNodes = this.mappingNodes();
        Collection mappingsToRemove = CollectionTools.collection((Iterator)this.persistentType.getPersistentAttributes().iterator());
        Iterator i = this.persistentType.getPersistentAttributes().iterator();
        while (i.hasNext()) {
            PersistentAttribute mapping = (PersistentAttribute)i.next();
            boolean mappingExists = false;
            int j = 0;
            while (j < mappingNodes.length) {
                IDOMElement domElement = mappingNodes[j];
                if (((XMLPersistentAttributeModelAdapter)mapping.getModelAdapter()).persistentAttributeFor(domElement)) {
                    ((XMLPersistentAttributeModelAdapter)mapping.getModelAdapter()).synchWithXML();
                    mappingExists = true;
                }
                ++j;
            }
            if (!mappingExists) continue;
            mappingsToRemove.remove(mapping);
        }
        i = mappingsToRemove.iterator();
        while (i.hasNext()) {
            this.persistentType.getPersistentAttributes().remove(i.next());
        }
        int i2 = 0;
        while (i2 < mappingNodes.length) {
            IDOMElement domElement = mappingNodes[i2];
            if (XMLPersistentTypeModelAdapter.persistentAttributeFor(this.persistentType, domElement) == null) {
                XMLPersistentAttributeModelAdapter modelAdapter = new XMLPersistentAttributeModelAdapter(domElement);
                PersistentAttribute persistentAttribute = OrmFactory.eINSTANCE.createPersistentAttribute(modelAdapter);
                this.persistentType.getPersistentAttributes().add((Object)persistentAttribute);
                modelAdapter.engage(domElement);
            }
            ++i2;
        }
    }

    private IDOMElement[] mappingNodes() {
        ArrayList<Node> mappingNodes = new ArrayList<Node>();
        Iterator i = DaliPlugin.getPlugin().possibleXMLMappings();
        while (i.hasNext()) {
            String xmlTagName = (String)i.next();
            NodeList nodes = this.entityElement.getElementsByTagName(xmlTagName);
            int j = 0;
            while (j < nodes.getLength()) {
                mappingNodes.add(nodes.item(j));
                ++j;
            }
        }
        return mappingNodes.toArray(new IDOMElement[mappingNodes.size()]);
    }

    public void accessTypeChanged() {
        this.updateXmlAccessType();
    }

    private void updateXmlAccessType() {
        AccessType persAccessType;
        AccessType xmlAccessType = this.xmlAccessType();
        if (xmlAccessType == (persAccessType = this.persistentType.getAccessType())) {
            return;
        }
        switch (persAccessType.getValue()) {
            case 0: {
                IDOMElement accessElement = this.accessElement();
                if (accessElement == null) break;
                this.entityElement.removeChild((Node)accessElement);
                break;
            }
            case 2: {
                this.setAccessType("FIELD");
                break;
            }
            case 1: {
                this.setAccessType("PROPERTY");
                break;
            }
        }
    }

    public PersistenceSourceRefElement persistenceObjectAt(int offset) {
        return null;
    }

    public ITextRange getTextRange() {
        return new ITextRange(){

            public int getOffset() {
                return XMLPersistentTypeModelAdapter.this.entityElement.getStartOffset();
            }

            public int getLength() {
                return XMLPersistentTypeModelAdapter.this.entityElement.getLength();
            }

            public int getLineNumber() {
                return 0;
            }
        };
    }

    private IDOMElement accessElement() {
        NodeList accessElements = this.entityElement.getElementsByTagName(ACCESS_TAG);
        if (accessElements.getLength() > 0) {
            return (IDOMElement)accessElements.item(0);
        }
        return null;
    }

    private void setAccessType(String accessType) {
        Node node;
        IDOMElement accessElement = this.accessElement();
        if (accessElement != null && (node = accessElement.getFirstChild()).getNodeType() == 3) {
            ((Text)node).setNodeValue(accessType);
        }
    }

    public PersistentType getParentPersistentType() {
        return null;
    }
}

