/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.List;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.Inheritance;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PrimaryKeyJoinColumn;
import org.eclipse.dali.orm.adapters.IPrimaryKeyJoinColumnModelAdapter;
import org.eclipse.dali.orm.impl.AbstractJoinColumnImpl;
import org.eclipse.emf.ecore.EClass;

public class PrimaryKeyJoinColumnImpl
extends AbstractJoinColumnImpl
implements PrimaryKeyJoinColumn {
    protected PrimaryKeyJoinColumnImpl() {
    }

    protected PrimaryKeyJoinColumnImpl(IPrimaryKeyJoinColumnModelAdapter modelAdapter) {
        super(modelAdapter);
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.PRIMARY_KEY_JOIN_COLUMN;
    }

    public int indexInContainer() {
        return ((IPrimaryKeyJoinColumnModelAdapter)this.getModelAdapter()).index(this);
    }

    public void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.addUnresolvedJoinColumnProblemTo(problems);
        this.addUnresolvedReferencedColumnProblemTo(problems);
    }

    private void addUnresolvedJoinColumnProblemTo(List problems) {
        String tableName;
        if (this.getPersistenceProject().getConnection().isConnected() && !this.columnResolves(tableName = this.getNameTableName(), this.getName())) {
            problems.add(this.buildProblem("The primary key join column " + this.getName() + " cannot be found on the table " + tableName, this.joinColumnTextRange()));
        }
    }

    private void addUnresolvedReferencedColumnProblemTo(List problems) {
        String tableName;
        if (this.getPersistenceProject().getConnection().isConnected() && !this.columnResolves(tableName = this.getReferencedNameTableName(), this.getReferencedColumnName())) {
            problems.add(this.buildProblem("The primary key join column referenced column " + this.getReferencedColumnName() + " cannot be found on the table " + tableName, this.referencedColumnTextRange()));
        }
    }

    private Inheritance getInheritance() {
        return (Inheritance)this.getParent();
    }

    protected String getNameTableName() {
        return ((Entity)this.getInheritance().getParent()).getTable().getName();
    }

    protected String getReferencedNameTableName() {
        return this.getInheritance().parentEntity().getTable().getName();
    }
}

