/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.CustomOrdering;
import org.eclipse.dali.orm.MultiRelationshipMapping;
import org.eclipse.dali.orm.NoOrdering;
import org.eclipse.dali.orm.OrderBy;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PrimaryKeyOrdering;
import org.eclipse.dali.orm.adapters.ICustomOrderingModelAdapter;
import org.eclipse.dali.orm.adapters.IMultiRelationshipMappingModelAdapter;
import org.eclipse.dali.orm.adapters.IPersistenceModelAdapter;
import org.eclipse.dali.orm.adapters.IPrimaryKeyOrderingModelAdapter;
import org.eclipse.dali.orm.provider.CustomOrderingItemProvider;
import org.eclipse.dali.orm.provider.MultiRelationshipMappingItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.PrimaryKeyOrderingItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class OrderByComposite
extends Composite
implements IPersistenceComposite {
    private OrderBy orderBy;
    private Button noOrderingRadioButton;
    private Button primaryKeyOrderingRadioButton;
    private Button customOrderingRadioButton;
    private ITextViewer orderingTextViewer;
    private CustomOrderingItemProvider customOrderingItemProvider;
    private INotifyChangedListener customOrderingListener;
    private PrimaryKeyOrderingItemProvider primaryKeyOrderingItemProvider;
    private INotifyChangedListener primaryKeyOrderingListener;
    private EditingDomain editingDomain;
    private boolean populating;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public OrderByComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory, MultiRelationshipMappingItemProvider itemProvider) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.customOrderingItemProvider = (CustomOrderingItemProvider)adapterFactory.createCustomOrderingAdapter();
        this.primaryKeyOrderingItemProvider = (PrimaryKeyOrderingItemProvider)adapterFactory.createPrimaryKeyOrderingAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group orderByGroup = new Group((Composite)this, 16);
        orderByGroup.setText(DaliUiMessages.OrderByComposite_orderByGroup);
        orderByGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        orderByGroup.setLayoutData((Object)gridData);
        this.noOrderingRadioButton = this.buildNoOrderingRadioButton((Composite)orderByGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.noOrderingRadioButton.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.noOrderingRadioButton, "org.eclipse.dali.ui.mapping_orderByNoOrdering");
        this.primaryKeyOrderingRadioButton = this.buildPrimaryKeyOrderingRadioButton((Composite)orderByGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.primaryKeyOrderingRadioButton.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.primaryKeyOrderingRadioButton, "org.eclipse.dali.ui.mapping_orderByPrimaryKeyOrdering");
        this.customOrderingRadioButton = this.buildCustomOrderingRadioButton((Composite)orderByGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.customOrderingRadioButton.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.customOrderingRadioButton, "org.eclipse.dali.ui.mapping_orderByCustomOrdering");
        this.orderingTextViewer = this.buildOrderByTestViewer((Composite)orderByGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 15;
        this.orderingTextViewer.getTextWidget().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.orderingTextViewer.getTextWidget(), "org.eclipse.dali.ui.mapping_orderBy");
    }

    private Button buildNoOrderingRadioButton(Composite parent) {
        Button button = new Button(parent, 16);
        button.setText(DaliUiMessages.OrderByComposite_noOrdering);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OrderByComposite.this.noOrderingRadioButtonSelected(e);
            }
        });
        return button;
    }

    private MultiRelationshipMapping multiRelationshipMapping() {
        return (MultiRelationshipMapping)this.orderBy.eContainer();
    }

    void noOrderingRadioButtonSelected(SelectionEvent e) {
        if (!((Button)e.widget).getSelection()) {
            return;
        }
        if (this.orderBy instanceof NoOrdering) {
            return;
        }
        IPersistenceModelAdapter modelAdapter = ((IMultiRelationshipMappingModelAdapter)this.multiRelationshipMapping().getModelAdapter()).createNoOrderingModelAdapter();
        NoOrdering noOrdering = OrmFactory.eINSTANCE.createNoOrdering(modelAdapter);
        this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.multiRelationshipMapping(), (Object)OrmPackage.eINSTANCE.getMultiRelationshipMapping_OrderBy(), (Object)noOrdering));
    }

    private Button buildPrimaryKeyOrderingRadioButton(Composite parent) {
        Button button = new Button(parent, 16);
        button.setText(DaliUiMessages.OrderByComposite_primaryKeyOrdering);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OrderByComposite.this.primaryKeyOrderingRadioButtonSelected(e);
            }
        });
        return button;
    }

    void primaryKeyOrderingRadioButtonSelected(SelectionEvent e) {
        if (!((Button)e.widget).getSelection()) {
            return;
        }
        if (this.orderBy instanceof PrimaryKeyOrdering) {
            return;
        }
        IPrimaryKeyOrderingModelAdapter modelAdapter = ((IMultiRelationshipMappingModelAdapter)this.multiRelationshipMapping().getModelAdapter()).createPrimaryKeyOrderingModelAdapter();
        PrimaryKeyOrdering pkOrdering = OrmFactory.eINSTANCE.createPrimaryKeyOrdering(modelAdapter);
        this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.multiRelationshipMapping(), (Object)OrmPackage.eINSTANCE.getMultiRelationshipMapping_OrderBy(), (Object)pkOrdering));
    }

    private Button buildCustomOrderingRadioButton(Composite parent) {
        Button button = new Button(parent, 16);
        button.setText(DaliUiMessages.OrderByComposite_customOrdering);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OrderByComposite.this.customOrderingRadioButtonSelected(e);
            }
        });
        return button;
    }

    void customOrderingRadioButtonSelected(SelectionEvent e) {
        if (!((Button)e.widget).getSelection()) {
            return;
        }
        if (this.orderBy instanceof CustomOrdering) {
            return;
        }
        ICustomOrderingModelAdapter modelAdapter = ((IMultiRelationshipMappingModelAdapter)this.multiRelationshipMapping().getModelAdapter()).createCustomOrderingModelAdapter();
        CustomOrdering customOrdering = OrmFactory.eINSTANCE.createCustomOrdering(modelAdapter);
        this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.multiRelationshipMapping(), (Object)OrmPackage.eINSTANCE.getMultiRelationshipMapping_OrderBy(), (Object)customOrdering));
    }

    private ITextViewer buildOrderByTestViewer(Composite parent) {
        TextViewer textViewer = new TextViewer(parent, 2052);
        textViewer.setDocument((IDocument)new Document());
        textViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                OrderByComposite.this.orderingTextViewerChanged();
            }
        });
        return textViewer;
    }

    private void orderingTextViewerChanged() {
        if (this.populating) {
            return;
        }
        String orderByValue = this.orderingTextViewer.getDocument().get();
        if (orderByValue.equals(((CustomOrdering)this.orderBy).getValue())) {
            return;
        }
        this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.orderBy, (Object)OrmPackage.eINSTANCE.getCustomOrdering_Value(), (Object)orderByValue));
    }

    private INotifyChangedListener getCustomOrderingListener() {
        if (this.customOrderingListener == null) {
            this.customOrderingListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    OrderByComposite.this.customOrderingChanged(notification);
                }
            };
        }
        return this.customOrderingListener;
    }

    private void customOrderingChanged(Notification notification) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.CustomOrdering");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 0) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    OrderByComposite.this.populateOrderingRadioButtons();
                }
            });
        }
    }

    private INotifyChangedListener getPrimaryKeyOrderingListener() {
        if (this.primaryKeyOrderingListener == null) {
            this.primaryKeyOrderingListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    OrderByComposite.this.primaryKeyOrderingChanged(notification);
                }
            };
        }
        return this.primaryKeyOrderingListener;
    }

    private void primaryKeyOrderingChanged(Notification notification) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dali.orm.PrimaryKeyOrdering");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 0) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    OrderByComposite.this.populateOrderingRadioButtons();
                }
            });
        }
    }

    public void populate(EObject model) {
        this.disenageListeners();
        this.orderBy = (OrderBy)model;
        if (this.orderBy != null) {
            this.engageListeners();
            this.populateOrderingRadioButtons();
        }
    }

    private void engageListeners() {
        if (this.orderBy instanceof CustomOrdering) {
            this.customOrderingItemProvider.addListener(this.getCustomOrderingListener());
            this.orderBy.eAdapters().add((Object)this.customOrderingItemProvider);
        }
        if (this.orderBy instanceof PrimaryKeyOrdering) {
            this.primaryKeyOrderingItemProvider.addListener(this.getPrimaryKeyOrderingListener());
            this.orderBy.eAdapters().add((Object)this.primaryKeyOrderingItemProvider);
        }
    }

    private void disenageListeners() {
        if (this.orderBy != null) {
            if (this.orderBy instanceof CustomOrdering) {
                this.customOrderingItemProvider.removeListener(this.getCustomOrderingListener());
                this.orderBy.eAdapters().remove((Object)this.customOrderingItemProvider);
            }
            if (this.orderBy instanceof PrimaryKeyOrdering) {
                this.primaryKeyOrderingItemProvider.removeListener(this.getPrimaryKeyOrderingListener());
                this.orderBy.eAdapters().remove((Object)this.primaryKeyOrderingItemProvider);
            }
        }
    }

    private void populateOrderingRadioButtons() {
        this.populating = true;
        if (this.orderBy instanceof NoOrdering) {
            this.primaryKeyOrderingRadioButton.setSelection(false);
            this.customOrderingRadioButton.setSelection(false);
            this.noOrderingRadioButton.setSelection(true);
            if (!"".equals(this.orderingTextViewer.getDocument().get())) {
                this.orderingTextViewer.getDocument().set("");
            }
        } else if (this.orderBy instanceof PrimaryKeyOrdering) {
            this.customOrderingRadioButton.setSelection(false);
            this.noOrderingRadioButton.setSelection(false);
            this.primaryKeyOrderingRadioButton.setSelection(true);
            String value = ((PrimaryKeyOrdering)this.orderBy).getValue();
            if (value != null && !value.equals(this.orderingTextViewer.getDocument().get())) {
                this.orderingTextViewer.getDocument().set(value);
            } else if (!"".equals(this.orderingTextViewer.getDocument().get())) {
                this.orderingTextViewer.getDocument().set("");
            }
        } else if (this.orderBy instanceof CustomOrdering) {
            this.noOrderingRadioButton.setSelection(false);
            this.primaryKeyOrderingRadioButton.setSelection(false);
            this.customOrderingRadioButton.setSelection(true);
            String value = ((CustomOrdering)this.orderBy).getValue();
            if (value != null && !value.equals(this.orderingTextViewer.getDocument().get())) {
                this.orderingTextViewer.getDocument().set(value);
            }
        }
        this.orderingTextViewer.setEditable(this.orderBy instanceof CustomOrdering);
        this.orderingTextViewer.getTextWidget().setEnabled(this.orderBy instanceof CustomOrdering);
        this.populating = false;
    }

    public void dispose() {
        this.disenageListeners();
        super.dispose();
    }
}

