/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.BasicMapping;
import org.eclipse.dali.orm.FetchTypeDefaultEager;
import org.eclipse.dali.orm.Optional;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.Temporal;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IBasicMappingModelAdapter;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.adapters.ITemporalModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.dali.orm.adapters.java.BooleanAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.IJavaDefaultAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaTemporalModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.QualifiedName;

public class JavaBasicMappingModelAdapter
extends JavaAttributeMappingModelAdapter
implements IBasicMappingModelAdapter,
IJavaDefaultAttributeMappingModelAdapter {
    private EnumAnnotationElementAdapter fetchTypeAdapter = new EnumAnnotationElementAdapter(this.buildFetchTypeInfo());
    private BooleanAnnotationElementAdapter optionalAdapter = new BooleanAnnotationElementAdapter(this.buildOptionalInfo());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;

    public ITemporalModelAdapter createTemporalModelAdapter(String temporalTypeName) {
        return new JavaTemporalModelAdapter(this.getAttribute(), temporalTypeName);
    }

    public IColumnModelAdapter createColumnModelAdapter() {
        return new JavaColumnModelAdapter(this.getAttribute(), this.buildColumnOwner());
    }

    private IColumnModelAdapter.ColumnOwner buildColumnOwner() {
        return new IColumnModelAdapter.ColumnOwner(){

            public Table getTableNamed(String tableName) {
                return this.getTypeMapping().getResolvedDBTable(tableName);
            }

            public TypeMapping getTypeMapping() {
                return JavaBasicMappingModelAdapter.this.getBasicMapping().getTypeMapping();
            }

            public ITextRange getTextRange() {
                return JavaBasicMappingModelAdapter.this.getAttributeMapping().getTextRange();
            }
        };
    }

    private EnumAnnotationElementAdapter.EnumAnnotationElementInfo buildFetchTypeInfo() {
        return new EnumAnnotationElementAdapter.EnumAnnotationElementInfo(){

            public void setPersValue(String fetchType) {
                if (fetchType == null) {
                    return;
                }
                if (fetchType.equals("EAGER")) {
                    JavaBasicMappingModelAdapter.this.getBasicMapping().setFetchType(FetchTypeDefaultEager.EAGER_LITERAL);
                } else if (fetchType.equals("LAZY")) {
                    JavaBasicMappingModelAdapter.this.getBasicMapping().setFetchType(FetchTypeDefaultEager.LAZY_LITERAL);
                } else if (fetchType.equals(FetchTypeDefaultEager.DEFAULT_LITERAL.getName())) {
                    JavaBasicMappingModelAdapter.this.getBasicMapping().setFetchType(FetchTypeDefaultEager.DEFAULT_LITERAL);
                }
            }

            public String persValue() {
                FetchTypeDefaultEager fetchType = JavaBasicMappingModelAdapter.this.getBasicMapping().getFetchType();
                if (((Object)((Object)fetchType)).equals((Object)FetchTypeDefaultEager.EAGER_LITERAL)) {
                    return "EAGER";
                }
                if (((Object)((Object)fetchType)).equals((Object)FetchTypeDefaultEager.LAZY_LITERAL)) {
                    return "LAZY";
                }
                return FetchTypeDefaultEager.DEFAULT_LITERAL.getName();
            }

            public String enumClassName() {
                return "FetchType";
            }

            public String annotationElementName() {
                return "fetch";
            }

            public String annotationName() {
                return JavaBasicMappingModelAdapter.this.attributeMappingName();
            }

            public Member member() {
                return JavaBasicMappingModelAdapter.this.getAttribute();
            }

            public String defaultValue() {
                return FetchTypeDefaultEager.DEFAULT_LITERAL.getName();
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildOptionalInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                if (newValue == null) {
                    JavaBasicMappingModelAdapter.this.getBasicMapping().setOptional(Optional.DEFAULT_LITERAL);
                } else if (newValue.equals("true")) {
                    JavaBasicMappingModelAdapter.this.getBasicMapping().setOptional(Optional.TRUE_LITERAL);
                } else if (newValue.equals("false")) {
                    JavaBasicMappingModelAdapter.this.getBasicMapping().setOptional(Optional.FALSE_LITERAL);
                }
            }

            public String persValue() {
                switch (JavaBasicMappingModelAdapter.this.getBasicMapping().getOptional().getValue()) {
                    case 1: {
                        return "true";
                    }
                    case 2: {
                        return "false";
                    }
                }
                return null;
            }

            public String annotationElementName() {
                return "optional";
            }

            public String annotationName() {
                return "Basic";
            }

            public Member member() {
                return JavaBasicMappingModelAdapter.this.getAttribute();
            }

            public String defaultValue() {
                return null;
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    protected AttributeMapping buildAttributeMapping(boolean isDefault) {
        return OrmFactory.eINSTANCE.createBasicMapping(this, isDefault);
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.updatePersFetchType(astRoot);
        this.updatePersOptional(astRoot);
        this.updatePersColumn(astRoot);
        this.updatePersTemporal(astRoot);
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
        super.postUpdatePersModel(astRoot);
        this.getColumnModelAdapter().postUpdatePersModel(astRoot);
    }

    private void updatePersFetchType(CompilationUnit astRoot) {
        this.fetchTypeAdapter.updatePersElement(astRoot);
    }

    private void updatePersOptional(CompilationUnit astRoot) {
        this.optionalAdapter.updatePersElement(astRoot);
    }

    private void updatePersColumn(CompilationUnit astRoot) {
        this.getColumnModelAdapter().updatePersModel(astRoot);
    }

    private void updatePersTemporal(CompilationUnit astRoot) {
        Annotation annotation = this.getAttribute().getAnnotation("Temporal", astRoot);
        Temporal temporal = this.getBasicMapping().getTemporal();
        if (annotation == null) {
            if (temporal != null) {
                this.getBasicMapping().setTemporal(null);
            }
        } else {
            Expression expression = ASTTools.element(annotation, "value");
            String string = null;
            if (expression != null && expression.getNodeType() == 40) {
                string = ((QualifiedName)expression).getName().getIdentifier();
            }
            if (temporal == null) {
                this.getBasicMapping().setTemporal(this.createTemporalModelAdapter(string).getTemporal());
            }
            this.getTemporalModelAdapter().updatePersModel(astRoot);
        }
    }

    public void defaultChanged() {
        this.updateJavaDefault();
    }

    public void fetchTypeChanged() {
        this.updateJavaFetchType();
    }

    public void optionalChanged() {
        this.updateJavaOptional();
    }

    public void temporalChanged() {
        this.updateJavaTemporal();
    }

    private void updateJavaDefault() {
        boolean persDefault;
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        boolean javaDefault = this.javaPersistentAttributeType(astRoot) == null;
        if (javaDefault == (persDefault = this.getBasicMapping().isDefault())) {
            return;
        }
        if (persDefault) {
            this.removeAnnotation("Basic");
        } else {
            this.addMappingAnnotation("Basic");
        }
    }

    private void updateJavaFetchType() {
        this.fetchTypeAdapter.updateJavaElement();
    }

    private void updateJavaOptional() {
        this.optionalAdapter.updateJavaElement();
    }

    private void updateJavaTemporal() {
        Temporal temporal = this.getBasicMapping().getTemporal();
        Annotation annotation = this.getAttribute().getAnnotation("Temporal");
        if (temporal == null) {
            if (annotation != null) {
                this.getAttribute().removeAnnotation("Temporal");
            }
        } else if (annotation == null) {
            this.getAttribute().addAnnotation("Temporal");
        }
    }

    BasicMapping getBasicMapping() {
        return (BasicMapping)this.getAttributeMapping();
    }

    private JavaColumnModelAdapter getColumnModelAdapter() {
        return (JavaColumnModelAdapter)this.getBasicMapping().getColumn().getModelAdapter();
    }

    private JavaTemporalModelAdapter getTemporalModelAdapter() {
        return (JavaTemporalModelAdapter)this.getBasicMapping().getTemporal().getModelAdapter();
    }

    public String attributeMappingName() {
        return "Basic";
    }

    public boolean defaultApplies(Attribute attribute, PersistentAttribute persistentAttribute) {
        IType type;
        String[][] resolvedType;
        boolean isArray;
        if (attribute.isPrimitiveType()) {
            return true;
        }
        String signature = attribute.getTypeSignature();
        boolean bl = isArray = Signature.getArrayCount((String)signature) != 0;
        if (isArray && this.isArrayType(attribute.getTypeSignature())) {
            return true;
        }
        String typeName = Signature.getSignatureSimpleName((String)signature);
        try {
            resolvedType = attribute.getJDTMember().getDeclaringType().resolveType(typeName);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        if (resolvedType == null || resolvedType.length > 1) {
            return false;
        }
        String packageName = resolvedType[0][0];
        String fullyQualifiedTypeName = String.valueOf(packageName) + "." + typeName;
        if (this.isPrimitiveWrapperType(fullyQualifiedTypeName)) {
            return true;
        }
        if (this.isOtherJavaType(fullyQualifiedTypeName)) {
            return true;
        }
        try {
            type = attribute.getJDTMember().getCompilationUnit().getJavaProject().findType(fullyQualifiedTypeName);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        if (type == null) {
            return false;
        }
        if (this.isEnumType(type)) {
            return true;
        }
        return this.implementsSerializable(type);
    }

    private boolean isPrimitiveWrapperType(String fullyQualifiedTypeName) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz.getName())) {
            return true;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz2.getName())) {
            return true;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz3.getName())) {
            return true;
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz4.getName())) {
            return true;
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz5.getName())) {
            return true;
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz6.getName())) {
            return true;
        }
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz7.getName())) {
            return true;
        }
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz8.getName())) {
            return true;
        }
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return fullyQualifiedTypeName.equals(clazz9.getName());
    }

    private boolean isOtherJavaType(String fullyQualifiedTypeName) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz.getName())) {
            return true;
        }
        Class<?> clazz2 = class$9;
        if (clazz2 == null) {
            try {
                clazz2 = class$9 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz2.getName())) {
            return true;
        }
        Class<?> clazz3 = class$10;
        if (clazz3 == null) {
            try {
                clazz3 = class$10 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz3.getName())) {
            return true;
        }
        Class<?> clazz4 = class$11;
        if (clazz4 == null) {
            try {
                clazz4 = class$11 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz4.getName())) {
            return true;
        }
        Class<?> clazz5 = class$12;
        if (clazz5 == null) {
            try {
                clazz5 = class$12 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz5.getName())) {
            return true;
        }
        Class<?> clazz6 = class$13;
        if (clazz6 == null) {
            try {
                clazz6 = class$13 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz6.getName())) {
            return true;
        }
        Class<?> clazz7 = class$14;
        if (clazz7 == null) {
            try {
                clazz7 = class$14 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz7.getName())) {
            return true;
        }
        Class<?> clazz8 = class$15;
        if (clazz8 == null) {
            try {
                clazz8 = class$15 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz8.getName())) {
            return true;
        }
        Class<?> clazz9 = class$16;
        if (clazz9 == null) {
            try {
                clazz9 = class$16 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz9.getName())) {
            return true;
        }
        Class<?> clazz10 = class$17;
        if (clazz10 == null) {
            try {
                clazz10 = class$17 = Class.forName("[Ljava.lang.Byte;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz10.getName())) {
            return true;
        }
        Class<?> clazz11 = class$18;
        if (clazz11 == null) {
            try {
                clazz11 = class$18 = Class.forName("[C");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz11.getName())) {
            return true;
        }
        Class<?> clazz12 = class$19;
        if (clazz12 == null) {
            try {
                clazz12 = class$19 = Class.forName("[Ljava.lang.Character;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return fullyQualifiedTypeName.equals(clazz12.getName());
    }

    private boolean isArrayType(String fullyQualifiedTypeName) {
        Class<?> clazz = class$16;
        if (clazz == null) {
            try {
                clazz = class$16 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz.getName())) {
            return true;
        }
        Class<?> clazz2 = class$18;
        if (clazz2 == null) {
            try {
                clazz2 = class$18 = Class.forName("[C");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz2.getName())) {
            return true;
        }
        fullyQualifiedTypeName = Signature.getSignatureSimpleName((String)fullyQualifiedTypeName);
        Class<?> clazz3 = class$17;
        if (clazz3 == null) {
            try {
                clazz3 = class$17 = Class.forName("[Ljava.lang.Byte;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(Signature.getSignatureSimpleName((String)clazz3.getName()))) {
            return true;
        }
        Class<?> clazz4 = class$19;
        if (clazz4 == null) {
            try {
                clazz4 = class$19 = Class.forName("[Ljava.lang.Character;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return fullyQualifiedTypeName.equals(Signature.getSignatureSimpleName((String)clazz4.getName()));
    }

    private boolean isEnumType(IType type) {
        try {
            return type.isEnum();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean implementsSerializable(IType type) {
        ITypeHierarchy hierarchy;
        try {
            hierarchy = type.newSupertypeHierarchy(null, null);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        IType[] allSuperInterfaces = hierarchy.getAllSuperInterfaces(type);
        int i = 0;
        while (i < allSuperInterfaces.length) {
            IType superInterface = allSuperInterfaces[i];
            if (superInterface.getFullyQualifiedName().equals("java.io.Serializable")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

