/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.orm.AssociationOverride;
import org.eclipse.dali.orm.AttributeOverride;
import org.eclipse.dali.orm.ColumnHolder;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.SecondaryTable;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IAttributeOverrideModelAdapter;
import org.eclipse.dali.orm.adapters.IEntityModelAdapter;
import org.eclipse.dali.orm.adapters.IInheritanceModelAdapter;
import org.eclipse.dali.orm.adapters.ISecondaryTableModelAdapter;
import org.eclipse.dali.orm.adapters.ITableModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.IJavaTypeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAssociationOverrideModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAttributeOverrideModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaInheritanceModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaSecondaryTableModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaTableModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.SingularPluralTopLevelAnnotationAdapter;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;

public class JavaEntityModelAdapter
implements IEntityModelAdapter,
IJavaTypeMappingModelAdapter {
    private Type type;
    private StringAnnotationElementAdapter specifiedNameAdapter;
    private SingularPluralTopLevelAnnotationAdapter secondaryTablesAdapter;
    private Entity entity;
    static final String SECONDARY_TABLE_ANNOTATION = "SecondaryTable";
    static final String SECONDARY_TABLES_ANNOTATION = "SecondaryTables";

    public JavaEntityModelAdapter(Type type) {
        this.type = type;
        this.specifiedNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedNameElementInfo());
        this.secondaryTablesAdapter = new SingularPluralTopLevelAnnotationAdapter(this.buildSecondaryTablesAnnotationInfo());
    }

    private SingularPluralTopLevelAnnotationAdapter.AnnotationInfo buildSecondaryTablesAnnotationInfo() {
        return new SingularPluralTopLevelAnnotationAdapter.AnnotationInfo(){

            public String singularAnnotationName() {
                return JavaEntityModelAdapter.SECONDARY_TABLE_ANNOTATION;
            }

            public String pluralAnnotationName() {
                return JavaEntityModelAdapter.SECONDARY_TABLES_ANNOTATION;
            }

            public Member member() {
                return JavaEntityModelAdapter.this.type();
            }

            public int listSize() {
                return JavaEntityModelAdapter.this.getEntity().getSecondaryTables().size();
            }

            public boolean supportsDefault() {
                return false;
            }

            public boolean isDefault() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.entity = (Entity)typeMapping;
    }

    public IInheritanceModelAdapter createInheritanceModelAdapter() {
        return new JavaInheritanceModelAdapter(this.type());
    }

    public ITableModelAdapter createTableModelAdapter() {
        return new JavaTableModelAdapter(this.type());
    }

    private JavaTableModelAdapter getTableModelAdapter() {
        return (JavaTableModelAdapter)this.entity.getTable().getModelAdapter();
    }

    private JavaInheritanceModelAdapter getInheritanceModelAdapter() {
        return (JavaInheritanceModelAdapter)this.entity.getInheritance().getModelAdapter();
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaEntityModelAdapter.this.getEntity().setSpecifiedName(newValue);
            }

            public String persValue() {
                return JavaEntityModelAdapter.this.getEntity().getSpecifiedName();
            }

            public String annotationElementName() {
                return "name";
            }

            public String annotationName() {
                return "Entity";
            }

            public Member member() {
                return JavaEntityModelAdapter.this.type;
            }

            public String defaultValue() {
                return null;
            }

            public boolean removeAnnotationIfEmpty() {
                return false;
            }
        };
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultName();
        this.updatePersSpecifiedName(astRoot);
        this.getInheritanceModelAdapter().updatePersModel(astRoot);
        this.getTableModelAdapter().updatePersModel(astRoot);
        this.updatePersSecondaryTables(astRoot);
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
        this.updatePersAttributeOverrides(astRoot);
        this.updatePersAssociationOverrides(astRoot);
        this.getInheritanceModelAdapter().postUpdatePersModel(astRoot);
        this.getTableModelAdapter().postUpdatePersModel(astRoot);
        this.postUpdatePersSecondaryTables(astRoot);
        this.postUpdatePersAttributeOverrides(astRoot);
        this.postUpdatePersAssociationOverrides(astRoot);
    }

    private void postUpdatePersSecondaryTables(CompilationUnit astRoot) {
        Iterator i = this.getEntity().getSecondaryTables().iterator();
        while (i.hasNext()) {
            ((JavaSecondaryTableModelAdapter)((SecondaryTable)i.next()).getModelAdapter()).postUpdatePersModel(astRoot);
        }
    }

    private void postUpdatePersAttributeOverrides(CompilationUnit astRoot) {
        Iterator i = this.getEntity().getAttributeOverrides().iterator();
        while (i.hasNext()) {
            ((JavaAttributeOverrideModelAdapter)((AttributeOverride)i.next()).getModelAdapter()).postUpdatePersModel(astRoot);
        }
    }

    private void postUpdatePersAssociationOverrides(CompilationUnit astRoot) {
        Iterator i = this.getEntity().getAssociationOverrides().iterator();
        while (i.hasNext()) {
            ((JavaAssociationOverrideModelAdapter)((AssociationOverride)i.next()).getModelAdapter()).postUpdatePersModel(astRoot);
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    protected void updatePersSpecifiedName(CompilationUnit astRoot) {
        this.specifiedNameAdapter.updatePersElement(astRoot);
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.entity.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.entity.setDefaultName(name);
        }
    }

    protected Type type() {
        return this.type;
    }

    public ISecondaryTableModelAdapter createSecondaryTableModelAdapter() {
        return new JavaSecondaryTableModelAdapter(this.type);
    }

    private void updatePersSecondaryTables(CompilationUnit astRoot) {
        Annotation secondaryTableAnnotation = this.type().getAnnotation(SECONDARY_TABLE_ANNOTATION, astRoot);
        int numSecondaryTables = 0;
        if (secondaryTableAnnotation != null) {
            if (this.getEntity().getSecondaryTables().size() <= numSecondaryTables) {
                SecondaryTable secondaryTable = OrmFactory.eINSTANCE.createSecondaryTable(this.createSecondaryTableModelAdapter());
                ((JavaSecondaryTableModelAdapter)secondaryTable.getModelAdapter()).updatePersModel(astRoot);
                this.getEntity().getSecondaryTables().add((Object)secondaryTable);
            } else {
                ((JavaSecondaryTableModelAdapter)((SecondaryTable)this.getEntity().getSecondaryTables().get(numSecondaryTables)).getModelAdapter()).updatePersModel(astRoot);
            }
            ++numSecondaryTables;
        } else {
            Annotation secondaryTablesAnnotation = this.type().getAnnotation(SECONDARY_TABLES_ANNOTATION, astRoot);
            if (secondaryTablesAnnotation != null) {
                MemberValuePair valueValuePair;
                Expression valueExpression = null;
                if (secondaryTablesAnnotation.getNodeType() == 79) {
                    valueExpression = ((SingleMemberAnnotation)secondaryTablesAnnotation).getValue();
                } else if (secondaryTablesAnnotation.getNodeType() == 77 && (valueValuePair = ASTTools.memberValuePair(secondaryTablesAnnotation, "value")) != null) {
                    valueExpression = valueValuePair.getValue();
                }
                if (valueExpression != null) {
                    if (valueExpression.getNodeType() == 77) {
                        if (((NormalAnnotation)valueExpression).getTypeName().getFullyQualifiedName().equals(SECONDARY_TABLE_ANNOTATION)) {
                            if (this.getEntity().getSecondaryTables().size() <= numSecondaryTables) {
                                SecondaryTable secondaryTable = OrmFactory.eINSTANCE.createSecondaryTable(this.createSecondaryTableModelAdapter());
                                ((JavaSecondaryTableModelAdapter)secondaryTable.getModelAdapter()).updatePersModel(astRoot);
                                this.getEntity().getSecondaryTables().add((Object)secondaryTable);
                            } else {
                                ((JavaSecondaryTableModelAdapter)((SecondaryTable)this.getEntity().getSecondaryTables().get(numSecondaryTables)).getModelAdapter()).updatePersModel(astRoot);
                            }
                            ++numSecondaryTables;
                        }
                    } else if (valueExpression.getNodeType() == 4) {
                        Iterator i = ((ArrayInitializer)valueExpression).expressions().iterator();
                        while (i.hasNext()) {
                            Expression expression = (Expression)i.next();
                            if (expression.getNodeType() != 77 || !((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals(SECONDARY_TABLE_ANNOTATION)) continue;
                            if (this.getEntity().getSecondaryTables().size() <= numSecondaryTables) {
                                SecondaryTable secondaryTable = OrmFactory.eINSTANCE.createSecondaryTable(this.createSecondaryTableModelAdapter());
                                ((JavaSecondaryTableModelAdapter)secondaryTable.getModelAdapter()).updatePersModel(astRoot);
                                this.getEntity().getSecondaryTables().add((Object)secondaryTable);
                            } else {
                                ((JavaSecondaryTableModelAdapter)((SecondaryTable)this.getEntity().getSecondaryTables().get(numSecondaryTables)).getModelAdapter()).updatePersModel(astRoot);
                            }
                            ++numSecondaryTables;
                        }
                    }
                }
            }
        }
        if (numSecondaryTables < this.getEntity().getSecondaryTables().size()) {
            int i = this.getEntity().getSecondaryTables().size();
            while (i > numSecondaryTables) {
                this.getEntity().getSecondaryTables().remove(i - 1);
                --i;
            }
        }
    }

    private AttributeOverride attributeOverrideNamed(String attributeName) {
        Iterator overrides = this.getEntity().getAttributeOverrides().iterator();
        while (overrides.hasNext()) {
            AttributeOverride override = (AttributeOverride)overrides.next();
            if (override.getName() == null || !override.getName().equals(attributeName)) continue;
            return override;
        }
        return null;
    }

    private boolean existsInJava(AttributeOverride override, CompilationUnit astRoot) {
        String overrideName = override.getName();
        if (overrideName == null) {
            return false;
        }
        Iterator attributeNames = this.getEntity().allOverridableAttributeNames();
        while (attributeNames.hasNext()) {
            String attributeName = (String)attributeNames.next();
            if (!overrideName.equals(attributeName)) continue;
            return true;
        }
        Iterator overrideAnnotations = this.attributeOverrideNormalAnnotations(astRoot).iterator();
        while (overrideAnnotations.hasNext()) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)overrideAnnotations.next();
            if (!overrideName.equals(this.nameFromOverrideAnnotation(normalAnnotation))) continue;
            return true;
        }
        return false;
    }

    private void updatePersAttributeOverrides(CompilationUnit astRoot) {
        ArrayList<AttributeOverride> overridesToRemove = new ArrayList<AttributeOverride>();
        Iterator overrides = this.getEntity().getAttributeOverrides().iterator();
        while (overrides.hasNext()) {
            AttributeOverride override = (AttributeOverride)overrides.next();
            if (!this.existsInJava(override, astRoot)) {
                overridesToRemove.add(override);
                continue;
            }
            ((JavaAttributeOverrideModelAdapter)override.getModelAdapter()).updatePersModel(astRoot);
        }
        this.getEntity().getAttributeOverrides().removeAll(overridesToRemove);
        Iterator i = this.attributeOverrideNormalAnnotations(astRoot).iterator();
        while (i.hasNext()) {
            this.addOrUpdatePersAttributeOverrideFrom((NormalAnnotation)i.next(), astRoot);
        }
        Iterator attributes = this.getEntity().allOverridableAttributeNames();
        while (attributes.hasNext()) {
            String attributeName = (String)attributes.next();
            AttributeOverride existingOverride = this.attributeOverrideNamed(attributeName);
            if (existingOverride != null) continue;
            this.createAttributeOverride(attributeName);
        }
    }

    private Collection attributeOverrideNormalAnnotations(CompilationUnit astRoot) {
        ArrayList<Object> overrideAnnotations = new ArrayList<Object>();
        Annotation attributeOverridesAnnotation = this.type.getAnnotation("AttributeOverrides", astRoot);
        if (attributeOverridesAnnotation != null) {
            MemberValuePair valueValuePair;
            Expression valueExpression = null;
            if (attributeOverridesAnnotation.isSingleMemberAnnotation()) {
                valueExpression = ((SingleMemberAnnotation)attributeOverridesAnnotation).getValue();
            } else if (attributeOverridesAnnotation.isNormalAnnotation() && (valueValuePair = ASTTools.memberValuePair((NormalAnnotation)attributeOverridesAnnotation, "value")) != null) {
                valueExpression = valueValuePair.getValue();
            }
            if (valueExpression == null) {
                return overrideAnnotations;
            }
            if (valueExpression.getNodeType() == 77) {
                if (((NormalAnnotation)valueExpression).getTypeName().getFullyQualifiedName().equals("AttributeOverride")) {
                    overrideAnnotations.add(valueExpression);
                }
            } else if (valueExpression.getNodeType() == 4) {
                List expressions = ((ArrayInitializer)valueExpression).expressions();
                int i = 0;
                while (i < expressions.size()) {
                    Expression expression = (Expression)expressions.get(i);
                    if (expression.getNodeType() == 77 && ((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals("AttributeOverride")) {
                        overrideAnnotations.add(expression);
                    }
                    ++i;
                }
            }
        } else {
            Annotation attributeOverrideAnnotation = this.type.getAnnotation("AttributeOverride", astRoot);
            if (attributeOverrideAnnotation != null && attributeOverrideAnnotation.getNodeType() == 77) {
                overrideAnnotations.add(attributeOverrideAnnotation);
            }
        }
        return overrideAnnotations;
    }

    private void addOrUpdatePersAttributeOverrideFrom(NormalAnnotation attributeOverrideAnnotation, CompilationUnit astRoot) {
        String attributeName = this.nameFromOverrideAnnotation(attributeOverrideAnnotation);
        Iterator attributeOverrides = this.getEntity().getAttributeOverrides().iterator();
        while (attributeOverrides.hasNext()) {
            AttributeOverride attributeOverride = (AttributeOverride)attributeOverrides.next();
            if (!attributeOverride.getName().equals(attributeName)) continue;
            ((JavaAttributeOverrideModelAdapter)attributeOverride.getModelAdapter()).updatePersModel(astRoot);
            return;
        }
        this.createAttributeOverride(attributeName);
    }

    private String nameFromOverrideAnnotation(NormalAnnotation overrideAnnotation) {
        MemberValuePair nameValuePair = ASTTools.memberValuePair(overrideAnnotation, "name");
        String attributeName = null;
        if (nameValuePair != null && nameValuePair.getValue().getNodeType() == 45) {
            attributeName = ((StringLiteral)nameValuePair.getValue()).getLiteralValue();
        }
        return attributeName;
    }

    private AssociationOverride associationOverrideNamed(String attributeName) {
        Iterator overrides = this.getEntity().getAssociationOverrides().iterator();
        while (overrides.hasNext()) {
            AssociationOverride override = (AssociationOverride)overrides.next();
            if (override.getName() == null || !override.getName().equals(attributeName)) continue;
            return override;
        }
        return null;
    }

    private boolean existsInJava(AssociationOverride override, CompilationUnit astRoot) {
        String overrideName = override.getName();
        if (overrideName == null) {
            return false;
        }
        Iterator attributeNames = this.getEntity().allOverridableAssociationNames();
        while (attributeNames.hasNext()) {
            String attributeName = (String)attributeNames.next();
            if (!overrideName.equals(attributeName)) continue;
            return true;
        }
        Collection overrideAnnotations = this.overrideNormalAnnotations(astRoot, "AssociationOverride", "AssociationOverrides");
        Iterator i = overrideAnnotations.iterator();
        while (i.hasNext()) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)i.next();
            if (!overrideName.equals(this.nameFromOverrideAnnotation(normalAnnotation))) continue;
            return true;
        }
        return false;
    }

    private void updatePersAssociationOverrides(CompilationUnit astRoot) {
        ArrayList<AssociationOverride> overridesToRemove = new ArrayList<AssociationOverride>();
        Iterator overrides = this.getEntity().getAssociationOverrides().iterator();
        while (overrides.hasNext()) {
            AssociationOverride override = (AssociationOverride)overrides.next();
            if (!this.existsInJava(override, astRoot)) {
                overridesToRemove.add(override);
                continue;
            }
            ((JavaAssociationOverrideModelAdapter)override.getModelAdapter()).updatePersModel(astRoot);
        }
        this.getEntity().getAssociationOverrides().removeAll(overridesToRemove);
        Collection overrideAnnotations = this.overrideNormalAnnotations(astRoot, "AssociationOverride", "AssociationOverrides");
        Iterator i = overrideAnnotations.iterator();
        while (i.hasNext()) {
            this.addOrUpdatePersAssociationOverrideFrom((NormalAnnotation)i.next(), astRoot);
        }
        Iterator attributes = this.getEntity().allOverridableAssociationNames();
        while (attributes.hasNext()) {
            String attributeName = (String)attributes.next();
            AssociationOverride existingOverride = this.associationOverrideNamed(attributeName);
            if (existingOverride != null) continue;
            this.createAssociationOverride(attributeName);
        }
    }

    private Collection overrideNormalAnnotations(CompilationUnit astRoot, String singularAnnotation, String pluralAnnotation) {
        ArrayList<Object> overrideAnnotations = new ArrayList<Object>();
        Annotation overridesAnnotation = this.type.getAnnotation(pluralAnnotation, astRoot);
        if (overridesAnnotation != null) {
            MemberValuePair valueValuePair;
            Expression valueExpression = null;
            if (overridesAnnotation.isSingleMemberAnnotation()) {
                valueExpression = ((SingleMemberAnnotation)overridesAnnotation).getValue();
            } else if (overridesAnnotation.isNormalAnnotation() && (valueValuePair = ASTTools.memberValuePair((NormalAnnotation)overridesAnnotation, "value")) != null) {
                valueExpression = valueValuePair.getValue();
            }
            if (valueExpression == null) {
                return overrideAnnotations;
            }
            if (valueExpression.getNodeType() == 77) {
                if (((NormalAnnotation)valueExpression).getTypeName().getFullyQualifiedName().equals(singularAnnotation)) {
                    overrideAnnotations.add(valueExpression);
                }
            } else if (valueExpression.getNodeType() == 4) {
                List expressions = ((ArrayInitializer)valueExpression).expressions();
                int i = 0;
                while (i < expressions.size()) {
                    Expression expression = (Expression)expressions.get(i);
                    if (expression.getNodeType() == 77 && ((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals(singularAnnotation)) {
                        overrideAnnotations.add(expression);
                    }
                    ++i;
                }
            }
        } else {
            Annotation overrideAnnotation = this.type.getAnnotation(singularAnnotation, astRoot);
            if (overrideAnnotation != null && overrideAnnotation.getNodeType() == 77) {
                overrideAnnotations.add(overrideAnnotation);
            }
        }
        return overrideAnnotations;
    }

    private void addOrUpdatePersAssociationOverrideFrom(NormalAnnotation associationOverrideAnnotation, CompilationUnit astRoot) {
        String attributeName = this.nameFromOverrideAnnotation(associationOverrideAnnotation);
        Iterator assocationOverrides = this.getEntity().getAssociationOverrides().iterator();
        while (assocationOverrides.hasNext()) {
            AssociationOverride assocationOverride = (AssociationOverride)assocationOverrides.next();
            if (!assocationOverride.getName().equals(attributeName)) continue;
            ((JavaAssociationOverrideModelAdapter)assocationOverride.getModelAdapter()).updatePersModel(astRoot);
            return;
        }
        this.createAttributeOverride(attributeName);
    }

    public void specifiedNameChanged() {
        this.updateJavaSpecifiedName();
    }

    private void updateJavaSpecifiedName() {
        this.specifiedNameAdapter.updateJavaElement();
    }

    public void secondaryTableAdded() {
        this.secondaryTablesAdapter.modelElementAdded();
    }

    public void secondaryTableRemoved(int position) {
        this.secondaryTablesAdapter.modelElementRemoved(position);
    }

    protected String defaultName() {
        return this.javaDefaultName();
    }

    private String javaDefaultName() {
        return this.type.getName();
    }

    public ITextRange tableTextRange() {
        return this.getTableModelAdapter().getTextRange();
    }

    public ITextRange getTextRange() {
        return this.type.getTextRange(this.getEntity().getAnnotationName());
    }

    public AttributeOverride createAttributeOverride(String attributeName) {
        JavaAttributeOverrideModelAdapter attributeOverrideModelAdapter = new JavaAttributeOverrideModelAdapter(this.type(), this.buildAttributeOverrideOwner(attributeName));
        AttributeOverride attributeOverride = OrmFactory.eINSTANCE.createAttributeOverride(attributeOverrideModelAdapter);
        attributeOverride.setName(attributeName);
        attributeOverrideModelAdapter.updatePersModel(this.type.createASTRoot());
        this.getEntity().getAttributeOverrides().add((Object)attributeOverride);
        return attributeOverride;
    }

    public AssociationOverride createAssociationOverride(String attributeName) {
        JavaAssociationOverrideModelAdapter associationOverrideModelAdapter = new JavaAssociationOverrideModelAdapter(this.type());
        AssociationOverride associationOverride = OrmFactory.eINSTANCE.createAssociationOverride(associationOverrideModelAdapter);
        associationOverride.setName(attributeName);
        associationOverrideModelAdapter.updatePersModel(this.type.createASTRoot());
        this.getEntity().getAssociationOverrides().add((Object)associationOverride);
        return associationOverride;
    }

    private IAttributeOverrideModelAdapter.AttributeOverrideOwner buildAttributeOverrideOwner(final String attributeName) {
        return new IAttributeOverrideModelAdapter.AttributeOverrideOwner(){

            public TypeMapping getTypeMapping() {
                return JavaEntityModelAdapter.this.getEntity();
            }

            public ColumnHolder columnMapping() {
                Entity entity = JavaEntityModelAdapter.this.getEntity();
                Iterator i = entity.getPersistentType().getAllPersistentAttributes().iterator();
                while (i.hasNext()) {
                    PersistentAttribute persAttribute = (PersistentAttribute)i.next();
                    if (!persAttribute.getName().equals(attributeName) || !(persAttribute.getAttributeMapping() instanceof ColumnHolder)) continue;
                    return (ColumnHolder)((Object)persAttribute.getAttributeMapping());
                }
                return null;
            }
        };
    }
}

