/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.CascadeType;
import org.eclipse.dali.orm.RelationshipMapping;
import org.eclipse.dali.orm.adapters.IAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.IRelationshipMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;

public abstract class JavaRelationshipMappingModelAdapter
extends JavaAttributeMappingModelAdapter
implements IRelationshipMappingModelAdapter {
    private static final String TARGET_ENTITY_ELEMENT_NAME = "targetEntity";
    private EnumAnnotationElementAdapter fetchTypeAdapter = new EnumAnnotationElementAdapter(this.buildFetchTypeInfo());
    private static final String[] PRIMITIVE_TYPE_NAMES = new String[]{Boolean.TYPE.getName(), Character.TYPE.getName(), Byte.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName()};
    private static final String[] PRIMITIVE_WRAPPER_TYPE_NAMES;
    private static final String[] SIMPLE_TYPE_NAMES;
    private static final String[] CONTAINER_TYPE_NAMES;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;
    static /* synthetic */ Class class$27;

    static {
        String[] stringArray = new String[8];
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        Class<?> clazz2 = class$9;
        if (clazz2 == null) {
            try {
                clazz2 = class$9 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz2.getName();
        Class<?> clazz3 = class$10;
        if (clazz3 == null) {
            try {
                clazz3 = class$10 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[2] = clazz3.getName();
        Class<?> clazz4 = class$11;
        if (clazz4 == null) {
            try {
                clazz4 = class$11 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz4.getName();
        Class<?> clazz5 = class$12;
        if (clazz5 == null) {
            try {
                clazz5 = class$12 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[4] = clazz5.getName();
        Class<?> clazz6 = class$13;
        if (clazz6 == null) {
            try {
                clazz6 = class$13 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[5] = clazz6.getName();
        Class<?> clazz7 = class$14;
        if (clazz7 == null) {
            try {
                clazz7 = class$14 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[6] = clazz7.getName();
        Class<?> clazz8 = class$15;
        if (clazz8 == null) {
            try {
                clazz8 = class$15 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[7] = clazz8.getName();
        PRIMITIVE_WRAPPER_TYPE_NAMES = stringArray;
        String[] stringArray2 = new String[8];
        Class<?> clazz9 = class$16;
        if (clazz9 == null) {
            try {
                clazz9 = class$16 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray2[0] = clazz9.getName();
        Class<?> clazz10 = class$17;
        if (clazz10 == null) {
            try {
                clazz10 = class$17 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray2[1] = clazz10.getName();
        Class<?> clazz11 = class$18;
        if (clazz11 == null) {
            try {
                clazz11 = class$18 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray2[2] = clazz11.getName();
        Class<?> clazz12 = class$19;
        if (clazz12 == null) {
            try {
                clazz12 = class$19 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray2[3] = clazz12.getName();
        Class<?> clazz13 = class$20;
        if (clazz13 == null) {
            try {
                clazz13 = class$20 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray2[4] = clazz13.getName();
        Class<?> clazz14 = class$21;
        if (clazz14 == null) {
            try {
                clazz14 = class$21 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray2[5] = clazz14.getName();
        Class<?> clazz15 = class$22;
        if (clazz15 == null) {
            try {
                clazz15 = class$22 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray2[6] = clazz15.getName();
        Class<?> clazz16 = class$23;
        if (clazz16 == null) {
            try {
                clazz16 = class$23 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray2[7] = clazz16.getName();
        SIMPLE_TYPE_NAMES = stringArray2;
        String[] stringArray3 = new String[4];
        Class<?> clazz17 = class$24;
        if (clazz17 == null) {
            try {
                clazz17 = class$24 = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray3[0] = clazz17.getName();
        Class<?> clazz18 = class$25;
        if (clazz18 == null) {
            try {
                clazz18 = class$25 = Class.forName("java.util.Set");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray3[1] = clazz18.getName();
        Class<?> clazz19 = class$26;
        if (clazz19 == null) {
            try {
                clazz19 = class$26 = Class.forName("java.util.List");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray3[2] = clazz19.getName();
        Class<?> clazz20 = class$27;
        if (clazz20 == null) {
            try {
                clazz20 = class$27 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray3[3] = clazz20.getName();
        CONTAINER_TYPE_NAMES = stringArray3;
    }

    protected JavaRelationshipMappingModelAdapter() {
    }

    protected abstract EnumAnnotationElementAdapter.EnumAnnotationElementInfo buildFetchTypeInfo();

    public void updatePersModel(CompilationUnit astRoot) {
        super.updatePersModel(astRoot);
        this.updatePersCascadeType((RelationshipMapping)this.getAttributeMapping(), astRoot);
        this.updatePersFetchType(astRoot);
        this.updatePersDefaultTargetEntity((RelationshipMapping)this.getAttributeMapping());
        this.updatePersSpecifiedTargetEntity((RelationshipMapping)this.getAttributeMapping(), astRoot);
    }

    private void updatePersCascadeType(RelationshipMapping relationshipMapping, CompilationUnit astRoot) {
        CascadeType javaCascadeType = this.javaCascadeType(relationshipMapping, astRoot);
        CascadeType persCascadeType = relationshipMapping.getCascadeType();
        if (javaCascadeType != null && javaCascadeType != persCascadeType) {
            relationshipMapping.setCascadeType(javaCascadeType);
        }
    }

    private void updatePersFetchType(CompilationUnit astRoot) {
        this.fetchTypeAdapter.updatePersElement(astRoot);
    }

    private void updatePersSpecifiedTargetEntity(RelationshipMapping relationshipMapping, CompilationUnit astRoot) {
        String javaSpecifiedTargetEntity = this.javaSpecifiedTargetEntity(relationshipMapping, astRoot);
        String persSpecifiedTargetEntity = relationshipMapping.getSpecifiedTargetEntity();
        if (javaSpecifiedTargetEntity == null && persSpecifiedTargetEntity == null) {
            return;
        }
        if (javaSpecifiedTargetEntity == null || !javaSpecifiedTargetEntity.equals(persSpecifiedTargetEntity)) {
            relationshipMapping.setSpecifiedTargetEntity(javaSpecifiedTargetEntity);
        }
    }

    private void updatePersDefaultTargetEntity(RelationshipMapping relationshipMapping) {
        String javaDefaultTargetEntity = this.javaDefaultTargetEntity();
        String persDefaultTargetEntity = relationshipMapping.getDefaultTargetEntity();
        if (javaDefaultTargetEntity == null && persDefaultTargetEntity == null) {
            return;
        }
        if (javaDefaultTargetEntity == null || !javaDefaultTargetEntity.equals(persDefaultTargetEntity)) {
            relationshipMapping.setDefaultTargetEntity(javaDefaultTargetEntity);
        }
    }

    public void cascadeTypeChanged() {
        this.updateJavaCascadeType();
    }

    public void specifiedTargetEntityChanged() {
        this.updateJavaSpecifiedTargetEntity();
    }

    public void fetchTypeChanged() {
        this.updateJavaFetchType();
    }

    protected RelationshipMapping getRelationshipMapping() {
        return (RelationshipMapping)this.getAttributeMapping();
    }

    private void updateJavaSpecifiedTargetEntity() {
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        final String persSpecifiedTargetEntity = this.getRelationshipMapping().getSpecifiedTargetEntity();
        String javaSpecifiedTargetEntity = this.javaSpecifiedTargetEntity(this.getRelationshipMapping(), astRoot);
        if (persSpecifiedTargetEntity == null && javaSpecifiedTargetEntity == null) {
            return;
        }
        if (persSpecifiedTargetEntity != null && persSpecifiedTargetEntity.equals(javaSpecifiedTargetEntity)) {
            return;
        }
        final String annotationName = this.attributeMappingName();
        if (persSpecifiedTargetEntity == null || persSpecifiedTargetEntity.equals("")) {
            if (this.containsAnnotationElement(annotationName, TARGET_ENTITY_ELEMENT_NAME, astRoot)) {
                this.removeAnnotationElementNamed(annotationName, TARGET_ENTITY_ELEMENT_NAME);
            }
            return;
        }
        if (!this.getRelationshipMapping().isValidTargetEntity(persSpecifiedTargetEntity)) {
            throw new IllegalArgumentException("targetEntity is not valid");
        }
        this.getAttribute().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation annotation = ASTTools.annotation(bodyDeclaration, annotationName);
                AST ast = bodyDeclaration.getAST();
                if (annotation.isNormalAnnotation()) {
                    List values = ((NormalAnnotation)annotation).values();
                    boolean hasName = false;
                    ListIterator i = values.listIterator();
                    while (i.hasNext()) {
                        MemberValuePair valuePair = (MemberValuePair)i.next();
                        if (!valuePair.getName().getFullyQualifiedName().equals(JavaRelationshipMappingModelAdapter.TARGET_ENTITY_ELEMENT_NAME)) continue;
                        hasName = true;
                        Name name = ast.newName(persSpecifiedTargetEntity);
                        TypeLiteral typeLiteral = ast.newTypeLiteral();
                        typeLiteral.setType((Type)ast.newSimpleType(name));
                        valuePair.setValue((Expression)typeLiteral);
                    }
                    if (!hasName) {
                        MemberValuePair valuePair = ast.newMemberValuePair();
                        valuePair.setName(ast.newSimpleName(JavaRelationshipMappingModelAdapter.TARGET_ENTITY_ELEMENT_NAME));
                        TypeLiteral typeLiteral = ast.newTypeLiteral();
                        typeLiteral.setType((Type)ast.newSimpleType(ast.newName(persSpecifiedTargetEntity)));
                        valuePair.setValue((Expression)typeLiteral);
                        ASTTools.addValuePair((NormalAnnotation)annotation, valuePair);
                    }
                } else {
                    NormalAnnotation normalAnnotation = ASTTools.newNormalAnnotation(ast, annotationName);
                    MemberValuePair valuePair = ast.newMemberValuePair();
                    valuePair.setName(ast.newSimpleName(JavaRelationshipMappingModelAdapter.TARGET_ENTITY_ELEMENT_NAME));
                    TypeLiteral typeLiteral = ast.newTypeLiteral();
                    typeLiteral.setType((Type)ast.newSimpleType(ast.newName(persSpecifiedTargetEntity)));
                    valuePair.setValue((Expression)typeLiteral);
                    normalAnnotation.values().add(valuePair);
                    ASTTools.replaceAnnotation(bodyDeclaration, annotation, (Annotation)normalAnnotation);
                }
            }
        });
    }

    private void updateJavaCascadeType() {
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        CascadeType persCascadeType = this.getRelationshipMapping().getCascadeType();
        CascadeType javaCascadeType = this.javaCascadeType(this.getRelationshipMapping(), astRoot);
        if (javaCascadeType == persCascadeType) {
            return;
        }
        String annotationName = this.attributeMappingName();
        if (persCascadeType.getValue() == 0) {
            if (this.containsAnnotationElement(annotationName, "cascade", astRoot)) {
                this.removeAnnotationElementNamed(annotationName, "cascade");
            }
        } else {
            if (!this.containsAnnotation(annotationName, astRoot)) {
                this.addMappingAnnotation("Basic");
            }
            if (persCascadeType.getValue() == 1) {
                this.setCascadeType(annotationName, "ALL");
            } else if (persCascadeType.getValue() == 3) {
                this.setCascadeType(annotationName, "MERGE");
            } else if (persCascadeType.getValue() == 2) {
                this.setCascadeType(annotationName, "PERSIST");
            } else if (persCascadeType.getValue() == 5) {
                this.setCascadeType(annotationName, "REFRESH");
            } else if (persCascadeType.getValue() == 4) {
                this.setCascadeType(annotationName, "REMOVE");
            }
        }
    }

    private void updateJavaFetchType() {
        this.fetchTypeAdapter.updateJavaElement();
    }

    public String fullyQualifyTargetEntity(String specifiedTargetEntity) {
        String[][] resolvedType;
        if (specifiedTargetEntity == null) {
            return null;
        }
        try {
            resolvedType = this.getType().resolveType(specifiedTargetEntity);
        }
        catch (JavaModelException javaModelException) {
            return specifiedTargetEntity;
        }
        if (resolvedType == null) {
            return specifiedTargetEntity;
        }
        if (resolvedType.length == 1) {
            if (resolvedType[0][0].equals("")) {
                return resolvedType[0][1];
            }
            return String.valueOf(resolvedType[0][0]) + "." + resolvedType[0][1];
        }
        return specifiedTargetEntity;
    }

    private CascadeType javaCascadeType(AttributeMapping persistentAttributeType, CompilationUnit astRoot) {
        if (this.containsAnnotationElement(persistentAttributeType.mappingName(), "cascade", astRoot)) {
            String cascadeType = this.getAnnotationElementString("cascade", astRoot);
            if (cascadeType == null) {
                return null;
            }
            if (cascadeType.equals("ALL")) {
                return CascadeType.ALL_LITERAL;
            }
            if (cascadeType.equals("MERGE")) {
                return CascadeType.MERGE_LITERAL;
            }
            if (cascadeType.equals("PERSIST")) {
                return CascadeType.PERSIST_LITERAL;
            }
            if (cascadeType.equals("REFRESH")) {
                return CascadeType.REFRESH_LITERAL;
            }
            if (cascadeType.equals("REMOVE")) {
                return CascadeType.REMOVE_LITERAL;
            }
            return null;
        }
        return CascadeType.DEFAULT_LITERAL;
    }

    private String javaSpecifiedTargetEntity(AttributeMapping persistentAttributeType, CompilationUnit astRoot) {
        MemberValuePair valuePair = ASTTools.memberValuePair(this.getAttribute().bodyDeclaration(astRoot), ((IAttributeMappingModelAdapter)persistentAttributeType.getModelAdapter()).attributeMappingName(), TARGET_ENTITY_ELEMENT_NAME);
        if (valuePair != null && valuePair.getValue().getNodeType() == 57) {
            TypeLiteral typeLiteral = (TypeLiteral)valuePair.getValue();
            Type type = typeLiteral.getType();
            if (type.isSimpleType()) {
                return ((SimpleType)type).getName().getFullyQualifiedName();
            }
            if (type.isPrimitiveType()) {
                return ((PrimitiveType)type).getPrimitiveTypeCode().toString();
            }
            if (type.isQualifiedType()) {
                Type qualifier = ((QualifiedType)type).getQualifier();
                SimpleName name = ((QualifiedType)type).getName();
                if (qualifier.isSimpleType()) {
                    return String.valueOf(((SimpleType)qualifier).getName().getFullyQualifiedName()) + "." + name.getFullyQualifiedName();
                }
            }
        }
        return null;
    }

    protected String javaDefaultTargetEntity() {
        return this.javaDefaultTargetEntity(this.getAttribute().getTypeSignature());
    }

    protected String javaDefaultTargetEntity(String typeSignature) {
        return this.buildReferenceEntityTypeName(typeSignature);
    }

    protected String buildReferenceEntityTypeName(String typeSignature) {
        String packageName;
        if (Signature.getArrayCount((String)typeSignature) > 0) {
            return null;
        }
        String typeName = Signature.getSignatureSimpleName((String)typeSignature);
        String qualifier = Signature.getSignatureQualifier((String)typeSignature);
        if (qualifier.length() > 0) {
            typeName = String.valueOf(qualifier) + "." + typeName;
        }
        String[][] resolvedTypes = null;
        try {
            resolvedTypes = this.getType().resolveType(typeName);
        }
        catch (JavaModelException javaModelException) {}
        if (resolvedTypes != null && resolvedTypes.length == 1 && (packageName = resolvedTypes[0][0]).length() != 0) {
            typeName = String.valueOf(packageName) + "." + resolvedTypes[0][1];
        }
        if (JavaRelationshipMappingModelAdapter.typeNamedIsBasic(typeName)) {
            return null;
        }
        return typeName;
    }

    private static boolean typeNamedIsBasic(String typeName) {
        if (CollectionTools.contains((Object[])PRIMITIVE_TYPE_NAMES, (Object)typeName)) {
            return true;
        }
        if (CollectionTools.contains((Object[])PRIMITIVE_WRAPPER_TYPE_NAMES, (Object)typeName)) {
            return true;
        }
        return CollectionTools.contains((Object[])SIMPLE_TYPE_NAMES, (Object)typeName);
    }

    protected static boolean typeNamedIsContainer(String typeName) {
        return CollectionTools.contains((Object[])CONTAINER_TYPE_NAMES, (Object)typeName);
    }

    private void setCascadeType(String mappingAnnotation, String cascadeType) {
        this.getAttribute().setMappingAnnotationElementValuePair(mappingAnnotation, "cascade", "CascadeType", cascadeType);
    }

    public ITextRange targetEntityTextRange() {
        MemberValuePair valuePair = this.getAttribute().getMemberValuePair(this.attributeMappingName(), TARGET_ENTITY_ELEMENT_NAME);
        if (valuePair != null) {
            return ASTTools.textRange((ASTNode)valuePair);
        }
        return null;
    }
}

