/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.iterators.NullIterator;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.dali.orm.AttributeOverride;
import org.eclipse.dali.orm.Embeddable;
import org.eclipse.dali.orm.EmbeddedMapping;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.adapters.IEmbeddedMappingModelAdapter;
import org.eclipse.dali.orm.impl.AttributeMappingImpl;
import org.eclipse.dali.orm.impl.ColumnImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class EmbeddedMappingImpl
extends AttributeMappingImpl
implements EmbeddedMapping {
    protected static final boolean DEFAULT_EDEFAULT = true;
    protected boolean default_ = true;
    protected EList attributeOverrides = null;
    static /* synthetic */ Class class$0;

    protected EmbeddedMappingImpl() {
    }

    protected EmbeddedMappingImpl(IEmbeddedMappingModelAdapter modelAdapter, boolean isDefault) {
        super(modelAdapter);
        this.default_ = isDefault;
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.EMBEDDED_MAPPING;
    }

    public boolean isDefault() {
        return this.default_;
    }

    public void setDefaultGen(boolean newDefault) {
        boolean oldDefault = this.default_;
        this.default_ = newDefault;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldDefault, this.default_));
        }
    }

    public void setDefault(boolean newDefault) {
        this.setDefaultGen(newDefault);
        ((IEmbeddedMappingModelAdapter)this.getModelAdapter()).defaultChanged();
    }

    public EList getAttributeOverrides() {
        if (this.attributeOverrides == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dali.orm.AttributeOverride");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.attributeOverrides = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 1);
        }
        return this.attributeOverrides;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getAttributeOverrides()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: {
                return this.getAttributeOverrides();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setDefault((Boolean)newValue);
                return;
            }
            case 1: {
                this.getAttributeOverrides().clear();
                this.getAttributeOverrides().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setDefault(true);
                return;
            }
            case 1: {
                this.getAttributeOverrides().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return !this.default_;
            }
            case 1: {
                return this.attributeOverrides != null && !this.attributeOverrides.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (default: ");
        result.append(this.default_);
        result.append(')');
        return result.toString();
    }

    public void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.addAttributeOverridesProblemsTo(problems);
    }

    private void addAttributeOverridesProblemsTo(List problems) {
        Iterator i = this.getAttributeOverrides().iterator();
        while (i.hasNext()) {
            AttributeOverride override = (AttributeOverride)i.next();
            if (!CollectionTools.contains((Iterator)this.possibleAttributeOverrideNames(), (Object)override.getName())) {
                problems.add(this.buildProblem(this.unresolvedAttributeOverrideMessage(override), override.getTextRange()));
            }
            if (!override.columnResolves()) {
                problems.add(this.buildProblem(this.unresolvedColumnMessage(override), override.getTextRange()));
            }
            ((ColumnImpl)override.getColumn()).addColumnTableNotAssociatedWithOwningEntityProblemTo(problems);
        }
    }

    protected String unresolvedColumnMessage(AttributeOverride override) {
        return "Embeddable attribute " + override.getName() + " mapped to unresolved column \"" + override.getColumn().getName() + "\"";
    }

    protected String unresolvedAttributeOverrideMessage(AttributeOverride override) {
        return "Attribute override " + override.getName() + " is not a valid Embeddable attribute";
    }

    public String getKey() {
        return "embedded";
    }

    public boolean supportsColumn() {
        return true;
    }

    public Embeddable getEmbeddable() {
        return ((IEmbeddedMappingModelAdapter)this.getModelAdapter()).getEmbeddable();
    }

    public Iterator possibleAttributeOverrideNames() {
        Embeddable embeddable = this.getEmbeddable();
        if (embeddable == null) {
            return NullIterator.instance();
        }
        return new TransformationIterator(embeddable.getPersistentType().getPersistentAttributes().iterator()){

            protected Object transform(Object next) {
                return ((PersistentAttribute)next).getName();
            }
        };
    }
}

