/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.sql.SQLException;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.AccessType;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.provider.EntityItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.PersistentTypeItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.AttributeOverridesComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.InheritanceComposite;
import org.eclipse.dali.ui.views.TableComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class EntityComposite
extends Composite
implements IPersistenceComposite {
    private boolean populating;
    private OrmItemProviderAdapterFactory adapterFactory;
    private EditingDomain editingDomain;
    private Entity entity;
    private PersistentType persistentType;
    private ComboViewer accessTypeComboViewer;
    private Combo entityNameCombo;
    private InheritanceComposite inheritanceComposite;
    private TableComposite tableComposite;
    private AttributeOverridesComposite attributeOverridesComposite;
    private EntityItemProvider entityItemProvider;
    private PersistentTypeItemProvider persistentTypeItemProvider;
    private ConnectionListener connectionListener;
    private Connection connection;
    private INotifyChangedListener entityListener;
    private INotifyChangedListener persistentTypeListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public EntityComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.adapterFactory = adapterFactory;
        this.editingDomain = editingDomain;
        this.entityItemProvider = (EntityItemProvider)adapterFactory.createEntityAdapter();
        this.persistentTypeItemProvider = (PersistentTypeItemProvider)adapterFactory.createPersistentTypeAdapter();
        this.connectionListener = this.buildConnectionListener();
        this.initializeLayout();
    }

    private INotifyChangedListener getEntityListener() {
        if (this.entityListener == null) {
            this.entityListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    EntityComposite.this.entityChanged(notification);
                }
            };
        }
        return this.entityListener;
    }

    protected void entityChanged(Notification notification) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.Entity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        switch (notification.getFeatureID((Class)clazz)) {
            case 3: {
                final String name = notification.getNewStringValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        if (name == null) {
                            EntityComposite.this.entityNameCombo.select(0);
                        } else if (!EntityComposite.this.entityNameCombo.getText().equals(name)) {
                            EntityComposite.this.entityNameCombo.setText(name);
                        }
                    }
                });
                break;
            }
            case 2: {
                final String defaultName = notification.getNewStringValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        boolean defaultSelected = false;
                        if (EntityComposite.this.entityNameCombo.getSelectionIndex() == 0) {
                            defaultSelected = true;
                        }
                        EntityComposite.this.entityNameCombo.setItem(0, NLS.bind((String)DaliUiMessages.EntityComposite_defaultWithOneParam, (Object)defaultName));
                        if (defaultSelected) {
                            EntityComposite.this.entityNameCombo.select(0);
                        }
                    }
                });
                break;
            }
            case 4: {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        EntityComposite.this.populateTablePanel();
                    }
                });
                break;
            }
        }
    }

    private INotifyChangedListener getPersistentTypeListener() {
        if (this.persistentTypeListener == null) {
            this.persistentTypeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.dali.orm.PersistentType");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz) == 1) {
                        AccessType accessType = (AccessType)notification.getNewValue();
                        Display.getDefault().syncExec(new Runnable(this, accessType){
                            final /* synthetic */ 5 this$1;
                            private final /* synthetic */ AccessType val$accessType;
                            {
                                this.this$1 = var1_1;
                                this.val$accessType = accessType;
                            }

                            public void run() {
                                if (((StructuredSelection)EntityComposite.access$2(5.access$0(this.this$1)).getSelection()).getFirstElement() != this.val$accessType) {
                                    EntityComposite.access$2(5.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection((Object)this.val$accessType));
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ EntityComposite access$0(5 var0) {
                    return var0.EntityComposite.this;
                }
            };
        }
        return this.persistentTypeListener;
    }

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void connectionInfoRenamed(String previousName, Connection connection) {
            }

            public void connected(Connection connection) {
            }

            public void disconnected(Connection connection) {
            }

            public void sharedConnectionAdded(Connection connection) {
            }

            public void sharedConnectionRemove(Connection connection) {
            }

            public void schemaChanged(Schema schema) {
                EntityComposite.this.populateTablePanel();
            }

            public void tableChanged(Table table) {
            }

            public void databaseAdded(Connection connection, Database database) {
                EntityComposite.this.populateTablePanel();
            }

            public void databaseRemove(Connection connection, Database database) {
                EntityComposite.this.populateTablePanel();
            }

            public void onSQLException(Connection connection, SQLException exception) {
            }
        };
    }

    private void initializeLayout() {
        this.setLayout((Layout)new FillLayout(512));
        TabFolder folder = new TabFolder((Composite)this, 128);
        Control generalControl = this.buildGeneralTab(folder);
        TabItem generalTab = new TabItem(folder, 0);
        generalTab.setText(DaliUiMessages.EntityComposite_general);
        generalTab.setControl(generalControl);
        Control inheritanceControl = this.buildInheritanceTab(folder);
        TabItem inheritanceTab = new TabItem(folder, 0);
        inheritanceTab.setText(DaliUiMessages.EntityComposite_inheritance);
        inheritanceTab.setControl(inheritanceControl);
        folder.setSelection(0);
    }

    private Control buildGeneralTab(TabFolder folder) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.tableComposite = new TableComposite(composite, this.editingDomain, this.adapterFactory);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableComposite.setLayoutData(gridData);
        Label entityNameLabel = new Label(composite, 16384);
        entityNameLabel.setText(DaliUiMessages.EntityComposite_name);
        this.entityNameCombo = this.buildEntityNameCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.entityNameCombo.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.entityNameCombo, "org.eclipse.dali.ui.entity_name");
        Label accessTypeLabel = new Label(composite, 16384);
        accessTypeLabel.setText(DaliUiMessages.EntityComposite_accessType);
        this.accessTypeComboViewer = this.buildAccessTypeCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.accessTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        this.accessTypeComboViewer.getCombo().setEnabled(false);
        helpSystem.setHelp((Control)this.accessTypeComboViewer.getCombo(), "org.eclipse.dali.ui.entity_accessType");
        this.attributeOverridesComposite = new AttributeOverridesComposite(composite, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.attributeOverridesComposite.setLayoutData(gridData);
        return composite;
    }

    private Control buildInheritanceTab(TabFolder folder) {
        this.inheritanceComposite = new InheritanceComposite((Composite)folder, this.editingDomain, this.adapterFactory);
        return this.inheritanceComposite;
    }

    private ComboViewer buildAccessTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(AccessType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EntityComposite.this.accessTypeComboSelectionChanged(event);
            }
        });
        return viewer;
    }

    protected void accessTypeComboSelectionChanged(SelectionChangedEvent event) {
        if (this.populating) {
            return;
        }
        if (event.getSelection() instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.persistentType, (Object)OrmPackage.eINSTANCE.getPersistentType_AccessType(), (Object)selection.getFirstElement()));
        }
    }

    private Combo buildEntityNameCombo(Composite parent) {
        Combo combo = new Combo(parent, 2052);
        combo.add(DaliUiMessages.EntityComposite_defaultEmpty);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EntityComposite.this.entityNameComboModified(e);
            }
        });
        return combo;
    }

    protected void entityNameComboModified(ModifyEvent e) {
        if (this.populating) {
            return;
        }
        this.entityNameCombo.getSelectionIndex();
        String text = ((Combo)e.getSource()).getText();
        if (text.equals(this.entityNameCombo.getItem(0))) {
            text = null;
        }
        this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.entity, (Object)OrmPackage.eINSTANCE.getEntity_SpecifiedName(), (Object)text));
    }

    public void populate(EObject model) {
        this.populating = true;
        this.disengageListeners();
        this.entity = (Entity)model;
        if (this.entity == null) {
            this.persistentType = null;
            this.attributeOverridesComposite.populate(null);
            this.inheritanceComposite.populate(null);
            return;
        }
        this.persistentType = this.entity.getPersistentType();
        this.engageListeners();
        this.populateGeneralPanel();
        this.populateTablePanel();
        this.attributeOverridesComposite.populate((EObject)this.entity);
        this.inheritanceComposite.populate((EObject)this.entity.getInheritance());
        this.populating = false;
    }

    private void engageListeners() {
        this.entityItemProvider.addListener(this.getEntityListener());
        this.entity.eAdapters().add((Object)this.entityItemProvider);
        this.persistentTypeItemProvider.addListener(this.getPersistentTypeListener());
        this.persistentType.eAdapters().add((Object)this.persistentTypeItemProvider);
        this.addConnectionListener();
    }

    private void disengageListeners() {
        if (this.entity != null) {
            this.removeConnectionListener();
            this.entityItemProvider.removeListener(this.getEntityListener());
            this.entity.eAdapters().remove((Object)this.entityItemProvider);
            this.persistentType.eAdapters().remove((Object)this.persistentTypeItemProvider);
            this.persistentTypeItemProvider.removeListener(this.getPersistentTypeListener());
        }
    }

    private void populateGeneralPanel() {
        this.accessTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.persistentType.getAccessType()));
        this.entityNameCombo.getSelectionIndex();
        this.entityNameCombo.setItem(0, NLS.bind((String)DaliUiMessages.EntityComposite_defaultWithOneParam, (Object)this.entity.getDefaultName()));
        String entityName = this.entity.getSpecifiedName();
        if (entityName != null) {
            if (!this.entityNameCombo.getText().equals(entityName)) {
                this.entityNameCombo.setText(entityName);
            }
        } else {
            this.entityNameCombo.select(0);
        }
    }

    private void populateTablePanel() {
        this.tableComposite.populate((EObject)this.entity.getTable());
    }

    public boolean setFocus() {
        super.setFocus();
        return this.entityNameCombo.setFocus();
    }

    public void dispose() {
        this.disengageListeners();
        this.attributeOverridesComposite.dispose();
        this.inheritanceComposite.dispose();
        this.tableComposite.dispose();
        super.dispose();
    }

    private void addConnectionListener() {
        this.connection = this.entity.getPersistenceProject().getConnection();
        this.connection.addConnectionListener(this.connectionListener);
    }

    private void removeConnectionListener() {
        this.connection.removeConnectionListener(this.connectionListener);
        this.connection = null;
    }

    static /* synthetic */ ComboViewer access$2(EntityComposite entityComposite) {
        return entityComposite.accessTypeComboViewer;
    }
}

