/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.validation.el;

import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wtp.jsf.validation.el.Activator;

class LocalizedMessage
extends Message {
    public static final int ERROR_CODE_BEANNAME_NOT_FOUND = 0;
    public static final int ERROR_CODE_BEANPROPERTY_NOT_FOUND = 1;
    public static final int ERROR_CODE_SYNTAX_MISSING_CLOSING_QUOTE = 2;
    public static final int ERROR_CODE_SYNTAX_TEXT = 3;
    public static final String[] _messageTemplateKeys;
    private final String _message;
    private final int _errorCode;

    static {
        String[] stringArray = new String[4];
        stringArray[0] = "VM_ROOT_NAME_NOT_FOUND";
        stringArray[1] = "VM_PROP_NAME_NOT_FOUND";
        _messageTemplateKeys = stringArray;
    }

    public LocalizedMessage(int severity, String messageText, int errorCode) {
        this(severity, messageText, null, errorCode);
    }

    public LocalizedMessage(int severity, String messageText, IResource targetObject, int errorCode) {
        this(severity, messageText, (Object)targetObject, errorCode);
    }

    public LocalizedMessage(int severity, String messageText, Object targetObject, int errorCode) {
        super(null, severity, null);
        this._message = messageText;
        this.setTargetObject(targetObject);
        this._errorCode = errorCode;
    }

    public LocalizedMessage(int severity, IResource targetObject, int errorCode, Object[] messageArgs) {
        super(null, severity, null);
        this._errorCode = errorCode;
        if (errorCode > _messageTemplateKeys.length - 1 || _messageTemplateKeys[errorCode] == null) {
            throw new IllegalArgumentException("Error code " + errorCode + " does not have a resource template");
        }
        String messageTemplateKey = _messageTemplateKeys[errorCode];
        String templateString = Activator.getResourceString(messageTemplateKey);
        this._message = MessageFormat.format(templateString, messageArgs);
    }

    public String getLocalizedMessage() {
        return this._message;
    }

    public String getText() {
        return this.getLocalizedMessage();
    }

    public String getText(ClassLoader cl) {
        return this.getLocalizedMessage();
    }

    public String getText(Locale l) {
        return this.getLocalizedMessage();
    }

    public String getText(Locale l, ClassLoader cl) {
        return this.getLocalizedMessage();
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public boolean appliesTo(int offset) {
        return offset >= this.getOffset() && offset < this.getOffset() + this.getLength();
    }
}

