/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.BaseSectionPartCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.Component;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.ISSESectionPart;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigOrderHelper;

public class AddComponentCommand
extends BaseSectionPartCommand {
    private Object model;
    private static final String DEFAULT_NAME = "New Component";

    public AddComponentCommand(String label, ISSESectionPart sectionPart) {
        super(label, sectionPart);
        this.model = sectionPart.getModel();
    }

    public AddComponentCommand(String label, IStructuredModel model) {
        super(label, model);
        this.model = model;
    }

    protected void doExecute() {
        if (!(this.model instanceof IStructuredModel)) {
            return;
        }
        IDOMDocument document = ((IDOMModel)this.model).getDocument();
        NodeWrapUtil documentWrapUtil = new NodeWrapUtil((IDOMNode)document);
        NodeWrapUtil facesConfigWrap = new NodeWrapUtil((IDOMNode)documentWrapUtil.getChildNode("faces-config"));
        if (facesConfigWrap != null) {
            IDOMNode newComponent = facesConfigWrap.createChildNode("component", false, null, FacesConfigOrderHelper.getInstance());
            NodeWrapUtil newComponentUtil = new NodeWrapUtil(newComponent);
            newComponentUtil.createChildNode("display-name", false, this.getDefaultName(facesConfigWrap.getNode()), FacesConfigOrderHelper.getInstance());
            newComponentUtil.createChildNode("component-type", true, "", FacesConfigOrderHelper.getInstance());
            newComponentUtil.createChildNode("component-class", true, "", FacesConfigOrderHelper.getInstance());
        }
    }

    private String getDefaultName(IDOMNode parentNode) {
        FacesConfig facesConfig = new FacesConfig(parentNode);
        List childrenList = facesConfig.getComponentList();
        String result = "";
        if (!childrenList.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            int n = childrenList.size();
            while (i < n) {
                String displayName = ((Component)childrenList.get(i)).getDisplayName();
                list.add(displayName);
                ++i;
            }
            i = 1;
            while (true) {
                if (list.indexOf(DEFAULT_NAME + i) == -1) {
                    result = DEFAULT_NAME + i;
                    break;
                }
                ++i;
            }
        }
        return result;
    }
}

