/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils.SWTUtils;

public class ValueEditGroup
extends DialogFieldGroup {
    private static final int VALUE_DEFAULT_LINENUMS = 10;
    StringDialogField valueField;
    private Button nullValueTypeButton;
    private String valueType;
    private String value;

    public ValueEditGroup(String valueType, String value) {
        this.valueType = valueType;
        this.value = value;
    }

    public void initialize() {
        this.valueField = new StringDialogField(10);
        this.valueField.setLabelText(EditorResources.getInstance().getString("ValueEditGroup.Value"));
        this.valueField.setDialogFieldChangeListener(this.getDefaultChangeListener());
    }

    public void refreshData() {
        if (this.valueType != null && this.valueType.equalsIgnoreCase("null-value")) {
            this.nullValueTypeButton.setSelection(true);
            this.valueField.setEnabled(false);
        }
        if (this.value != null) {
            this.valueField.setTextWithoutUpdate(this.value);
        }
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        GridData gd = new GridData(1808);
        parent.setLayoutData((Object)gd);
        int numberOfColumns = 3;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        gl.verticalSpacing = 10;
        gl.marginHeight = 10;
        parent.setLayout((Layout)gl);
        this.nullValueTypeButton = null;
        this.nullValueTypeButton = toolkit != null ? toolkit.createButton(parent, "null-value", 16416) : SWTUtils.createCheckBox((Composite)parent, (String)"null-value", (int)2);
        this.nullValueTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ValueEditGroup.this.nullValueTypeButtonClicked();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ValueEditGroup.this.nullValueTypeButtonClicked();
            }
        });
        this.valueField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        gd = (GridData)this.valueField.getLabelControl(toolkit, parent).getLayoutData();
        gd.verticalAlignment |= 0x400;
        LayoutUtil.setHorizontalGrabbing((Control)this.valueField.getTextControl(toolkit, parent));
        gd = (GridData)this.valueField.getTextControl(toolkit, parent).getLayoutData();
        gd.verticalAlignment |= 0x410;
    }

    protected void nullValueTypeButtonClicked() {
        this.valueField.setEnabled(!this.nullValueTypeButton.getSelection());
    }

    public IStatus[] validateDialogFields() {
        return null;
    }

    public String getValueType() {
        String valueType = null;
        valueType = this.nullValueTypeButton.getSelection() ? "null-value" : "value";
        return valueType;
    }

    public String getValue() {
        String value = null;
        value = this.valueField.getText();
        return value;
    }
}

