/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.pageflow;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wtp.jsf.facesconfig.editor.FacesConfigEditor;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.WebrootUtil;

public abstract class ResourceTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    private IEditorPart editor = null;

    public ResourceTransferDropTargetListener(EditPartViewer viewer, IEditorPart editor) {
        super(viewer, (Transfer)ResourceTransfer.getInstance());
        this.editor = editor;
    }

    protected Request createTargetRequest() {
        CreateRequest request = new CreateRequest();
        if (this.getCurrentEvent().data == null) {
            request.setFactory(this.getFactory(null));
        } else {
            IResource[] resources = (IResource[])this.getCurrentEvent().data;
            request.setFactory(this.getFactory(resources[0]));
        }
        return request;
    }

    protected final CreateRequest getCreateRequest() {
        return (CreateRequest)this.getTargetRequest();
    }

    protected abstract CreationFactory getFactory(Object var1);

    protected void handleDragOperationChanged() {
        this.getCurrentEvent().detail = 1;
        super.handleDragOperationChanged();
    }

    private Object getCurrentLocalObject() {
        ISelection sel = LocalSelectionTransfer.getInstance().getSelection();
        if (sel instanceof IStructuredSelection) {
            return ((IStructuredSelection)sel).getFirstElement();
        }
        return null;
    }

    protected void handleDragOver() {
        this.getCurrentEvent().detail = !this.isValidJSFFile(this.getCurrentLocalObject()) ? 2003 : 1;
        this.getCurrentEvent().feedback = 24;
        super.handleDragOver();
    }

    protected void handleDrop() {
        this.getCurrentEvent().detail = 1;
        super.handleDrop();
        if (this.getCurrentEvent().detail == 1) {
            this.selectAddedObject();
        }
    }

    private void selectAddedObject() {
        Object model = this.getCreateRequest().getNewObject();
        if (model == null) {
            return;
        }
        EditPartViewer viewer = this.getViewer();
        Object editpart = viewer.getEditPartRegistry().get(model);
        if (editpart instanceof EditPart) {
            viewer.flush();
            viewer.select((EditPart)editpart);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)((FacesConfigEditor)this.editor));
        }
    }

    protected void updateTargetRequest() {
        CreateRequest request = this.getCreateRequest();
        request.setLocation(this.getDropLocation());
    }

    private boolean isValidJSFFile(Object resource) {
        if (resource == null || !(resource instanceof IResource)) {
            return false;
        }
        return ((IResource)resource).getProject() == ((FileEditorInput)this.editor.getEditorInput()).getFile().getProject() && WebrootUtil.getWebPath((IPath)((IResource)resource).getFullPath()).length() > 0;
    }

    public boolean isEnabled(DropTargetEvent dropTargetEvent) {
        if (super.isEnabled(dropTargetEvent)) {
            if (dropTargetEvent.data != null) {
                IResource[] resources = (IResource[])dropTargetEvent.data;
                return this.isValidJSFFile(resources[0]);
            }
            return true;
        }
        return false;
    }
}

