/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.pageflow.editparts;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.IconResources;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.editparts.IAnnotationEditPart;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.editparts.IConnectionPreference;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.editpolicies.PFLinkBendpointEditPolicy;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.editpolicies.PFLinkEditPolicy;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.editpolicies.PFLinkEndpointEditPolicy;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.figures.PFLinkFigure;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFAction;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFLink;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFLinkBendpoint;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFPage;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils.PageflowAnnotationUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.properties.PageflowElementPropertySource;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.WebrootUtil;

public class PFLinkEditPart
extends AbstractConnectionEditPart
implements IConnectionPreference,
IAnnotationEditPart {
    private PFLinkAdapter adapter = new PFLinkAdapter();
    private IPropertySource propertySource = null;
    public static final ImageDescriptor IMG_WARNING = EditorPlugin.getDefault().getImageDescriptor(IconResources.getString("Pageflow.quickfixerrorobject"));
    private int connectionStyle = -1;
    private PFLinkBendpointEditPolicy bendpointEditPolicy;
    static /* synthetic */ Class class$0;

    public PFLinkEditPart(PFLink element) {
        this.setModel(element);
    }

    protected IFigure createFigure() {
        PFLinkFigure figure = new PFLinkFigure();
        figure.setLabel(((PFLink)this.getModel()).getOutcome());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new PFLinkEndpointEditPolicy());
        if (this.getConnectionRouterStyle() == 0) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)this.getBendpointEditPolicy());
        }
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new PFLinkEditPolicy());
    }

    private PFLinkBendpointEditPolicy getBendpointEditPolicy() {
        if (this.bendpointEditPolicy == null) {
            this.bendpointEditPolicy = new PFLinkBendpointEditPolicy();
        }
        return this.bendpointEditPolicy;
    }

    public PFLink getPFLink() {
        return (PFLink)this.getModel();
    }

    public void activate() {
        this.getPFLink().eAdapters().add((Object)this.adapter);
        super.activate();
    }

    public void deactivate() {
        this.getPFLink().eAdapters().remove((Object)this.adapter);
        super.deactivate();
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return this.getPropertySource();
        }
        return super.getAdapter(key);
    }

    protected IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            this.propertySource = new PageflowElementPropertySource(this.getPFLink());
        }
        return this.propertySource;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        PFLink link = (PFLink)this.getModel();
        if (link.getSource() instanceof PFPage && link.getTarget() instanceof PFAction) {
            ((PFLinkFigure)this.getFigure()).setLabel("");
        } else {
            ((PFLinkFigure)this.getFigure()).setLabel(((PFLink)this.getModel()).getOutcome());
        }
        if (this.getConnectionRouterStyle() == 0) {
            this.refreshBendpoints();
        }
    }

    protected void refreshBendpoints() {
        EList modelConstraint = this.getPFLink().getBendPoints();
        ArrayList<RelativeBendpoint> figureConstraint = new ArrayList<RelativeBendpoint>();
        int i = 0;
        while (i < modelConstraint.size()) {
            PFLinkBendpoint wbp = (PFLinkBendpoint)modelConstraint.get(i);
            RelativeBendpoint rbp = new RelativeBendpoint(this.getConnectionFigure());
            rbp.setRelativeDimensions(wbp.getFirstRelativeDimension(), wbp.getSecondRelativeDimension());
            rbp.setWeight((float)(i + 1) / ((float)modelConstraint.size() + 1.0f));
            figureConstraint.add(rbp);
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(figureConstraint);
    }

    public void setLineWidth(int w) {
        ((PFLinkFigure)this.getFigure()).setLineWidth(w);
    }

    public void setLabelVisible(boolean b) {
        ((PFLinkFigure)this.getFigure()).setLabelVisible(b);
    }

    public void setForegroundColor(Color c) {
        ((PFLinkFigure)this.getFigure()).setForegroundColor(c);
    }

    public void setBackgroundColor(Color c) {
        ((PFLinkFigure)this.getFigure()).setBackgroundColor(c);
    }

    public void setFont(Font f) {
        ((PFLinkFigure)this.getFigure()).setFont(f);
    }

    public void setLabelForegroundColor(Color c) {
        ((PFLinkFigure)this.getFigure()).setLabelForegroundColor(c);
    }

    public void setLabelBackgroundColor(Color c) {
        ((PFLinkFigure)this.getFigure()).setLabelBackgroundColor(c);
    }

    public void addAnnotation(final Annotation annotation) {
        this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ((PFLinkFigure)PFLinkEditPart.this.getFigure()).setImage(PFLinkEditPart.getImage(IMG_WARNING));
                ((PFLinkFigure)PFLinkEditPart.this.getFigure()).setToolTipText(annotation.getText());
            }
        });
    }

    public void removeAnnotation() {
        this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ((PFLinkFigure)PFLinkEditPart.this.getFigure()).setImage(null);
                ((PFLinkFigure)PFLinkEditPart.this.getFigure()).setToolTipText(null);
            }
        });
    }

    public IResource getMarkerResource() {
        IResource resource = WebrootUtil.getResource((EObject)this.getModel());
        return resource;
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        Image image = EditorPlugin.getDefault().getImageRegistry().get(imageDescriptor.toString());
        if (image == null) {
            EditorPlugin.getDefault().getImageRegistry().put(imageDescriptor.toString(), imageDescriptor);
            image = EditorPlugin.getDefault().getImageRegistry().get(imageDescriptor.toString());
        }
        return image;
    }

    public void setConnectionRouterStyle(int style) {
        this.connectionStyle = style;
        if (this.getConnectionRouterStyle() == 0) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)this.getBendpointEditPolicy());
            this.refreshVisuals();
        } else {
            this.removeEditPolicy("Connection Bendpoint Policy");
            this.refreshVisuals();
        }
    }

    public int getConnectionRouterStyle() {
        if (this.connectionStyle == -1) {
            IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
            String connectionStyle = store.getString("LineRouting");
            this.connectionStyle = "Manhattan".equals(connectionStyle) ? 1 : 0;
        }
        return this.connectionStyle;
    }

    private class PFLinkAdapter
    implements Adapter {
        private Notifier _newTarget = null;
        static /* synthetic */ Class class$0;

        private PFLinkAdapter() {
        }

        public Notifier getTarget() {
            return this._newTarget;
        }

        public boolean isAdapterForType(Object type) {
            return PFLinkEditPart.this.getModel().getClass() == type;
        }

        public void notifyChanged(Notification notification) {
            int type = notification.getEventType();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PageflowPackage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            int featureId = notification.getFeatureID((Class)clazz);
            switch (type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    if (featureId == 10 || featureId == 9 || featureId == 8) {
                        PageflowAnnotationUtil.validateLink(PFLinkEditPart.this);
                    }
                    PFLinkEditPart.this.refreshVisuals();
                }
            }
        }

        public void setTarget(Notifier newTarget) {
            this._newTarget = newTarget;
        }
    }
}

