/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout;

import java.util.Stack;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.DirectedGraph;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.Edge;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.GraphVisitor;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.Node;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.Rank;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.RankList;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.RevertableChange;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.VirtualNode;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.VirtualNodeCreation;

class PopulateRanks
extends GraphVisitor {
    private Stack changes = new Stack();

    PopulateRanks() {
    }

    public void visit(DirectedGraph g) {
        Node node;
        int i;
        if (g.forestRoot != null) {
            i = g.forestRoot.outgoing.size() - 1;
            while (i >= 0) {
                g.removeEdge(g.forestRoot.outgoing.getEdge(i));
                --i;
            }
            g.removeNode(g.forestRoot);
        }
        g.ranks = new RankList();
        i = 0;
        while (i < g.nodes.size()) {
            node = g.nodes.getNode(i);
            g.ranks.getRank(node.rank).add(node);
            ++i;
        }
        i = 0;
        while (i < g.nodes.size()) {
            node = g.nodes.getNode(i);
            int j = 0;
            while (j < node.outgoing.size()) {
                Edge e = node.outgoing.getEdge(j);
                if (e.getLength() > 1) {
                    this.changes.push(new VirtualNodeCreation(e, g));
                    continue;
                }
                ++j;
            }
            ++i;
        }
    }

    public void revisit(DirectedGraph g) {
        int r = 0;
        while (r < g.ranks.size()) {
            Rank rank = g.ranks.getRank(r);
            Node prev = null;
            int n = 0;
            while (n < rank.size()) {
                Node cur = rank.getNode(n);
                if (cur instanceof VirtualNode) {
                    ((VirtualNode)cur).left = prev;
                }
                if (prev instanceof VirtualNode) {
                    ((VirtualNode)prev).right = cur;
                }
                prev = cur;
                ++n;
            }
            ++r;
        }
        int i = 0;
        while (i < this.changes.size()) {
            RevertableChange change = (RevertableChange)this.changes.get(i);
            change.revert();
            ++i;
        }
    }
}

