/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils;

import java.util.Iterator;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.editparts.IAnnotationEditPart;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.editparts.PFLinkEditPart;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.editparts.PageflowElementEditPart;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.editparts.PageflowNodeEditPart;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFAction;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFLink;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFPage;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils.PageflowValidation;

public class PageflowAnnotationUtil {
    public static void validatePageflow(GraphicalEditPart containerPart) {
        if (containerPart == null) {
            return;
        }
        Iterator iterChild = containerPart.getChildren().iterator();
        while (iterChild.hasNext()) {
            PageflowElementEditPart element = (PageflowElementEditPart)iterChild.next();
            String errorMessage = null;
            if (element.getModel() instanceof PFAction) {
                errorMessage = PageflowValidation.getInstance().isValidAction((PFAction)element.getModel());
            } else if (element.getModel() instanceof PFPage) {
                errorMessage = PageflowValidation.getInstance().isValidPage((PFPage)element.getModel());
            }
            if (errorMessage != null) {
                PageflowAnnotationUtil.addAnnotation((GraphicalEditPart)element, errorMessage);
            } else {
                PageflowAnnotationUtil.removeAnnotation((GraphicalEditPart)element);
            }
            Iterator iterLinks = element.getSourceConnections().iterator();
            while (iterLinks.hasNext()) {
                PFLinkEditPart link = (PFLinkEditPart)iterLinks.next();
                PageflowAnnotationUtil.validateLink(link);
            }
        }
    }

    public static void validatePage(PageflowNodeEditPart pagePart) {
        if (pagePart == null) {
            return;
        }
        String errorMessage = null;
        PageflowAnnotationUtil.removeAnnotation((GraphicalEditPart)pagePart);
        errorMessage = PageflowValidation.getInstance().isValidPage((PFPage)pagePart.getModel());
        if (errorMessage != null) {
            PageflowAnnotationUtil.addAnnotation((GraphicalEditPart)pagePart, errorMessage);
        }
        Iterator iterLinks = pagePart.getSourceConnections().iterator();
        while (iterLinks.hasNext()) {
            PFLinkEditPart link = (PFLinkEditPart)iterLinks.next();
            PageflowAnnotationUtil.validateLink(link);
        }
    }

    public static void validateAction(PageflowNodeEditPart actionPart) {
        if (actionPart != null) {
            String errorMessage = null;
            PageflowAnnotationUtil.removeAnnotation((GraphicalEditPart)actionPart);
            errorMessage = PageflowValidation.getInstance().isValidAction((PFAction)actionPart.getModel());
            if (errorMessage != null) {
                PageflowAnnotationUtil.addAnnotation((GraphicalEditPart)actionPart, errorMessage);
            }
            Iterator iterLinks = actionPart.getSourceConnections().iterator();
            while (iterLinks.hasNext()) {
                PFLinkEditPart link = (PFLinkEditPart)iterLinks.next();
                PageflowAnnotationUtil.validateLink(link);
            }
        }
    }

    public static void validateLink(PFLinkEditPart linkPart) {
        if (linkPart != null) {
            String errorMessage = null;
            PageflowAnnotationUtil.removeAnnotation((GraphicalEditPart)linkPart);
            errorMessage = PageflowValidation.getInstance().isValidLink((PFLink)linkPart.getModel());
            if (errorMessage != null) {
                PageflowAnnotationUtil.addAnnotation((GraphicalEditPart)linkPart, errorMessage);
            }
        }
    }

    private static void addAnnotation(GraphicalEditPart editPart, String message) {
        if (editPart != null && editPart instanceof IAnnotationEditPart) {
            Annotation annotation = new Annotation("org.eclipse.core.resources.problemmarker", false, message);
            ((IAnnotationEditPart)editPart).addAnnotation(annotation);
        }
    }

    private static void removeAnnotation(GraphicalEditPart editPart) {
        if (editPart != null && editPart instanceof IAnnotationEditPart) {
            ((IAnnotationEditPart)editPart).removeAnnotation();
        }
    }
}

