/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.DescriptionType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.DisplayNameType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.FacesConfig10Factory;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.FromActionType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.FromOutcomeType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.FromViewIdType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.IconType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.LargeIconType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.NavigationCaseType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.NavigationRuleType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.RedirectType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.SmallIconType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.ToViewIdType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfigDocumentWrap;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.Icon;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NavigationCase;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NavigationRule;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFAction;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFLink;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFPage;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.Pageflow;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PageflowFactory;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PageflowNode;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils.LinkHelper;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils.LinkNavigationRule;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils.PageflowModelManager;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils.PageflowValidation;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.WebrootUtil;
import org.w3c.dom.Document;

public class PageflowTransform {
    private static final String CONDITION_SEPERATOR = ";";
    private static PageflowTransform transform;
    private Map mapLinkHelper = null;
    private Map mapUpdatedNavigationCase = null;
    private Map mapLinkNavigationRule = null;
    private FacesConfig10Factory facesConfigFactory = null;
    private PageflowFactory pageflowFactory;
    private Pageflow pageflow;

    private PageflowTransform() {
    }

    public static PageflowTransform getInstance() {
        if (transform == null) {
            transform = new PageflowTransform();
        }
        return transform;
    }

    public void updateFacesConfigModel(Pageflow pageflow, IStructuredModel sseModel) {
        if (sseModel == null || pageflow == null) {
            return;
        }
        FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)((IDOMModel)sseModel).getDocument());
        documentWrap.getFacesConfig().getElement().removeChildNodes("navigation-rule");
        List navigationRulesInPageflow = this.getNavigationRulesInPageflow(pageflow);
        if (navigationRulesInPageflow != null) {
            Iterator iter = navigationRulesInPageflow.iterator();
            while (iter.hasNext()) {
                NavigationRuleType navigationRule = (NavigationRuleType)iter.next();
                FacesConfigUtil.addXMLNavigationRuleFromEMFModel(sseModel, navigationRule);
            }
        }
    }

    public boolean updatePageflowModel(Pageflow pageflow, IStructuredModel sseModel) {
        if (pageflow != null && sseModel != null) {
            this.pageflow = pageflow;
            List navigationRulesInPageflow = this.getNavigationRulesInPageflow(pageflow);
            List navigationRulesInFacesconfig = this.getNavigationRulesInSSEModel(sseModel);
            return this.updateNavigationRulesInPageflow(navigationRulesInFacesconfig, navigationRulesInPageflow);
        }
        return false;
    }

    private List getNavigationRulesInSSEModel(IStructuredModel sseModel) {
        if (sseModel == null) {
            return new ArrayList();
        }
        FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)((IDOMModel)sseModel).getDocument());
        return documentWrap.getFacesConfig().getNavigationList();
    }

    private List getNavigationRulesInPageflow(Pageflow pageflow) {
        ArrayList navigationRulesInPageflow = null;
        ArrayList<PFLink> lstValidLink = new ArrayList<PFLink>();
        EList lstLinks = pageflow.getLinks();
        Iterator<Object> i = lstLinks.iterator();
        while (i.hasNext()) {
            PFLink link = (PFLink)i.next();
            if (!PageflowValidation.getInstance().isValidLinkForNavigationRule(link)) continue;
            lstValidLink.add(link);
        }
        if (!lstValidLink.isEmpty()) {
            this.mapLinkHelper = new HashMap();
            i = lstValidLink.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                LinkHelper linkHelper = null;
                if (!this.mapLinkHelper.containsKey(((PFLink)o).getId())) {
                    linkHelper = new LinkHelper((PFLink)o);
                    this.mapLinkHelper.put(((PFLink)o).getId(), linkHelper);
                } else {
                    linkHelper = (LinkHelper)this.mapLinkHelper.get(((PFLink)o).getId());
                }
                this.setAdjacentLinks(lstValidLink, linkHelper);
            }
        }
        if (this.mapLinkHelper != null && !this.mapLinkHelper.isEmpty()) {
            this.mapLinkNavigationRule = new HashMap();
            navigationRulesInPageflow = new ArrayList();
            i = this.mapLinkHelper.values().iterator();
            while (i.hasNext()) {
                LinkHelper linkHelper = (LinkHelper)i.next();
                if (linkHelper.isVisited()) continue;
                PFLink pfLink = (PFLink)linkHelper.getModel();
                if (pfLink.getSource() instanceof PFPage && pfLink.getTarget() instanceof PFPage) {
                    this.addPageToPageNavigationRule(linkHelper, navigationRulesInPageflow);
                    continue;
                }
                if (pfLink.getSource() instanceof PFPage && pfLink.getTarget() instanceof PFAction) {
                    this.addPageToActionNavigationRule(linkHelper, navigationRulesInPageflow);
                    continue;
                }
                if (!(pfLink.getSource() instanceof PFAction) || !(pfLink.getTarget() instanceof PFPage)) continue;
                this.addActionToPageNavigationRule(linkHelper, navigationRulesInPageflow);
            }
        }
        return navigationRulesInPageflow;
    }

    private boolean hasSameFromViewID(String fromViewID1, FromViewIdType fromViewID2) {
        String viewID1 = null;
        viewID1 = fromViewID1 == null ? "*" : fromViewID1.trim();
        String viewID2 = null;
        viewID2 = fromViewID2 == null ? "*" : fromViewID2.getValue().trim();
        return viewID1.equalsIgnoreCase(viewID2);
    }

    private boolean hasSameFromViewID(FromViewIdType fromViewID1, FromViewIdType fromViewID2) {
        String viewID1 = null;
        viewID1 = fromViewID1 == null ? "*" : fromViewID1.getValue().trim();
        String viewID2 = null;
        viewID2 = fromViewID2 == null ? "*" : fromViewID2.getValue().trim();
        return viewID1.equalsIgnoreCase(viewID2);
    }

    private boolean updatePageflowWithSameCondition(NavigationRule navigationRuleFC, NavigationCase navigationCaseFC, NavigationRuleType navigationRulePF) {
        if (this.hasSameFromViewID(navigationRuleFC.getFromViewId(), navigationRulePF.getFromViewId())) {
            Iterator iterRulePF = navigationRulePF.getNavigationCase().iterator();
            while (iterRulePF.hasNext()) {
                NavigationCaseType navigationCasePF = (NavigationCaseType)iterRulePF.next();
                if (!this.hasSameCondition(navigationCasePF, navigationCaseFC)) continue;
                LinkNavigationRule linkRule = (LinkNavigationRule)this.mapLinkNavigationRule.get(navigationCasePF);
                PFLink firstLink = linkRule.getFirstLink();
                PFLink secondLink = linkRule.getSecondLink();
                if (firstLink != null && secondLink != null) {
                    String toViewID = navigationCaseFC.getToViewId();
                    if (!((PFPage)secondLink.getTarget()).getPath().equalsIgnoreCase(toViewID)) {
                        String secondFromOutcome = null;
                        if (navigationCaseFC.getFromOutcome() != null && navigationCaseFC.getFromOutcome().length() > 0) {
                            secondFromOutcome = navigationCaseFC.getFromOutcome();
                        }
                        PFLink newLink = this.createPFLink(secondFromOutcome);
                        PageflowNode target = this.findPFPage(toViewID);
                        if (target == null) {
                            target = this.createPFPage(toViewID);
                        }
                        this.updatePageflowTargetPage((PFPage)target, navigationCaseFC);
                        PageflowNode source = secondLink.getSource();
                        source.getOutlinks().remove((Object)secondLink);
                        secondLink.getTarget().getInlinks().remove((Object)secondLink);
                        source.getPageflow().getLinks().remove((Object)secondLink);
                        secondLink = null;
                        newLink.setSource(source);
                        newLink.setTarget(target);
                    }
                } else if (firstLink != null && secondLink == null) {
                    String toViewID = navigationCaseFC.getToViewId();
                    if (!((PFPage)firstLink.getTarget()).getPath().equalsIgnoreCase(toViewID)) {
                        String fromOutcome = null;
                        if (navigationCaseFC.getFromOutcome() != null) {
                            fromOutcome = navigationCaseFC.getFromOutcome();
                        }
                        PFLink newLink = this.createPFLink(fromOutcome);
                        PageflowNode target = this.findPFPage(toViewID);
                        if (target == null) {
                            target = this.createPFPage(toViewID);
                        }
                        this.updatePageflowTargetPage((PFPage)target, navigationCaseFC);
                        PageflowNode source = firstLink.getSource();
                        source.getOutlinks().remove((Object)firstLink);
                        firstLink.getTarget().getInlinks().remove((Object)firstLink);
                        source.getPageflow().getLinks().remove((Object)firstLink);
                        firstLink = null;
                        newLink.setSource(source);
                        newLink.setTarget(target);
                    }
                }
                this.mapUpdatedNavigationCase.put(navigationCasePF, navigationCasePF);
                return true;
            }
        }
        return false;
    }

    private void updatePageflowSourcePage(PFPage sourcePage, NavigationRule navigationRuleFC) {
        if (navigationRuleFC.getDescription() != null && navigationRuleFC.getDescription().length() > 0) {
            String description = navigationRuleFC.getDescription();
            sourcePage.setComment(description);
        }
        if (navigationRuleFC.getDisplayName() != null && navigationRuleFC.getDisplayName().length() > 0) {
            String displayName = navigationRuleFC.getDisplayName();
            sourcePage.setName(displayName);
        }
        if (navigationRuleFC.getIconList() != null && navigationRuleFC.getIconList().size() > 0) {
            Icon icon = (Icon)navigationRuleFC.getIconList().get(0);
            if (icon.getLargeIcon() != null) {
                sourcePage.setLargeicon(icon.getLargeIcon().getNode().getNodeValue());
            }
            if (icon.getSmallIcon() != null) {
                sourcePage.setSmallicon(icon.getSmallIcon().getNode().getNodeValue());
            }
        }
    }

    private void updatePageflowTargetPage(PFPage targetPage, NavigationCase navigationCaseFC) {
        if (navigationCaseFC.getDescription() != null && navigationCaseFC.getDescription().length() > 0) {
            String description = navigationCaseFC.getDescription();
            targetPage.setComment(description);
        }
        if (navigationCaseFC.getDisplayName() != null && navigationCaseFC.getDisplayName().length() > 0) {
            String displayName = navigationCaseFC.getDisplayName();
            targetPage.setName(displayName);
        }
        if (navigationCaseFC.getIconList() != null && navigationCaseFC.getIconList().size() > 0) {
            Icon icon = (Icon)navigationCaseFC.getIconList().get(0);
            if (icon.getLargeIcon() != null) {
                targetPage.setLargeicon(icon.getLargeIcon().getNode().getNodeValue());
            }
            if (icon.getSmallIcon() != null) {
                targetPage.setSmallicon(icon.getSmallIcon().getNode().getNodeValue());
            }
        }
    }

    private boolean hasSameToViewID(ToViewIdType toViewID1, String toViewID2) {
        String viewID1 = null;
        viewID1 = toViewID1 == null ? "" : toViewID1.getValue().trim();
        String viewID2 = null;
        viewID2 = toViewID2 == null ? "" : toViewID2.trim();
        return viewID1.equalsIgnoreCase(viewID2);
    }

    private boolean hasSameToViewID(ToViewIdType toViewID1, ToViewIdType toViewID2) {
        String viewID1 = null;
        viewID1 = toViewID1 == null ? "" : toViewID1.getValue().trim();
        String viewID2 = null;
        viewID2 = toViewID2 == null ? "" : toViewID2.getValue().trim();
        return viewID1.equalsIgnoreCase(viewID2);
    }

    private boolean hasSameCondition(NavigationCaseType navigationCaseFirst, NavigationCase navigationCaseSecond) {
        FromActionType actionFirst = navigationCaseFirst.getFromAction();
        FromOutcomeType outcomeFirst = navigationCaseFirst.getFromOutcome();
        String actionSecond = navigationCaseSecond.getFromAction();
        String outcomeSecond = navigationCaseSecond.getFromOutcome();
        if (actionFirst == null && actionSecond == null && actionSecond.length() > 0 && outcomeFirst == null && outcomeSecond == null && outcomeSecond.length() > 0) {
            return this.hasSameToViewID(navigationCaseFirst.getToViewId(), navigationCaseSecond.getToViewId());
        }
        String firstCondition = "";
        String secondCondition = "";
        firstCondition = actionFirst != null ? String.valueOf(firstCondition) + actionFirst.getValue().trim() + CONDITION_SEPERATOR : String.valueOf(firstCondition) + CONDITION_SEPERATOR;
        firstCondition = outcomeFirst != null ? String.valueOf(firstCondition) + outcomeFirst.getValue().trim() + CONDITION_SEPERATOR : String.valueOf(firstCondition) + CONDITION_SEPERATOR;
        secondCondition = actionSecond != null && actionSecond.length() > 0 ? String.valueOf(secondCondition) + actionSecond.trim() + CONDITION_SEPERATOR : String.valueOf(secondCondition) + CONDITION_SEPERATOR;
        secondCondition = outcomeSecond != null && outcomeSecond.length() > 0 ? String.valueOf(secondCondition) + outcomeSecond.trim() + CONDITION_SEPERATOR : String.valueOf(secondCondition) + CONDITION_SEPERATOR;
        return firstCondition.equalsIgnoreCase(secondCondition);
    }

    private void setAdjacentLinks(List lstValidLink, LinkHelper linkHelper) {
        Iterator i = lstValidLink.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof PFLink) || o == linkHelper.getModel()) continue;
            if (((PFLink)linkHelper.getModel()).getTarget() == ((PFLink)o).getSource()) {
                LinkHelper validSubLink = null;
                if (!this.mapLinkHelper.containsKey(((PFLink)o).getId())) {
                    validSubLink = new LinkHelper((PFLink)o);
                    this.mapLinkHelper.put(((PFLink)o).getId(), validSubLink);
                } else {
                    validSubLink = (LinkHelper)this.mapLinkHelper.get(((PFLink)o).getId());
                }
                linkHelper.addSubsequentLink(validSubLink);
                continue;
            }
            if (((PFLink)linkHelper.getModel()).getSource() != ((PFLink)o).getTarget()) continue;
            LinkHelper validPrevLink = null;
            if (!this.mapLinkHelper.containsKey(((PFLink)o).getId())) {
                validPrevLink = new LinkHelper((PFLink)o);
                this.mapLinkHelper.put(((PFLink)o).getId(), validPrevLink);
            } else {
                validPrevLink = (LinkHelper)this.mapLinkHelper.get(((PFLink)o).getId());
            }
            linkHelper.addPreviousLink(validPrevLink);
        }
    }

    private FacesConfig10Factory getFacesConfigFactory() {
        if (this.facesConfigFactory == null) {
            this.facesConfigFactory = FacesConfig10Factory.eINSTANCE;
        }
        return this.facesConfigFactory;
    }

    private NavigationRuleType getNavigationRule(String fromViewIdPath, List navigationRulesInPageflow) {
        NavigationRuleType navigationRule = null;
        FacesConfig10Factory factory = this.getFacesConfigFactory();
        FromViewIdType fromViewId = factory.createFromViewIdType();
        fromViewId.setValue(fromViewIdPath);
        boolean bFound = false;
        Iterator iter = navigationRulesInPageflow.iterator();
        while (iter.hasNext() && !bFound) {
            NavigationRuleType rule = (NavigationRuleType)iter.next();
            if (!this.hasSameFromViewID(fromViewId, rule.getFromViewId())) continue;
            navigationRule = rule;
            bFound = true;
        }
        if (!bFound) {
            navigationRule = factory.createNavigationRuleType();
            FromViewIdType fromViewid = factory.createFromViewIdType();
            fromViewid.setValue(fromViewIdPath);
            navigationRule.setFromViewId(fromViewid);
            navigationRulesInPageflow.add(navigationRule);
        }
        return navigationRule;
    }

    private void addPageToPageNavigationRule(LinkHelper linkHelper, List navigationRulesInPageflow) {
        FacesConfig10Factory factory = this.getFacesConfigFactory();
        PFLink pfLink = (PFLink)linkHelper.getModel();
        PFPage pageSource = (PFPage)pfLink.getSource();
        PFPage pageTarget = (PFPage)pfLink.getTarget();
        NavigationRuleType navigationRule = this.getNavigationRule(pageSource.getPath(), navigationRulesInPageflow);
        if (pageSource.getComment() != null) {
            DescriptionType description = factory.createDescriptionType();
            description.setValue(pageSource.getComment());
            navigationRule.getDescription().clear();
            navigationRule.getDescription().add((Object)description);
        }
        if (pageSource.getLargeicon() != null || pageSource.getSmallicon() != null) {
            IconType icon = factory.createIconType();
            if (pageSource.getLargeicon() != null) {
                LargeIconType largeicon = factory.createLargeIconType();
                largeicon.setValue(pageSource.getLargeicon());
                icon.setLargeIcon(largeicon);
            }
            if (pageSource.getSmallicon() != null) {
                SmallIconType smallicon = factory.createSmallIconType();
                smallicon.setValue(pageSource.getSmallicon());
                icon.setSmallIcon(smallicon);
            }
            navigationRule.getIcon().clear();
            navigationRule.getIcon().add((Object)icon);
        }
        if (pageSource.getName() != null) {
            DisplayNameType displayName = factory.createDisplayNameType();
            displayName.setValue(pageSource.getName());
            navigationRule.getDisplayName().clear();
            navigationRule.getDisplayName().add((Object)displayName);
        }
        NavigationCaseType navigationCase = factory.createNavigationCaseType();
        if (pfLink.getOutcome() != null) {
            FromOutcomeType fromOutcome = factory.createFromOutcomeType();
            fromOutcome.setValue(pfLink.getOutcome());
            navigationCase.setFromOutcome(fromOutcome);
        }
        ToViewIdType toViewid = factory.createToViewIdType();
        toViewid.setValue(pageTarget.getPath());
        navigationCase.setToViewId(toViewid);
        if (pageTarget.getLargeicon() != null || pageTarget.getSmallicon() != null) {
            IconType icon = factory.createIconType();
            if (pageTarget.getLargeicon() != null) {
                LargeIconType largeicon = factory.createLargeIconType();
                largeicon.setValue(pageTarget.getLargeicon());
                icon.setLargeIcon(largeicon);
            }
            if (pageTarget.getSmallicon() != null) {
                SmallIconType smallicon = factory.createSmallIconType();
                smallicon.setValue(pageTarget.getSmallicon());
                icon.setSmallIcon(smallicon);
            }
            navigationCase.getIcon().add((Object)icon);
        }
        if (pageTarget.getComment() != null) {
            DescriptionType description = factory.createDescriptionType();
            description.setValue(pageTarget.getComment());
            navigationCase.getDescription().add((Object)description);
        }
        if (pageTarget.getName() != null) {
            DisplayNameType displayName = factory.createDisplayNameType();
            displayName.setValue(pageTarget.getName());
            navigationCase.getDisplayName().add((Object)displayName);
        }
        if (pfLink.isRedirect()) {
            RedirectType redirect = factory.createRedirectType();
            navigationCase.setRedirect(redirect);
        }
        navigationRule.getNavigationCase().add((Object)navigationCase);
        linkHelper.setVisit(true);
        LinkNavigationRule linkRule = new LinkNavigationRule();
        linkRule.setNavigationRule(navigationRule, navigationCase);
        linkRule.setLinks(pfLink, null);
        this.mapLinkNavigationRule.put(navigationCase, linkRule);
    }

    private void addPageToActionNavigationRule(LinkHelper linkHelper, List navigationRulesInPageflow) {
        if (!linkHelper.isVisited() && !linkHelper.isVisited()) {
            List subsequentLinks = linkHelper.getSubsequentLinks();
            if (subsequentLinks != null) {
                Iterator iterSub = subsequentLinks.iterator();
                while (iterSub.hasNext()) {
                    LinkHelper subLink = (LinkHelper)iterSub.next();
                    if (subLink.isVisited()) continue;
                    this.addNewPageActionPageNavigationRule((PFLink)linkHelper.getModel(), (PFLink)subLink.getModel(), navigationRulesInPageflow);
                    subLink.setVisit(true);
                }
            }
            linkHelper.setVisit(true);
        }
    }

    private void addActionToPageNavigationRule(LinkHelper linkHelper, List navigationRulesInPageflow) {
        if (!linkHelper.isVisited()) {
            List prevLinks = linkHelper.getPreviousLink();
            if (prevLinks != null) {
                Iterator iterSub = prevLinks.iterator();
                while (iterSub.hasNext()) {
                    LinkHelper prevLink = (LinkHelper)iterSub.next();
                    this.addNewPageActionPageNavigationRule((PFLink)prevLink.getModel(), (PFLink)linkHelper.getModel(), navigationRulesInPageflow);
                }
            } else {
                this.addNewActionPageNavigationRule((PFLink)linkHelper.getModel(), navigationRulesInPageflow);
            }
            linkHelper.setVisit(true);
        }
    }

    private void addNewActionPageNavigationRule(PFLink pfLink, List navigationRulesInPageflow) {
        FacesConfig10Factory factory = this.getFacesConfigFactory();
        PFAction action = (PFAction)pfLink.getSource();
        PFPage pageTarget = (PFPage)pfLink.getTarget();
        NavigationRuleType navigationRule = this.getNavigationRule("*", navigationRulesInPageflow);
        NavigationCaseType navigationCase = factory.createNavigationCaseType();
        if (action.getAction() != null) {
            FromActionType fromAction = factory.createFromActionType();
            fromAction.setValue(action.getAction());
            navigationCase.setFromAction(fromAction);
        }
        if (pfLink.getOutcome() != null) {
            FromOutcomeType fromOutcome = factory.createFromOutcomeType();
            fromOutcome.setValue(pfLink.getOutcome());
            navigationCase.setFromOutcome(fromOutcome);
        }
        ToViewIdType toViewid = factory.createToViewIdType();
        toViewid.setValue(pageTarget.getPath());
        navigationCase.setToViewId(toViewid);
        if (pageTarget.getLargeicon() != null || pageTarget.getSmallicon() != null) {
            IconType icon = factory.createIconType();
            if (pageTarget.getLargeicon() != null) {
                LargeIconType largeicon = factory.createLargeIconType();
                largeicon.setValue(pageTarget.getLargeicon());
                icon.setLargeIcon(largeicon);
            }
            if (pageTarget.getSmallicon() != null) {
                SmallIconType smallicon = factory.createSmallIconType();
                smallicon.setValue(pageTarget.getSmallicon());
                icon.setSmallIcon(smallicon);
            }
            navigationCase.getIcon().add((Object)icon);
        }
        if (pageTarget.getComment() != null) {
            DescriptionType description = factory.createDescriptionType();
            description.setValue(pageTarget.getComment());
            navigationCase.getDescription().add((Object)description);
        }
        if (pageTarget.getName() != null) {
            DisplayNameType displayName = factory.createDisplayNameType();
            displayName.setValue(pageTarget.getName());
            navigationCase.getDisplayName().add((Object)displayName);
        }
        if (pfLink.isRedirect()) {
            RedirectType redirect = factory.createRedirectType();
            navigationCase.setRedirect(redirect);
        }
        navigationRule.getNavigationCase().add((Object)navigationCase);
        LinkNavigationRule linkRule = new LinkNavigationRule();
        linkRule.setNavigationRule(navigationRule, navigationCase);
        linkRule.setLinks(pfLink, null);
        this.mapLinkNavigationRule.put(navigationCase, linkRule);
    }

    private void addNewPageActionPageNavigationRule(PFLink pfLinkPrev, PFLink pfLinkNext, List navigationRulesInPageflow) {
        FacesConfig10Factory factory = this.getFacesConfigFactory();
        PFPage pageSource = (PFPage)pfLinkPrev.getSource();
        PFAction action = (PFAction)pfLinkPrev.getTarget();
        PFPage pageTarget = (PFPage)pfLinkNext.getTarget();
        NavigationRuleType navigationRule = this.getNavigationRule(pageSource.getPath(), navigationRulesInPageflow);
        if (pageSource.getComment() != null) {
            DescriptionType description = factory.createDescriptionType();
            description.setValue(pageSource.getComment());
            navigationRule.getDescription().clear();
            navigationRule.getDescription().add((Object)description);
        }
        if (pageSource.getLargeicon() != null || pageSource.getSmallicon() != null) {
            IconType icon = factory.createIconType();
            if (pageSource.getLargeicon() != null) {
                LargeIconType largeicon = factory.createLargeIconType();
                largeicon.setValue(pageSource.getLargeicon());
                icon.setLargeIcon(largeicon);
            }
            if (pageSource.getSmallicon() != null) {
                SmallIconType smallicon = factory.createSmallIconType();
                smallicon.setValue(pageSource.getSmallicon());
                icon.setSmallIcon(smallicon);
            }
            navigationRule.getIcon().clear();
            navigationRule.getIcon().add((Object)icon);
        }
        if (pageSource.getName() != null) {
            DisplayNameType displayName = factory.createDisplayNameType();
            displayName.setValue(pageSource.getName());
            navigationRule.getDisplayName().clear();
            navigationRule.getDisplayName().add((Object)displayName);
        }
        NavigationCaseType navigationCase = factory.createNavigationCaseType();
        if (action.getAction() != null) {
            FromActionType fromAction = factory.createFromActionType();
            fromAction.setValue(action.getAction());
            navigationCase.setFromAction(fromAction);
        }
        if (pfLinkNext.getOutcome() != null) {
            FromOutcomeType fromOutcome = factory.createFromOutcomeType();
            fromOutcome.setValue(pfLinkNext.getOutcome());
            navigationCase.setFromOutcome(fromOutcome);
        }
        ToViewIdType toViewid = factory.createToViewIdType();
        toViewid.setValue(pageTarget.getPath());
        navigationCase.setToViewId(toViewid);
        if (pageTarget.getLargeicon() != null || pageTarget.getSmallicon() != null) {
            IconType icon = factory.createIconType();
            if (pageTarget.getLargeicon() != null) {
                LargeIconType largeicon = factory.createLargeIconType();
                largeicon.setValue(pageTarget.getLargeicon());
                icon.setLargeIcon(largeicon);
            }
            if (pageTarget.getSmallicon() != null) {
                SmallIconType smallicon = factory.createSmallIconType();
                smallicon.setValue(pageTarget.getSmallicon());
                icon.setSmallIcon(smallicon);
            }
            navigationCase.getIcon().add((Object)icon);
        }
        if (pageTarget.getName() != null) {
            DisplayNameType displayName = factory.createDisplayNameType();
            displayName.setValue(pageTarget.getName());
            navigationCase.getDisplayName().add((Object)displayName);
        }
        if (pageTarget.getComment() != null) {
            DescriptionType description = factory.createDescriptionType();
            description.setValue(pageTarget.getComment());
            navigationCase.getDescription().add((Object)description);
        }
        if (pfLinkNext.isRedirect()) {
            RedirectType redirect = factory.createRedirectType();
            navigationCase.setRedirect(redirect);
        }
        navigationRule.getNavigationCase().add((Object)navigationCase);
        LinkNavigationRule linkRule = new LinkNavigationRule();
        linkRule.setNavigationRule(navigationRule, navigationCase);
        linkRule.setLinks(pfLinkPrev, pfLinkNext);
        this.mapLinkNavigationRule.put(navigationCase, linkRule);
    }

    private boolean updateNavigationRulesInPageflow(List navigationRulesInFacesconfig, List navigationRulesInPageflow) {
        if (navigationRulesInFacesconfig == null || navigationRulesInFacesconfig.isEmpty()) {
            Iterator iterLink = this.pageflow.getLinks().iterator();
            while (iterLink.hasNext()) {
                PFLink link = (PFLink)iterLink.next();
                link.getSource().getOutlinks().remove((Object)link);
                link.getTarget().getInlinks().remove((Object)link);
            }
            this.pageflow.getLinks().clear();
            return false;
        }
        boolean bAddNewRule = false;
        ArrayList<NavigationRule> newNavigationRules = null;
        if (navigationRulesInPageflow == null || navigationRulesInPageflow.isEmpty()) {
            newNavigationRules = new ArrayList<NavigationRule>();
            newNavigationRules.addAll(navigationRulesInFacesconfig);
        } else if (navigationRulesInFacesconfig != null && !navigationRulesInFacesconfig.isEmpty()) {
            this.mapUpdatedNavigationCase = new HashMap();
            Iterator iterRulesFC = navigationRulesInFacesconfig.iterator();
            while (iterRulesFC.hasNext()) {
                NavigationRule navigationRuleFC = (NavigationRule)iterRulesFC.next();
                List navigationRuleFCList = navigationRuleFC.getNavigationCaseList();
                Iterator iterCasesFC = navigationRuleFCList.iterator();
                block2: while (iterCasesFC.hasNext()) {
                    NavigationCase navigationCaseFC = (NavigationCase)iterCasesFC.next();
                    Iterator iterRulesPF = navigationRulesInPageflow.iterator();
                    while (iterRulesPF.hasNext()) {
                        NavigationRuleType navigationRulePF = (NavigationRuleType)iterRulesPF.next();
                        if (!this.updatePageflowWithSameCondition(navigationRuleFC, navigationCaseFC, navigationRulePF)) continue;
                        iterCasesFC.remove();
                        continue block2;
                    }
                }
                if (navigationRuleFCList.isEmpty()) continue;
                if (newNavigationRules == null) {
                    newNavigationRules = new ArrayList();
                }
                newNavigationRules.add(navigationRuleFC);
            }
            Iterator iterRulesPF = navigationRulesInPageflow.iterator();
            while (iterRulesPF.hasNext()) {
                NavigationRuleType navigationRulePF = (NavigationRuleType)iterRulesPF.next();
                Iterator iterCasePF = navigationRulePF.getNavigationCase().iterator();
                while (iterCasePF.hasNext()) {
                    NavigationCaseType navigationCasePF = (NavigationCaseType)iterCasePF.next();
                    if (this.mapUpdatedNavigationCase.containsKey(navigationCasePF)) continue;
                    this.removeNavigationCaseFromPageflow(navigationCasePF);
                }
            }
        }
        if (newNavigationRules != null && !newNavigationRules.isEmpty()) {
            bAddNewRule = true;
            this.addNewNavigationRulesToPageflow(newNavigationRules);
        }
        return bAddNewRule;
    }

    private void addNewNavigationRulesToPageflow(List newNavigationRules) {
        if (newNavigationRules != null && !newNavigationRules.isEmpty()) {
            Iterator iterRule = newNavigationRules.iterator();
            while (iterRule.hasNext()) {
                NavigationRule navigationRule = (NavigationRule)iterRule.next();
                String fromViewID = null;
                fromViewID = navigationRule.getFromViewId() == null ? "*" : navigationRule.getFromViewId();
                PFPage sourcePage = (PFPage)this.findPFPage(fromViewID);
                if (sourcePage == null) {
                    sourcePage = this.createPFPage(fromViewID);
                }
                this.updatePageflowSourcePage(sourcePage, navigationRule);
                Iterator iterCase = navigationRule.getNavigationCaseList().iterator();
                while (iterCase.hasNext()) {
                    NavigationCase navigationCase = (NavigationCase)iterCase.next();
                    String fromAction = navigationCase.getFromAction();
                    PFAction action = null;
                    if (fromAction != null && fromAction.length() > 0 && (action = (PFAction)this.findPFAction(fromAction)) == null) {
                        action = this.createPFAction(fromAction);
                    }
                    PFPage targetPage = null;
                    if (navigationCase.getToViewId() != null) {
                        String toViewID = navigationCase.getToViewId();
                        targetPage = (PFPage)this.findPFPage(toViewID);
                        if (targetPage == null) {
                            targetPage = this.createPFPage(toViewID);
                        }
                        this.updatePageflowTargetPage(targetPage, navigationCase);
                    }
                    if (targetPage == null) {
                        return;
                    }
                    if (action != null) {
                        PFLink firstLink = this.findPFLink(sourcePage, action);
                        if (firstLink == null) {
                            firstLink = this.createPFLink(null);
                            firstLink.setSource(sourcePage);
                            firstLink.setTarget(action);
                        }
                        String secondFromOutcome = null;
                        if (navigationCase.getFromOutcome() != null) {
                            secondFromOutcome = navigationCase.getFromOutcome();
                        }
                        PFLink secondLink = this.createPFLink(secondFromOutcome);
                        secondLink.setSource(action);
                        secondLink.setTarget(targetPage);
                        continue;
                    }
                    PFLink link = null;
                    String fromOutcome = null;
                    if (navigationCase.getFromOutcome() != null) {
                        fromOutcome = navigationCase.getFromOutcome();
                    }
                    link = this.createPFLink(fromOutcome);
                    link.setSource(sourcePage);
                    link.setTarget(targetPage);
                }
            }
        }
    }

    private PageflowFactory getPageflowFactory() {
        if (this.pageflowFactory == null) {
            this.pageflowFactory = PageflowModelManager.getFactory();
        }
        return this.pageflowFactory;
    }

    private PFPage createPFPage(String fromViewID) {
        PFPage page = this.getPageflowFactory().createPFPage();
        if (fromViewID != null && fromViewID.length() > 0) {
            page.setPath(fromViewID.trim());
            page.setName(WebrootUtil.getPageNameFromWebPath((String)fromViewID.trim()));
        }
        this.pageflow.getNodes().add((Object)page);
        return page;
    }

    private PFAction createPFAction(String fromAction) {
        PFAction action = null;
        action = this.getPageflowFactory().createPFAction();
        if (fromAction != null && fromAction.length() > 0) {
            action.setAction(fromAction.trim());
            action.setName(fromAction.trim());
        }
        this.pageflow.getNodes().add((Object)action);
        return action;
    }

    private PFLink createPFLink(String fromOutcome) {
        PFLink link = null;
        link = this.getPageflowFactory().createPFLink();
        if (fromOutcome != null && fromOutcome.length() > 0) {
            link.setOutcome(fromOutcome.trim());
        }
        this.pageflow.getLinks().add((Object)link);
        return link;
    }

    private PFLink findPFLink(PageflowNode source, PageflowNode target) {
        PFLink linkFind = null;
        Iterator iter = this.pageflow.getLinks().iterator();
        while (iter.hasNext()) {
            PFLink link = (PFLink)iter.next();
            if (link.getSource() != source || link.getTarget() != target) continue;
            linkFind = link;
            break;
        }
        return linkFind;
    }

    private PageflowNode findPFPage(String fromViewID) {
        PageflowNode node = null;
        Iterator iter = this.pageflow.getNodes().iterator();
        while (iter.hasNext()) {
            node = (PageflowNode)iter.next();
            if (!(node instanceof PFPage) || ((PFPage)node).getPath() == null || !((PFPage)node).getPath().trim().equalsIgnoreCase(fromViewID.trim())) continue;
            return node;
        }
        return null;
    }

    private PageflowNode findPFAction(String fromAction) {
        PageflowNode node = null;
        Iterator iter = this.pageflow.getNodes().iterator();
        while (iter.hasNext()) {
            node = (PageflowNode)iter.next();
            if (!(node instanceof PFAction) || ((PFAction)node).getAction() == null || !((PFAction)node).getAction().trim().equalsIgnoreCase(fromAction.trim())) continue;
            return node;
        }
        return null;
    }

    public static void updatePageflowModelInfo(Pageflow newPageflow, Pageflow oldPageflow) {
        if (newPageflow == null || oldPageflow == null) {
            return;
        }
        newPageflow.setName(oldPageflow.getName());
        newPageflow.setComment(oldPageflow.getComment());
        newPageflow.setConfigfile(oldPageflow.getConfigfile());
        PageflowTransform.updatePageflowNode(newPageflow, oldPageflow);
    }

    private static void updatePageflowNode(Pageflow newPageflow, Pageflow oldPageflow) {
        if (oldPageflow.getNodes().size() > 0) {
            Iterator iter = newPageflow.getNodes().iterator();
            while (iter.hasNext()) {
                PageflowNode newNode = (PageflowNode)iter.next();
                PageflowTransform.updatePageflowNode(newNode, oldPageflow);
            }
        }
    }

    private static void updatePageflowNode(PageflowNode newNode, Pageflow oldPageflow) {
        Iterator iter = oldPageflow.getNodes().iterator();
        while (iter.hasNext()) {
            PageflowNode oldNode = (PageflowNode)iter.next();
            if (!(oldNode instanceof PFAction) || !(newNode instanceof PFAction) || ((PFAction)oldNode).getAction() == null || ((PFAction)newNode).getAction() == null || !((PFAction)oldNode).getAction().trim().equals(((PFAction)newNode).getAction().trim())) continue;
            ((PFAction)newNode).setName(((PFAction)oldNode).getName());
            ((PFAction)newNode).setComment(((PFAction)oldNode).getComment());
        }
    }

    private void removeNavigationCaseFromPageflow(NavigationCaseType navigationCasePF) {
        LinkNavigationRule linkRule = (LinkNavigationRule)this.mapLinkNavigationRule.get(navigationCasePF);
        PFLink firstLink = linkRule.getFirstLink();
        PFLink secondLink = linkRule.getSecondLink();
        if (firstLink != null && secondLink != null) {
            firstLink.getSource().getOutlinks().remove((Object)firstLink);
            firstLink.getTarget().getInlinks().remove((Object)firstLink);
            secondLink.getSource().getOutlinks().remove((Object)secondLink);
            secondLink.getTarget().getInlinks().remove((Object)secondLink);
            this.pageflow.getLinks().remove((Object)firstLink);
            this.pageflow.getLinks().remove((Object)secondLink);
        } else if (firstLink != null && secondLink == null) {
            firstLink.getSource().getOutlinks().remove((Object)firstLink);
            firstLink.getTarget().getInlinks().remove((Object)firstLink);
            this.pageflow.getLinks().remove((Object)firstLink);
        }
    }
}

