/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBeanScopeTreeItem;

public class ManagedBeanContentProvider
implements ITreeContentProvider {
    private List listScopeItems;

    public Object[] getChildren(Object parent) {
        if (this.isRootNode(parent)) {
            return this.getScopeItems().toArray();
        }
        if (this.isScopeElement(parent)) {
            ((ManagedBeanScopeTreeItem)parent).setChildren(this.getScopeBeans((ManagedBeanScopeTreeItem)parent));
            return ((ManagedBeanScopeTreeItem)parent).getChildren();
        }
        return new Object[0];
    }

    private boolean isRootNode(Object node) {
        return node instanceof IDOMNode && ((IDOMNode)node).getNodeName().equalsIgnoreCase("faces-config");
    }

    private boolean isScopeElement(Object object) {
        return object != null && object instanceof ManagedBeanScopeTreeItem;
    }

    private boolean isBeanNode(Object node) {
        return node instanceof IDOMNode && ((IDOMNode)node).getNodeName().equalsIgnoreCase("managed-bean");
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof ManagedBeanScopeTreeItem) {
            return ((ManagedBeanScopeTreeItem)element).getParent();
        }
        if (element instanceof IDOMNode) {
            int i = 0;
            while (i < ManagedBean.scopeItems.length) {
                ManagedBean bean = new ManagedBean((IDOMNode)element);
                if (bean.isValid() && bean.getManagedBeanScope().equalsIgnoreCase(ManagedBean.scopeItems[i])) {
                    return this.getScopeItem(ManagedBean.scopeItems[i]);
                }
                ++i;
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.isRootNode(element)) {
            return true;
        }
        if (element instanceof ManagedBeanScopeTreeItem) {
            return ((ManagedBeanScopeTreeItem)element).hasChildren();
        }
        return false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            this.initialize(newInput);
        }
    }

    private void initialize(Object newInput) {
        if (this.isRootNode(newInput)) {
            this.createScopeItems(newInput);
        }
    }

    private List getScopeBeans(Object parent) {
        ArrayList<IDOMNode> scopeBeans = new ArrayList<IDOMNode>();
        ManagedBeanScopeTreeItem scopeItem = (ManagedBeanScopeTreeItem)parent;
        FacesConfig facesConfig = new FacesConfig(scopeItem.getParent());
        Iterator iter = facesConfig.getManagedBeanList().iterator();
        while (iter.hasNext()) {
            ManagedBean bean = (ManagedBean)iter.next();
            if (!bean.isValid() || !bean.getManagedBeanScope().equalsIgnoreCase(scopeItem.getType())) continue;
            scopeBeans.add(bean.getNode());
        }
        return scopeBeans;
    }

    private List getScopeItems() {
        return this.listScopeItems;
    }

    private void createScopeItems(Object parent) {
        this.listScopeItems = new ArrayList();
        int i = 0;
        while (i < ManagedBean.scopeItems.length) {
            ManagedBeanScopeTreeItem scopeTreeItem = new ManagedBeanScopeTreeItem(ManagedBean.scopeItems[i], (IDOMNode)parent);
            this.listScopeItems.add(scopeTreeItem);
            ++i;
        }
    }

    private Object getScopeItem(String scope) {
        ManagedBeanScopeTreeItem scopeItem = null;
        Iterator iter = this.getScopeItems().iterator();
        while (iter.hasNext()) {
            ManagedBeanScopeTreeItem item = (ManagedBeanScopeTreeItem)iter.next();
            if (!item.getType().equalsIgnoreCase(scope)) continue;
            scopeItem = item;
            break;
        }
        return scopeItem;
    }
}

