/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.IconResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.CommonPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.ISSESectionPart;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.ISSESection;

public abstract class AbstractSSESection
extends SectionPart
implements ISSESection {
    private FormToolkit toolkit;
    private ImageHyperlink helpImage;
    private String helpContextId = null;
    private String helpTooltip = null;
    private Object input = null;
    private ISSESectionPart sectionPart = null;
    private static final Image HELP_IMAGE = CommonPlugin.getDefault().getImage(IconResources.getString("Common.help"));

    public AbstractSSESection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, int style, String helpContextId, String helpTooltip) {
        super(parent, toolkit, style);
        super.initialize(managedForm);
        this.toolkit = toolkit;
        this.helpContextId = helpContextId;
        this.helpTooltip = helpTooltip;
    }

    public AbstractSSESection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, String helpContextId, String helpTooltip) {
        super(parent, toolkit, 450);
        super.initialize(managedForm);
        this.toolkit = toolkit;
        this.helpContextId = helpContextId;
        this.helpTooltip = helpTooltip;
    }

    public AbstractSSESection(Composite parent, IManagedForm managedForm, FormToolkit toolkit) {
        this(parent, managedForm, toolkit, null, null);
    }

    private void createTextClientWithHelp() {
        this.helpImage = new ImageHyperlink((Composite)this.getSection(), 0);
        this.toolkit.adapt((Control)this.helpImage, true, true);
        this.helpImage.setImage(HELP_IMAGE);
        this.helpImage.setBackground(this.getSection().getTitleBarGradientBackground());
        if (this.helpTooltip != null) {
            this.helpImage.setToolTipText(this.helpTooltip);
        }
        this.helpImage.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IContext context = HelpSystem.getContext((String)AbstractSSESection.this.helpContextId);
                if (context != null) {
                    IHelpResource[] topics = context.getRelatedTopics();
                    if (topics != null && topics.length == 1) {
                        EditorPlugin.getDefault().getWorkbench().getHelpSystem().displayHelpResource(topics[0].getHref());
                    } else {
                        EditorPlugin.getDefault().getWorkbench().getHelpSystem().displayHelp(AbstractSSESection.this.helpContextId);
                    }
                }
            }
        });
        this.getSection().setTextClient((Control)this.helpImage);
    }

    public void initialize() {
        if (this.helpContextId != null) {
            this.createTextClientWithHelp();
        }
        this.getSection().setLayout((Layout)new GridLayout());
        Composite clientContainer = this.toolkit.createComposite((Composite)this.getSection());
        GridData gd = new GridData(1808);
        clientContainer.setLayoutData((Object)gd);
        this.createContents(clientContainer, this.toolkit);
        this.getSection().setClient((Control)clientContainer);
    }

    protected abstract void createContents(Composite var1, FormToolkit var2);

    public void setText(String text) {
        this.getSection().setText(text);
    }

    public void setDescription(String text) {
        this.getSection().setDescription(text);
    }

    public void setLayoutData(Object layoutData) {
        this.getSection().setLayoutData(layoutData);
    }

    public void setExpanded(boolean expanded) {
        this.getSection().setExpanded(expanded);
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object newInput) {
        if (newInput != null) {
            this.input = newInput;
            this.refreshAll();
        }
    }

    public ISSESectionPart getSectionPart() {
        return this.sectionPart;
    }

    public void setSectionPart(ISSESectionPart part) {
        this.sectionPart = part;
    }
}

