/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.FacesConfigEditor;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.ChangeSingleNodeValueCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.SetConverterForClassCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.SetConverterIDCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.ClassButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldApplyListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldChangeListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.pages.ComponentsPage;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.AbstractSSESection;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;

public class ConvertersGeneralSection
extends AbstractSSESection {
    private static EditorResources resource = EditorResources.getInstance();
    private IFormPage formPage;
    private StringDialogField displayNameField;
    private StringDialogField descriptionField;
    private StringDialogField converterIDField;
    private ClassButtonDialogField converterForClassField;
    private ClassButtonDialogField converterClassField;
    private IProject currentProject;

    public ConvertersGeneralSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, int style, String helpContextId, String helpTooltip) {
        super(parent, managedForm, toolkit, style, helpContextId, helpTooltip);
    }

    public ConvertersGeneralSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, String helpContextId, String helpTooltip) {
        super(parent, managedForm, toolkit, helpContextId, helpTooltip);
    }

    public ConvertersGeneralSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit) {
        super(parent, managedForm, toolkit);
    }

    public ConvertersGeneralSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, IFormPage editor) {
        this(parent, managedForm, toolkit, resource.getString("ComponentsPage.ConvertersSection.General.HelpContextID"), resource.getString("ComponentsPage.ConvertersSection.General.HelpToolTip"));
        this.formPage = editor;
        this.setText(resource.getString("ComponentsPage.ConvertersSection.General.Name"));
        this.setDescription(resource.getString("ComponentsPage.ConvertersSection.General.Description"));
    }

    protected void createContents(Composite container, FormToolkit toolkit) {
        int numberOfColumns = 4;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        container.setLayout((Layout)layout);
        GridData td = new GridData(768);
        container.setLayoutData((Object)td);
        IDialogFieldChangeListener dialogFieldChangeListener = new IDialogFieldChangeListener(){

            public void dialogFieldChanged(DialogField field) {
                ((FacesConfigEditor)((ComponentsPage)ConvertersGeneralSection.this.formPage).getEditor()).setDirty(true);
            }
        };
        toolkit.paintBordersFor(container);
        this.displayNameField = new StringDialogField();
        this.displayNameField.setLabelText(resource.getString("ComponentsPage.ConvertersSection.General.Label.DisplayName"));
        this.displayNameField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.displayNameField.setDialogFieldChangeListener(dialogFieldChangeListener);
        this.displayNameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newNameValue = ((StringDialogField)field).getText();
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand(resource.getString("ComponentsPage.ConvertersSection.General.SetDisplayName"), ConvertersGeneralSection.this.getSectionPart(), "display-name", newNameValue);
                changeCmd.execute();
            }
        });
        this.descriptionField = new StringDialogField(2);
        this.descriptionField.setLabelText(resource.getString("ComponentsPage.ConvertersSection.General.Label.Description"));
        this.descriptionField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.descriptionField.setDialogFieldChangeListener(dialogFieldChangeListener);
        this.descriptionField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newDescription = ((StringDialogField)field).getText();
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand(resource.getString("ComponentsPage.ConvertersSection.General.SetDescription"), ConvertersGeneralSection.this.getSectionPart(), "description", newDescription);
                changeCmd.execute();
            }
        });
        this.converterIDField = new StringDialogField();
        this.converterIDField.setLabelText(resource.getString("ComponentsPage.ConvertersSection.General.Label.ConverterID"));
        this.converterIDField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.converterIDField.setDialogFieldChangeListener(dialogFieldChangeListener);
        this.converterIDField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newConverterID = ((StringDialogField)field).getText();
                SetConverterIDCommand changeCmd = new SetConverterIDCommand(resource.getString("ComponentsPage.ConvertersSection.General.SetConverterID"), ConvertersGeneralSection.this.getSectionPart(), newConverterID);
                changeCmd.execute();
            }
        });
        this.converterForClassField = new ClassButtonDialogField(this.getProject());
        this.converterForClassField.setLabelText(resource.getString("ComponentsPage.ConvertersSection.General.Label.ConverterForClass"));
        this.converterForClassField.doFillIntoGrid(toolkit, container, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.converterForClassField.getTextControl(toolkit, container));
        this.converterForClassField.getTextControl(toolkit, container).setEditable(true);
        this.converterForClassField.setDialogFieldChangeListener(dialogFieldChangeListener);
        this.converterForClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newConverterForClass = ((StringDialogField)field).getText();
                SetConverterForClassCommand changeCmd = new SetConverterForClassCommand(resource.getString("ComponentsPage.ConvertersSection.General.SetConverterForClass"), ConvertersGeneralSection.this.getSectionPart(), newConverterForClass);
                changeCmd.execute();
            }
        });
        this.converterClassField = new ClassButtonDialogField(this.getProject());
        this.converterClassField.setLabelText(resource.getString("ComponentsPage.ConvertersSection.General.Label.ConverterClass"));
        this.converterClassField.doFillIntoGrid(toolkit, container, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.converterClassField.getTextControl(toolkit, container));
        this.converterClassField.getTextControl(toolkit, container).setEditable(true);
        this.converterClassField.setDialogFieldChangeListener(dialogFieldChangeListener);
        this.converterClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newConverterClass = ((StringDialogField)field).getText();
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand(resource.getString("ComponentsPage.ConvertersSection.General.SetConverterClass"), ConvertersGeneralSection.this.getSectionPart(), "converter-class", newConverterClass);
                changeCmd.execute();
            }
        });
        this.converterClassField.setInterface("javax.faces.convert.Converter");
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)container, resource.getString("ComponentsPage.ConvertersSection.General.HelpContextID"));
    }

    private IProject getProject() {
        if (this.currentProject == null && this.getInput() instanceof IDOMNode) {
            this.currentProject = StructuredModelUtil.getProjectFor((IDOMNode)this.getInput());
        }
        return this.currentProject;
    }

    public void clearAll() {
        this.displayNameField.setTextWithoutUpdate("");
        this.descriptionField.setTextWithoutUpdate("");
        this.converterIDField.setTextWithoutUpdate("");
        this.converterClassField.setTextWithoutUpdate("");
        this.converterForClassField.setTextWithoutUpdate("");
    }

    public void refreshAll() {
        if (this.getInput() instanceof IDOMNode) {
            this.clearAll();
            NodeWrapUtil converterWrap = new NodeWrapUtil((IDOMNode)this.getInput());
            this.displayNameField.setTextWithoutUpdate(converterWrap.getChildNodeValue("display-name"));
            this.descriptionField.setTextWithoutUpdate(converterWrap.getChildNodeValue("description"));
            this.converterIDField.setTextWithoutUpdate(converterWrap.getChildNodeValue("converter-id"));
            this.converterClassField.setTextWithoutUpdate(converterWrap.getChildNodeValue("converter-class"));
            this.converterForClassField.setTextWithoutUpdate(converterWrap.getChildNodeValue("converter-for-class"));
        }
    }

    public IWorkbenchPartSite getSite() {
        return this.formPage.getSite();
    }

    public ClassButtonDialogField getConverterForClassField() {
        return this.converterForClassField;
    }

    public ClassButtonDialogField getConverterClassField() {
        return this.converterClassField;
    }

    public StringDialogField getConverterIDField() {
        return this.converterIDField;
    }

    public StringDialogField getDescriptionField() {
        return this.descriptionField;
    }

    public StringDialogField getDisplayNameField() {
        return this.displayNameField;
    }

    public void setInput(Object newInput) {
        super.setInput(newInput);
        this.converterClassField.setProject(this.getProject());
        this.converterForClassField.setProject(this.getProject());
    }
}

