/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.AddLocaleCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfigDocumentWrap;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.providers.LocaleConfigContentLabelProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.ApplicationResources;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.ApplicationSection;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigOrderHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class LocaleConfigSection
extends ApplicationSection
implements ICheckStateListener {
    private static ApplicationResources applicationResource = ApplicationResources.getInstance();
    protected INodeSelectionListener fNodeSelectionListener;

    public LocaleConfigSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, IFormPage editor) {
        super(parent, managedForm, toolkit, editor, "locale-config");
        this.page = editor;
        this.setText(applicationResource.getSectionText("locale-config"));
        this.setDescription(applicationResource.getSectionDescription("locale-config"));
    }

    protected void addButtonSelected(SelectionEvent e) {
        AddLocaleCommand addCommand = new AddLocaleCommand(applicationResource.getAddCommandLabel("locale-config"), this.getSectionPart());
        addCommand.execute();
    }

    protected void createViewer(Composite parent, FormToolkit toolkit) {
        Composite tableContainer = toolkit.createComposite(parent);
        toolkit.paintBordersFor(tableContainer);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        tableContainer.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        tableContainer.setLayout((Layout)layout);
        CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)tableContainer, (int)770);
        gd = new GridData(1808);
        tableViewer.getControl().setLayoutData((Object)gd);
        tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        tableViewer.addCheckStateListener((ICheckStateListener)this);
        tableViewer.setSorter(new ViewerSorter());
        this.setTableViewer((TableViewer)tableViewer);
    }

    protected void setContentLabelProvider() {
        LocaleConfigContentLabelProvider provider = new LocaleConfigContentLabelProvider();
        this.setLabelProvider(provider);
        this.setContentProvider((IContentProvider)provider);
    }

    private void setTableViewerCheckedState() {
        NodeWrapUtil localeConfigWrap;
        IDOMNode defaultLocaleConfig;
        IDOMNode localeConfigNode = this.getLocaleConfigNode();
        if (localeConfigNode != null && (defaultLocaleConfig = (IDOMNode)(localeConfigWrap = new NodeWrapUtil(localeConfigNode)).getChildNode("default-locale")) != null) {
            ((CheckboxTableViewer)this.getTableViewer()).setChecked((Object)defaultLocaleConfig, true);
        }
    }

    public void refreshAll() {
        super.refreshAll();
        this.setTableViewerCheckedState();
    }

    public INodeSelectionListener getNodeSelectionListener() {
        if (this.fNodeSelectionListener == null) {
            this.fNodeSelectionListener = new SSENodeSelectionListener();
        }
        return this.fNodeSelectionListener;
    }

    private IDOMNode getLocaleConfigNode() {
        IDOMDocument document;
        FacesConfigDocumentWrap documentWrap;
        FacesConfig facesConfig;
        IDOMNode localeConfigNode = null;
        if (this.getInput() instanceof IStructuredModel && (facesConfig = (documentWrap = new FacesConfigDocumentWrap((Document)(document = ((IDOMModel)this.getInput()).getDocument()))).getFacesConfig()) != null) {
            IDOMNode facesConfigNode = facesConfig.getNode();
            NodeWrapUtil facesConfigWrap = new NodeWrapUtil(facesConfigNode);
            IDOMNode applicationNode = (IDOMNode)facesConfigWrap.getChildNode("application");
            if (applicationNode == null) {
                return null;
            }
            NodeWrapUtil applicationWrap = new NodeWrapUtil(applicationNode);
            localeConfigNode = (IDOMNode)applicationWrap.getChildNode("locale-config");
            if (localeConfigNode == null) {
                return null;
            }
        }
        return localeConfigNode;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        boolean checked = event.getChecked();
        IDOMNode node = (IDOMNode)event.getElement();
        if (node == null) {
            return;
        }
        IDOMNode localeConfigNode = this.getLocaleConfigNode();
        if (localeConfigNode == null) {
            return;
        }
        if (checked) {
            NodeWrapUtil.removeNode((Node)node);
            this.createDefaultLocalNode(localeConfigNode, node.getFirstChild().getNodeValue());
        } else {
            NodeWrapUtil.removeNode((Node)node);
            this.createSupportedLocalNode(localeConfigNode, node.getFirstChild().getNodeValue());
        }
        this.setTableViewerCheckedState();
    }

    private void createDefaultLocalNode(IDOMNode localeConfigNode, String defaultLocalNodeValue) {
        NodeWrapUtil localeConfigWrap = new NodeWrapUtil(localeConfigNode);
        IDOMNode defaultNode = (IDOMNode)localeConfigWrap.getChildNode("default-locale");
        if (defaultNode != null) {
            NodeWrapUtil.removeNode((Node)defaultNode);
            this.createSupportedLocalNode(localeConfigNode, defaultNode.getFirstChild().getNodeValue());
        }
        localeConfigWrap.createChildNode("default-locale", false, defaultLocalNodeValue, FacesConfigOrderHelper.getInstance());
    }

    private void createSupportedLocalNode(IDOMNode localeConfigNode, String supportedLocalNodeValue) {
        NodeWrapUtil localeConfigWrap = new NodeWrapUtil(localeConfigNode);
        localeConfigWrap.createChildNode("supported-locale", false, supportedLocalNodeValue, FacesConfigOrderHelper.getInstance());
    }

    class SSENodeSelectionListener
    implements INodeSelectionListener {
        SSENodeSelectionListener() {
        }

        public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
        }
    }
}

