/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.actions.OpenPageAction;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.Component;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.Converter;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.Renderkit;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.Validator;
import org.eclipse.wtp.jsf.facesconfig.editor.providers.ComponentsLabelProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.providers.ConvertersLabelProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.providers.RenderKitsLabelProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.providers.ValidatorsLabelProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.AbstractOverviewSection;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigUtil;

public class OverviewComponentsSection
extends AbstractOverviewSection {
    private static EditorResources resource = EditorResources.getInstance();
    private static final int TYPE = 0;
    private static final int NAME = 1;
    private ArrayList componentsList = null;
    private TableViewer tableViewer;

    public OverviewComponentsSection(IManagedForm managedForm, FormToolkit toolkit, FormEditor editor) {
        super(editor, managedForm, toolkit, 194, resource.getString("OverviewPage.ComponentsSection.Help.HelpContextID"), resource.getString("OverviewPage.ComponentsSection.Help.HelpToolTip"));
        this.setText(resource.getString("OverviewPage.ComponentsSection.name"));
        this.setDescription(resource.getString("OverviewPage.ComponentsSection.description"));
    }

    public Composite createClient(Composite container, FormToolkit factory) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        factory.paintBordersFor(container);
        Table table = new Table(container, 66304);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tablelayout = new TableLayout();
        table.setLayout((Layout)tablelayout);
        TableColumn typecol = new TableColumn(table, 16384);
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        typecol.setText(resource.getString("OverviewPage.ComponentsSection.table.typecol"));
        typecol.setResizable(true);
        TableColumn namecol = new TableColumn(table, 16384);
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        namecol.setText(resource.getString("OverviewPage.ComponentsSection.table.namecol"));
        namecol.setResizable(true);
        table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                OpenPageAction action = new OpenPageAction();
                action.setPageName("org.eclipse.wtp.jsf.facesconfig.editor.pages.ComponentsPage");
                action.run();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)container, resource.getString("OverviewPage.ComponentsSection.Help.HelpContextID"));
        return container;
    }

    public void refreshAll() {
        if (this.getInput() == null || !(this.getInput() instanceof IDOMModel)) {
            return;
        }
        FacesConfig fconfig = FacesConfigUtil.getFacesConfig((IStructuredModel)((IDOMModel)this.getInput()));
        if (fconfig != null) {
            String name;
            LabelProvider labelProvider;
            int i;
            List componentList = fconfig.getComponentList();
            List renderkitList = fconfig.getRenderkitList();
            List validatorList = fconfig.getValidatorList();
            List converterList = fconfig.getConverterList();
            int componentCount = componentList.size();
            int renderkitCount = renderkitList.size();
            int validatorCount = validatorList.size();
            int converterCount = converterList.size();
            this.componentsList = new ArrayList(componentCount + renderkitCount + validatorCount + converterCount);
            if (componentCount > 0) {
                i = 0;
                while (i < componentCount) {
                    Component component = (Component)componentList.get(i);
                    ComponentsElement componentElement = new ComponentsElement();
                    componentElement.setType("component");
                    labelProvider = new ComponentsLabelProvider();
                    name = labelProvider.getText(component.getElement().getNode());
                    componentElement.setName(name);
                    this.componentsList.add(componentElement);
                    ++i;
                }
            }
            if (renderkitCount > 0) {
                i = 0;
                while (i < renderkitCount) {
                    Renderkit renderkit = (Renderkit)renderkitList.get(i);
                    ComponentsElement renderkitElement = new ComponentsElement();
                    renderkitElement.setType("render-kit");
                    labelProvider = new RenderKitsLabelProvider();
                    name = labelProvider.getText(renderkit.getElement().getNode());
                    renderkitElement.setName(name);
                    this.componentsList.add(renderkitElement);
                    ++i;
                }
            }
            if (converterCount > 0) {
                i = 0;
                while (i < converterCount) {
                    Converter converter = (Converter)converterList.get(i);
                    ComponentsElement conElement = new ComponentsElement();
                    conElement.setType("converter");
                    labelProvider = new ConvertersLabelProvider();
                    name = labelProvider.getText(converter.getElement().getNode());
                    conElement.setName(name);
                    this.componentsList.add(conElement);
                    ++i;
                }
            }
            if (validatorList != null) {
                i = 0;
                while (i < validatorCount) {
                    Validator validator = (Validator)validatorList.get(i);
                    ComponentsElement valElement = new ComponentsElement();
                    valElement.setType("validator");
                    labelProvider = new ValidatorsLabelProvider();
                    name = labelProvider.getText(validator.getElement().getNode());
                    valElement.setName(name);
                    this.componentsList.add(valElement);
                    ++i;
                }
            }
            this.tableViewer.setInput((Object)this.componentsList);
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return OverviewComponentsSection.this.componentsList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ComponentsElement elem = (ComponentsElement)element;
            switch (columnIndex) {
                case 0: {
                    return elem.getType();
                }
                case 1: {
                    return elem.getName();
                }
            }
            return "";
        }
    }

    class ComponentsElement {
        private String _name;
        private String _type;

        public ComponentsElement(String type, String name) {
            this._name = name;
            this._type = type;
        }

        public ComponentsElement() {
        }

        void setName(String value) {
            this._name = value;
        }

        void setType(String value) {
            this._type = value;
        }

        public String getName() {
            return this._name;
        }

        public String getType() {
            return this._type;
        }

        public String toString() {
            return String.valueOf(this._type) + "\\t" + this._name;
        }
    }
}

