/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.actions.OpenPageAction;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.AbstractOverviewSection;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigUtil;

public class OverviewOthersSection
extends AbstractOverviewSection {
    private static EditorResources resource = EditorResources.getInstance();
    private static final int TYPE = 0;
    private static final int NAME = 1;
    private static final int VALUE = 2;
    private static final int COLUMN_WITH = 100;
    private ArrayList othersList = null;
    private TableViewer tableViewer;

    public OverviewOthersSection(IManagedForm managedForm, FormToolkit toolkit, FormEditor editor) {
        super(editor, managedForm, toolkit, 194, resource.getString("OverviewPage.OthersSection.Help.HelpContextID"), resource.getString("OverviewPage.OthersSection.Help.HelpToolTip"));
        this.setText(resource.getString("OverviewPage.OthersSection.name"));
        this.setDescription(resource.getString("OverviewPage.OthersSection.description"));
    }

    public Composite createClient(Composite container, FormToolkit factory) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        factory.paintBordersFor(container);
        Table table = new Table(container, 66304);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tablelayout = new TableLayout();
        table.setLayout((Layout)tablelayout);
        TableColumn typecol = new TableColumn(table, 0);
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 100, true));
        typecol.setText(resource.getString("OverviewPage.OthersSection.table.typecol"));
        typecol.setResizable(true);
        TableColumn namecol = new TableColumn(table, 0);
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 100, true));
        namecol.setText(resource.getString("OverviewPage.OthersSection.table.namecol"));
        namecol.setResizable(true);
        TableColumn valuecol = new TableColumn(table, 0);
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 100, true));
        valuecol.setText(resource.getString("OverviewPage.OthersSection.table.valuecol"));
        valuecol.setResizable(true);
        table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                OpenPageAction action = new OpenPageAction();
                action.setPageName("org.eclipse.wtp.jsf.facesconfig.editor.pages.OthersPage");
                action.run();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)container, resource.getString("OverviewPage.OthersSection.Help.HelpContextID"));
        return container;
    }

    public void refreshAll() {
        if (this.getInput() == null || !(this.getInput() instanceof IDOMModel)) {
            return;
        }
        FacesConfig fconfig = FacesConfigUtil.getFacesConfig((IStructuredModel)((IDOMModel)this.getInput()));
        if (fconfig != null) {
            int i;
            NodeWrapUtil lifeCycleNodeWrap;
            IDOMNode lifecycleNode;
            String[] factoryChildrenNames;
            NodeWrapUtil factoryNodeWrap;
            IDOMNode factoryNode;
            String[] appChildrenNames;
            NodeWrapUtil applicationNodeWrap;
            List appList = null;
            List factoryList = null;
            List lifecycleList = null;
            int appCount = 0;
            int factoryCount = 0;
            int lifecycleCount = 0;
            IDOMNode applicationNode = (IDOMNode)fconfig.getChildNode("application");
            if (applicationNode != null && (appList = (applicationNodeWrap = new NodeWrapUtil(applicationNode)).getChildNodes(appChildrenNames = new String[]{"action-listener", "default-render-kit-id", "locale-config", "message-bundle", "navigation-handler", "property-resolver", "state-manager", "variable-resolver", "view-handler"})) != null) {
                appCount = appList.size();
            }
            if ((factoryNode = (IDOMNode)fconfig.getChildNode("factory")) != null && (factoryList = (factoryNodeWrap = new NodeWrapUtil(factoryNode)).getChildNodes(factoryChildrenNames = new String[]{"application-factory", "faces-context-factory", "lifecycle-factory", "render-kit-factory"})) != null) {
                factoryCount = factoryList.size();
            }
            if ((lifecycleNode = (IDOMNode)fconfig.getChildNode("lifecycle")) != null && (lifecycleList = (lifeCycleNodeWrap = new NodeWrapUtil(lifecycleNode)).getChildNodes("phase-listener")) != null) {
                lifecycleCount = lifecycleList.size();
            }
            this.othersList = new ArrayList(appCount + factoryCount + lifecycleCount);
            if (appCount > 0) {
                i = 0;
                while (i < appCount) {
                    IDOMNode appChild = (IDOMNode)appList.get(i);
                    if ("locale-config".equalsIgnoreCase(appChild.getNodeName())) {
                        List supportedLocaleNodeList;
                        NodeWrapUtil localeConfigWrap = new NodeWrapUtil(appChild);
                        IDOMNode defaultLocaleNode = (IDOMNode)localeConfigWrap.getChildNode("default-locale");
                        if (defaultLocaleNode != null) {
                            OthersElement appElement = new OthersElement();
                            appElement.setType("application");
                            appElement.setName("locale-config/default-locale");
                            appElement.setValue(defaultLocaleNode.getFirstChild().getNodeValue());
                            this.othersList.add(appElement);
                        }
                        if ((supportedLocaleNodeList = localeConfigWrap.getChildNodes("supported-locale")) != null) {
                            int j = 0;
                            int n = supportedLocaleNodeList.size();
                            while (j < n) {
                                IDOMNode supportedLocaleNode = (IDOMNode)supportedLocaleNodeList.get(j);
                                OthersElement appElement = new OthersElement();
                                appElement.setType("application");
                                appElement.setName("locale-config/supported-locale");
                                appElement.setValue(supportedLocaleNode.getFirstChild().getNodeValue());
                                this.othersList.add(appElement);
                                ++j;
                            }
                        }
                    } else {
                        OthersElement appElement = new OthersElement();
                        appElement.setType("application");
                        appElement.setName(appChild.getNodeName());
                        appElement.setValue(appChild.getFirstChild().getNodeValue());
                        this.othersList.add(appElement);
                    }
                    ++i;
                }
            }
            if (factoryCount > 0) {
                i = 0;
                while (i < factoryCount) {
                    IDOMNode factoryChild = (IDOMNode)factoryList.get(i);
                    OthersElement factoryElement = new OthersElement();
                    factoryElement.setType("factory");
                    factoryElement.setName(factoryChild.getNodeName());
                    factoryElement.setValue(factoryChild.getFirstChild().getNodeValue());
                    this.othersList.add(factoryElement);
                    ++i;
                }
            }
            if (lifecycleCount > 0) {
                i = 0;
                while (i < lifecycleCount) {
                    IDOMNode lifecycleChild = (IDOMNode)lifecycleList.get(i);
                    OthersElement conElement = new OthersElement();
                    conElement.setType("phase-listener");
                    conElement.setName(lifecycleChild.getNodeName());
                    conElement.setValue(lifecycleChild.getFirstChild().getNodeValue());
                    this.othersList.add(conElement);
                    ++i;
                }
            }
            this.tableViewer.setInput((Object)this.othersList);
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return OverviewOthersSection.this.othersList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            OthersElement elem = (OthersElement)element;
            switch (columnIndex) {
                case 0: {
                    return elem.getType();
                }
                case 1: {
                    return elem.getName();
                }
                case 2: {
                    return elem.getValue();
                }
            }
            return "";
        }
    }

    class OthersElement {
        private String _name;
        private String _type;
        private String _value;

        public OthersElement(String type, String name, String value) {
            this._name = name;
            this._type = type;
            this._value = value;
        }

        public OthersElement() {
        }

        void setName(String name) {
            this._name = name;
        }

        void setType(String type) {
            this._type = type;
        }

        void setValue(String value) {
            this._value = value;
        }

        public String getName() {
            return this._name;
        }

        public String getType() {
            return this._type;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return String.valueOf(this._type) + "\\t" + this._name + "\\t" + this._value;
        }
    }
}

