/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections.editgroups;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.IDialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;

public class RenderersEditGroup
extends DialogFieldGroup
implements IDialogFieldGroup {
    private static EditorResources resource = EditorResources.getInstance();
    private Table table;
    private static final int TABLE_DEFAULT_HEIGHT = 160;
    private Composite generalSection;
    private Button addButton;
    private Button removeButton;
    private Button editButton;
    private IDOMNode renderKitNode;

    public void initialize() {
    }

    public void refreshData() {
        this.clearTable();
        this.appendExisitingRenderers();
        this.updateButtons();
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        this.createPropertyEntry(parent, toolkit);
    }

    public IStatus[] validateDialogFields() {
        return null;
    }

    public void createPropertyEntry(Composite container, FormToolkit toolkit) {
        this.generalSection = toolkit.createComposite(container);
        this.generalSection.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(this.generalSection);
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        this.generalSection.setLayout((Layout)gl);
        this.createTableSection(this.generalSection, toolkit);
        this.createButtonsSection(this.generalSection, toolkit);
    }

    private void createTableSection(Composite container, FormToolkit toolkit) {
        Composite renderersContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1808);
        renderersContainer.setLayoutData((Object)gd);
        toolkit.paintBordersFor(renderersContainer);
        GridLayout gl = new GridLayout();
        renderersContainer.setLayout((Layout)gl);
        this.table = new Table(renderersContainer, 66304);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 160;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        TableColumn nameCol = new TableColumn(this.table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        nameCol.setText(resource.getString("ComponentsPage.RenderKitsSection.Renderer.Table.NameColumn"));
        TableColumn familyCol = new TableColumn(this.table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        familyCol.setText(resource.getString("ComponentsPage.RenderKitsSection.Renderer.Table.ComponentFamilyColumn"));
        TableColumn typeCol = new TableColumn(this.table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        typeCol.setText(resource.getString("ComponentsPage.RenderKitsSection.Renderer.Table.TypeColumn"));
        TableColumn classCol = new TableColumn(this.table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        classCol.setText(resource.getString("ComponentsPage.RenderKitsSection.Renderer.Table.ClassColumn"));
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RenderersEditGroup.this.handleSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                RenderersEditGroup.this.handleSelection(e);
            }
        });
    }

    protected void handleSelection(SelectionEvent e) {
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.table.getSelectionCount() > 0) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private void createButtonsSection(Composite container, FormToolkit toolkit) {
        Composite operationContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1042);
        operationContainer.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        operationContainer.setLayout((Layout)gl);
        this.addButton = toolkit.createButton(operationContainer, resource.getString("ComponentsPage.RenderKitsSection.Renderer.Button.Add"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.addButton.setLayoutData((Object)gd);
        this.editButton = toolkit.createButton(operationContainer, resource.getString("ComponentsPage.RenderKitsSection.Renderer.Button.Edit"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.editButton.setLayoutData((Object)gd);
        this.removeButton = toolkit.createButton(operationContainer, resource.getString("ComponentsPage.RenderKitsSection.Renderer.Button.Remove"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removeButton.setLayoutData((Object)gd);
    }

    public Button getEditButton() {
        return this.editButton;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public Table getTable() {
        return this.table;
    }

    private void appendExisitingRenderers() {
        NodeWrapUtil renderKitWrap = new NodeWrapUtil(this.renderKitNode);
        boolean hasRenderer = false;
        List renderersList = renderKitWrap.getChildNodes("renderer");
        if (renderersList == null) {
            return;
        }
        int i = 0;
        int n = renderersList.size();
        while (i < n) {
            IDOMNode rendererNode = (IDOMNode)renderersList.get(i);
            this.addRendererItem(rendererNode);
            hasRenderer = true;
            ++i;
        }
        if (hasRenderer) {
            this.table.select(0);
        }
    }

    private void addRendererItem(IDOMNode rendererNode) {
        NodeWrapUtil rendererWrap = new NodeWrapUtil(rendererNode);
        TableItem item = new TableItem(this.table, 0);
        String rendererName = rendererWrap.getChildNodeValue("display-name");
        item.setText(0, rendererName);
        String componentFamily = rendererWrap.getChildNodeValue("component-family");
        item.setText(1, componentFamily);
        String type = rendererWrap.getChildNodeValue("renderer-type");
        item.setText(2, type);
        String rendererClass = rendererWrap.getChildNodeValue("renderer-class");
        item.setText(3, rendererClass);
        item.setData((Object)rendererNode);
    }

    private void clearTable() {
        this.table.removeAll();
    }

    public void setInput(Object newInput) {
        if (newInput != null && newInput instanceof IDOMNode) {
            this.renderKitNode = (IDOMNode)newInput;
            this.refreshData();
        }
    }

    public Object getInput() {
        return this.renderKitNode;
    }

    public void setRendererName(IDOMNode node, String newName) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.table.getItem(itemIndex).setText(0, newName.trim());
            this.table.select(itemIndex);
        }
    }

    public void setComponentFamily(IDOMNode node, String newComponentFamily) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.table.getItem(itemIndex).setText(1, newComponentFamily.trim());
            this.table.select(itemIndex);
        }
    }

    public void setRendererType(IDOMNode node, String newType) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.table.getItem(itemIndex).setText(2, newType.trim());
            this.table.select(itemIndex);
        }
    }

    public void setRendererClass(IDOMNode node, String newClass) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.table.getItem(itemIndex).setText(3, newClass.trim());
            this.table.select(itemIndex);
        }
    }

    public void removeItem(IDOMNode node) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.table.remove(itemIndex);
            this.table.select(itemIndex - 1);
            this.updateButtons();
        }
    }

    public void addItem(IDOMNode node) {
        int index;
        if (node != null && (index = this.findItem(node)) < 0) {
            this.addRendererItem(node);
            this.table.select(this.table.getItemCount() - 1);
        }
    }

    protected int findItem(IDOMNode node) {
        int itemIndex = -1;
        TableItem[] items = this.table.getItems();
        int i = 0;
        int n = this.table.getItemCount();
        while (i < n) {
            if (items[i].getData() == node) {
                itemIndex = i;
                break;
            }
            ++i;
        }
        return itemIndex;
    }
}

