/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.ClassButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldChangeListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedPropertyRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.JavaBeanUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.JavaClassUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.ManagedBeanUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.SelectionUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.NewPage;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.IManagedBeanDataSource;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.JavaBeanProperty;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.ManagedBeanConfiguration;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.WizardsResources;

public class JavaSelectionWizardPage
extends NewPage
implements IManagedBeanDataSource {
    private static final int HORIZONTAL_INDENT_DEFAULT = 25;
    private String className;
    private Button searchRadioButton;
    private ClassButtonDialogField classSearchDialogField;
    private IType searchedType;
    private Button createRadioButton;
    private ManagedBeanConfiguration managedBeanConfig;
    private IProject currentProject;
    private final String injectedInstanceName;

    public JavaSelectionWizardPage(IStructuredSelection selection) {
        super("JavaSelectionWizardPage");
        this.currentProject = SelectionUtil.getProject(selection);
        this.injectedInstanceName = SelectionUtil.getInjectedBeanName(selection);
        this.setTitle(WizardsResources.getInstance().getString("JavaSelectionWizardPage.Title"));
        this.setDescription(WizardsResources.getInstance().getString("JavaSelectionWizardPage.Description"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        Group group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.createSearchSection((Composite)group);
        this.createGenerateSection((Composite)group);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        this.setPageComplete(this.classSearchDialogField.getText().length() > 0);
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)container, WizardsResources.getInstance().getString("JavaSelectionWizardPage.HelpContextID"));
    }

    private void enableSearchSection(boolean enabled) {
        this.classSearchDialogField.setEnabled(enabled);
    }

    private void createSearchSection(Composite parent) {
        this.searchRadioButton = new Button(parent, 16);
        this.searchRadioButton.setText(WizardsResources.getInstance().getString("JavaSelectionWizardPage.Search"));
        this.searchRadioButton.setSelection(true);
        this.searchRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaSelectionWizardPage.this.createRadioButton.setSelection(!JavaSelectionWizardPage.this.searchRadioButton.getSelection());
                JavaSelectionWizardPage.this.enableSearchSection(JavaSelectionWizardPage.this.searchRadioButton.getSelection());
                JavaSelectionWizardPage.this.verifyComplete();
            }
        });
        Composite searchSection = new Composite(parent, 0);
        this.classSearchDialogField = new ClassButtonDialogField(this.currentProject);
        this.classSearchDialogField.setHyperLink(null);
        int numberOfControls = this.classSearchDialogField.getNumberOfControls();
        GridLayout layout = new GridLayout();
        layout.numColumns = numberOfControls;
        layout.verticalSpacing = 9;
        searchSection.setLayout((Layout)layout);
        searchSection.setLayoutData((Object)new GridData(768));
        this.classSearchDialogField.doFillIntoGrid(null, searchSection, numberOfControls);
        GridData gd = (GridData)this.classSearchDialogField.getLabelControl(null, searchSection).getLayoutData();
        gd.horizontalIndent = 25;
        this.classSearchDialogField.setLabelText(WizardsResources.getInstance().getString("JavaSelectionWizardPage.Search.ClassName"));
        LayoutUtil.setHorizontalGrabbing((Control)this.classSearchDialogField.getTextControl(null, searchSection));
        this.classSearchDialogField.setDialogFieldChangeListener(new IDialogFieldChangeListener(){

            public void dialogFieldChanged(DialogField field) {
                JavaSelectionWizardPage.this.className = JavaSelectionWizardPage.this.classSearchDialogField.getText();
                JavaSelectionWizardPage.this.verifyComplete();
            }
        });
        Label searchDesp = new Label(searchSection, 0);
        searchDesp.setText(WizardsResources.getInstance().getString("JavaSelectionWizardPage.Search.Description"));
        gd = new GridData();
        gd.horizontalSpan = numberOfControls;
        gd.horizontalIndent = 25;
        searchDesp.setLayoutData((Object)gd);
    }

    private void createGenerateSection(Composite parent) {
        this.createRadioButton = new Button(parent, 16);
        this.createRadioButton.setText(WizardsResources.getInstance().getString("JavaSelectionWizardPage.Create"));
        this.createRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaSelectionWizardPage.this.searchRadioButton.setSelection(!JavaSelectionWizardPage.this.createRadioButton.getSelection());
                JavaSelectionWizardPage.this.enableSearchSection(!JavaSelectionWizardPage.this.createRadioButton.getSelection());
                JavaSelectionWizardPage.this.verifyComplete();
            }
        });
        Composite createSection = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        createSection.setLayout((Layout)layout);
        createSection.setLayoutData((Object)new GridData(768));
        Label createDesp = new Label(createSection, 0);
        createDesp.setText(WizardsResources.getInstance().getString("JavaSelectionWizardPage.Create.Description"));
        GridData gd = new GridData();
        gd.horizontalIndent = 25;
        createDesp.setLayoutData((Object)gd);
    }

    public boolean isCreateNewJavaClass() {
        return this.createRadioButton.getSelection();
    }

    public IType getSelectedType() {
        this.searchedType = JavaClassUtils.getType(this.currentProject, this.classSearchDialogField.getText());
        return this.searchedType;
    }

    public String getClassName() {
        return this.className;
    }

    private IStatus validateJavaTypeName() {
        IStatus status = null;
        if (this.classSearchDialogField.getText().length() == 0) {
            status = new Status(4, EditorPlugin.getPluginId(), -1, WizardsResources.getInstance().getString("JavaSelectionWizardPage.Error.ClassIsEmpty", this.classSearchDialogField.getText()), null);
        } else {
            status = JavaConventions.validateJavaTypeName((String)this.classSearchDialogField.getText());
            if (status.getSeverity() != 4 && this.getSelectedType() == null) {
                status = new Status(4, EditorPlugin.getPluginId(), -1, WizardsResources.getInstance().getString("JavaSelectionWizardPage.Error.ClassIsNotDefined", this.classSearchDialogField.getText()), null);
            }
        }
        return status;
    }

    private void verifyComplete() {
        IStatus status = null;
        if (this.isCreateNewJavaClass()) {
            this.setPageComplete(true);
            this.setMessage(null);
            this.setErrorMessage(null);
        } else {
            if (this.searchRadioButton.getSelection()) {
                status = this.validateJavaTypeName();
            }
            String errorMessage = null;
            this.setPageComplete(status.getSeverity() != 4);
            if (status.getSeverity() == 4) {
                errorMessage = status.getMessage();
            }
            if (errorMessage != null) {
                this.setErrorMessage(errorMessage);
            } else {
                this.setErrorMessage(null);
            }
            if (status.getSeverity() != 0) {
                this.setMessage(status.getMessage());
            } else {
                this.setMessage(null);
            }
        }
    }

    public List getSummaryData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        if (!this.isCreateNewJavaClass()) {
            data.add(new String[]{WizardsResources.getInstance().getString("NewJavaManagedBeanWizard.Summary.ClassName"), this.getClassName()});
        }
        return data;
    }

    protected void dialogChanged() {
    }

    protected void initialize() {
        if (this.loadManagedBeanConfiguration()) {
            this.currentProject = this.managedBeanConfig.getProject();
            this.classSearchDialogField.setProject(this.currentProject);
            this.classSearchDialogField.setTextWithoutUpdate("");
            this.verifyComplete();
        }
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        this.initialize();
    }

    private boolean loadManagedBeanConfiguration() {
        ManagedBeanConfiguration mbConfigPrev = null;
        if (this.getPreviousPage() instanceof IManagedBeanDataSource) {
            mbConfigPrev = ((IManagedBeanDataSource)this.getPreviousPage()).getConfiguration();
        }
        if (mbConfigPrev == null) {
            return false;
        }
        ManagedBeanConfiguration mbConfig = this.getConfiguration();
        mbConfig.setFacesConfigFile(mbConfigPrev.getFacesConfigFile());
        if (mbConfig.getProject() != mbConfigPrev.getProject()) {
            mbConfig.setProject(mbConfigPrev.getProject());
            return true;
        }
        return false;
    }

    public ManagedBeanConfiguration getConfiguration() {
        if (this.managedBeanConfig == null) {
            this.managedBeanConfig = new ManagedBeanConfiguration();
            this.managedBeanConfig.setProject(this.currentProject);
        }
        if (!this.isCreateNewJavaClass()) {
            String refName = this.injectedInstanceName;
            IType selectedType = this.getSelectedType();
            if (selectedType != null) {
                if (refName == null) {
                    refName = this.getSelectedType().getElementName();
                    refName = String.valueOf(refName.substring(0, 1).toLowerCase()) + refName.substring(1);
                    refName = ManagedBeanUtils.getDefaultManagedBeanName(this.currentProject, refName);
                }
                this.managedBeanConfig.setName(refName);
                this.managedBeanConfig.setClassName(this.getClassName());
                this.managedBeanConfig.setPropertyEditable(false);
            }
        }
        return this.managedBeanConfig;
    }

    public List getManagedBeanProperty() {
        ArrayList mbProperties = null;
        if (!this.isCreateNewJavaClass()) {
            IType classType = JavaClassUtils.getType(this.currentProject, this.getClassName());
            if (classType == null) {
                return null;
            }
            JavaBeanProperty[] properties = JavaBeanUtils.getBeanProperties(classType);
            if (properties != null && properties.length > 0) {
                mbProperties = new ArrayList();
                int i = 0;
                while (i < properties.length) {
                    ManagedPropertyRecorder property = new ManagedPropertyRecorder(null, null);
                    property.setPropertyName(properties[i].getName());
                    property.setPropertyClass(properties[i].getQualifiedType());
                    ++i;
                }
            }
        }
        return mbProperties;
    }
}

