/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.context.resolver.structureddocument.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.wtp.jsf.context.IModelContext;
import org.eclipse.wtp.jsf.context.resolver.structureddocument.ISymbolContextResolver;
import org.eclipse.wtp.jsf.context.resolver.structureddocument.impl.FacesConfigSymbolSourceProvider;
import org.eclipse.wtp.jsf.context.resolver.structureddocument.impl.ResourceBundleSymbolSourceProvider;
import org.eclipse.wtp.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.wtp.jsf.context.symbol.ISymbol;
import org.eclipse.wtp.jsf.context.symbol.source.ISymbolSourceProvider;

class SymbolContextResolver
implements ISymbolContextResolver {
    private final IStructuredDocumentContext _context;

    SymbolContextResolver(IStructuredDocumentContext context) {
        this._context = context;
    }

    public ISymbol getSymbol(String name) {
        ISymbol[] symbols = this.getSymbolsForPrefix(name);
        int i = 0;
        while (i < symbols.length) {
            if (symbols[i].getName().equals(name)) {
                return symbols[i];
            }
            ++i;
        }
        return null;
    }

    public ISymbol[] getSymbolsForPrefix(String prefix) {
        ArrayList<ISymbol> symbols = new ArrayList<ISymbol>();
        ISymbolSourceProvider[] providers = new ISymbolSourceProvider[]{new FacesConfigSymbolSourceProvider(), new ResourceBundleSymbolSourceProvider()};
        int i = 0;
        while (i < providers.length) {
            ISymbolSourceProvider provider = providers[i];
            if (provider.isProvider((IAdaptable)this._context)) {
                symbols.addAll(Arrays.asList(provider.getSymbols(prefix, (IAdaptable)this._context)));
            }
            ++i;
        }
        return symbols.toArray(new ISymbol[0]);
    }

    public ISymbol[] getAllSymbols() {
        ArrayList<ISymbol> symbols = new ArrayList<ISymbol>();
        ISymbolSourceProvider[] providers = new ISymbolSourceProvider[]{new FacesConfigSymbolSourceProvider(), new ResourceBundleSymbolSourceProvider()};
        int i = 0;
        while (i < providers.length) {
            ISymbolSourceProvider provider = providers[i];
            if (provider.isProvider((IAdaptable)this._context)) {
                symbols.addAll(Arrays.asList(provider.getSymbols((IAdaptable)this._context)));
            }
            ++i;
        }
        return symbols.toArray(new ISymbol[0]);
    }

    public boolean canResolveContext(IModelContext modelContext) {
        return false;
    }
}

