/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield;

import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldApplyListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldChangeListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IStringButtonAdapter;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.ISupportTextValue;

public class DialogFieldWrapper
implements DialogField,
ISupportTextValue {
    private DialogField wrappedDialogField;
    private Button button;
    private boolean buttonEnabled;
    private Image buttonImage;
    private String buttonLabel;
    private IStringButtonAdapter adapter;

    public DialogFieldWrapper(DialogField field, Image image) {
        if (!(field instanceof ISupportTextValue)) {
            throw new IllegalArgumentException("Field must be ISupportTextValue");
        }
        this.wrappedDialogField = field;
        this.buttonImage = image;
    }

    public DialogFieldWrapper(DialogField field, String label) {
        if (!(field instanceof ISupportTextValue)) {
            throw new IllegalArgumentException("Field must be ISupportTextValue");
        }
        this.wrappedDialogField = field;
        this.buttonLabel = label;
    }

    public void setButtonAdapter(IStringButtonAdapter adapter) {
        this.adapter = adapter;
        this.updateButtonControl();
    }

    public void setTextWithoutUpdate(String value) {
        ((ISupportTextValue)((Object)this.wrappedDialogField)).setTextWithoutUpdate(value);
    }

    public String getText() {
        return ((ISupportTextValue)((Object)this.wrappedDialogField)).getText();
    }

    public void setText(String value) {
        ((ISupportTextValue)((Object)this.wrappedDialogField)).setText(value);
    }

    public Control[] doFillIntoGrid(FormToolkit toolkit, Composite parent, int nColumns) {
        Control[] wrappedControls = this.wrappedDialogField.doFillIntoGrid(toolkit, parent, nColumns - 1);
        Control[] result = new Control[wrappedControls.length];
        Control button = this.getButton(toolkit, parent);
        button.setLayoutData((Object)this.gridDataForButton(1));
        System.arraycopy(wrappedControls, 0, result, 0, wrappedControls.length);
        result[result.length - 1] = this.button;
        return result;
    }

    private GridData gridDataForButton(int span) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        gd.heightHint = 18;
        gd.widthHint = 18;
        return gd;
    }

    private Control getButton(FormToolkit toolkit, Composite parent) {
        if (this.button == null) {
            Assert.isNotNull((Object)parent, (String)"uncreated control requested with composite null");
            if (toolkit != null) {
                this.button = toolkit.createButton(parent, "", 8);
                if (this.buttonImage != null) {
                    this.button.setImage(this.buttonImage);
                } else {
                    this.button.setText(this.buttonLabel);
                }
            } else {
                this.button = new Button(parent, 8);
                if (this.buttonImage != null) {
                    this.button.setImage(this.buttonImage);
                } else {
                    this.button.setText(this.buttonLabel);
                }
            }
            this.button.setEnabled(this.isEnabled() && this.buttonEnabled);
            this.button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    DialogFieldWrapper.this.buttonPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    DialogFieldWrapper.this.buttonPressed();
                }
            });
        }
        return this.button;
    }

    public Control getLabelControl(FormToolkit _formToolkit, Composite parent) {
        return this.wrappedDialogField.getLabelControl(_formToolkit, parent);
    }

    public void setHyperLink(IHyperlinkListener listener) {
        this.wrappedDialogField.setHyperLink(listener);
    }

    public void setLabelText(String labeltext) {
        this.wrappedDialogField.setLabelText(labeltext);
    }

    public void setDialogFieldChangeListener(IDialogFieldChangeListener listener) {
        this.wrappedDialogField.setDialogFieldChangeListener(listener);
    }

    public void setDialogFieldApplyListener(IDialogFieldApplyListener listener) {
        this.wrappedDialogField.setDialogFieldApplyListener(listener);
    }

    public boolean setFocus() {
        return this.wrappedDialogField.setFocus();
    }

    public int getNumberOfControls() {
        return this.wrappedDialogField.getNumberOfControls() + 1;
    }

    public void setButtonEnabled(boolean enabled) {
        this.buttonEnabled = enabled;
        this.updateButtonControl();
    }

    public boolean isButtonEnabled() {
        return this.buttonEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.wrappedDialogField.setEnabled(enabled);
        this.updateButtonControl();
    }

    private void updateButtonControl() {
        if (this.button != null) {
            this.button.setEnabled(this.isEnabled() && this.buttonEnabled && this.adapter != null);
        }
    }

    public boolean isEnabled() {
        return this.wrappedDialogField.isEnabled();
    }

    public Object getAttachedData(Object key) {
        return this.wrappedDialogField.getAttachedData(key);
    }

    public void putAttachedData(Object key, Object value) {
        this.wrappedDialogField.putAttachedData(key, value);
    }

    protected void buttonPressed() {
        if (this.adapter != null) {
            this.adapter.changeControlPressed(this);
        }
    }

    public void handleGrabHorizontal() {
        this.wrappedDialogField.handleGrabHorizontal();
    }

    public DialogField getWrappedDialogField() {
        return this.wrappedDialogField;
    }

    public boolean isRequired() {
        return this.wrappedDialogField.isRequired();
    }
}

