/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;

public class JavaSearchScope
implements IJavaSearchScope {
    private IProject project;
    private String superType;
    private HashSet allowedTypeSet;
    private IPath[] enclosingProjectsAndJars;
    private IProject[] relativeProjects;

    public JavaSearchScope(IProject project, String superType) {
        this.project = project;
        this.superType = superType;
        this.computeRelativeProjects();
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this.enclosingProjectsAndJars == null) {
            ArrayList<IPath> list = new ArrayList<IPath>();
            int i = 0;
            while (i < this.relativeProjects.length) {
                try {
                    if (this.relativeProjects[i].hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject javaProject = JavaCore.create((IProject)this.relativeProjects[i]);
                        IClasspathEntry[] classpath = javaProject.getResolvedClasspath(true);
                        int j = 0;
                        while (j < classpath.length) {
                            list.add(classpath[j].getPath());
                            ++j;
                        }
                        list.add(javaProject.getPath());
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
            this.enclosingProjectsAndJars = list.toArray(new IPath[list.size()]);
        }
        return this.enclosingProjectsAndJars;
    }

    private void computeRelativeProjects() {
        try {
            IProject[] referencedProjects = this.project.getReferencedProjects();
            this.relativeProjects = new IProject[referencedProjects.length + 1];
            System.arraycopy(referencedProjects, 0, this.relativeProjects, 1, referencedProjects.length);
            this.relativeProjects[0] = this.project;
        }
        catch (CoreException coreException) {
            this.relativeProjects = new IProject[]{this.project};
        }
    }

    public boolean encloses(String resourcePath) {
        String className;
        int separatorIndex;
        if (this.allowedTypeSet == null) {
            try {
                this.allowedTypeSet = this.findAllowedTypes(this.superType);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (this.allowedTypeSet == null) {
            this.allowedTypeSet = new HashSet();
        }
        return (separatorIndex = resourcePath.indexOf("|")) != -1 ? this.allowedTypeSet.contains(className = resourcePath.substring(separatorIndex + 1, resourcePath.length() - 6).replace('/', '.')) : this.allowedTypeSet.contains(resourcePath);
    }

    public boolean encloses(IJavaElement element) {
        return this.encloses(element.getPath().toString());
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean includesClasspaths() {
        return true;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }

    private HashSet findAllowedTypes(String _superType) throws CoreException {
        HashSet<String> set = new HashSet<String>();
        IProject[] projects = this.relativeProjects;
        int i = 0;
        while (i < projects.length) {
            IType type = null;
            if (projects[i].hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)projects[i]);
                if (_superType != null) {
                    try {
                        type = javaProject.findType(_superType);
                        if (type != null) {
                            ITypeHierarchy typeHierarchy = type.newTypeHierarchy(javaProject, null);
                            IType[] subtypes = typeHierarchy.getAllSubtypes(type);
                            int j = 0;
                            while (j < subtypes.length) {
                                if (!subtypes[j].isBinary()) {
                                    set.add(subtypes[j].getPath().toString());
                                } else {
                                    set.add(subtypes[j].getFullyQualifiedName());
                                }
                                ++j;
                            }
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        return set;
    }

    public String getSuperType() {
        return this.superType;
    }

    public void setSuperType(String superType) {
        this.superType = superType;
    }
}

