/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.part.DrillDownComposite;
import org.eclipse.wtp.jsf.facesconfig.editor.common.CommonPlugin;

public abstract class TreeViewerSelectionDialog
extends SelectionDialog {
    private static final String DEFAULT_TITLE = CommonPlugin.getResourceString("Dialog.TreeViewerSelectionDialog.DefaultTitle");
    public static final int STYLE_NONE = 0;
    public static final int STYLE_INFORMATION = 1;
    public static final int STYLE_ERROR = 2;
    public static final int STYLE_WARNING = 3;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private String title = DEFAULT_TITLE;
    private static Object[] selection;
    private ITreeContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private ViewerFilter filter;
    private Label statusImage;
    private Label statusLabel;
    private String statusMessage;
    private TreeViewer treeViewer;
    private int style;
    private ViewerSorter viewerSorter = null;

    public TreeViewerSelectionDialog(Shell parentShell, String statusMessage, int style) {
        super(parentShell);
        this.statusMessage = statusMessage;
        this.style = style;
        this.setShellStyle(67696);
    }

    public TreeViewerSelectionDialog(Shell parentShell, String statusMessage) {
        this(parentShell, statusMessage, 0);
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.title = title;
    }

    protected void createTreeViewer(Composite parent) {
        DrillDownComposite drillDown = new DrillDownComposite(parent, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = 320;
        spec.heightHint = 300;
        drillDown.setLayoutData((Object)spec);
        this.treeViewer = new TreeViewer((Composite)drillDown, this.style);
        drillDown.setChildTree(this.treeViewer);
    }

    private void setTreeViewerProviders() {
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        if (this.viewerSorter == null) {
            this.viewerSorter = new ViewerSorter();
        }
        this.treeViewer.setSorter(this.viewerSorter);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selection = TreeViewerSelectionDialog.this.getSelectedElements((IStructuredSelection)event.getSelection());
                TreeViewerSelectionDialog.this.updateStatus();
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (item instanceof IFile) {
                        TreeViewerSelectionDialog.this.okPressed();
                    } else if (TreeViewerSelectionDialog.this.treeViewer.getExpandedState(item)) {
                        TreeViewerSelectionDialog.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        TreeViewerSelectionDialog.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput(this.findInputElement());
        if (this.filter != null) {
            this.treeViewer.addFilter(this.filter);
        }
    }

    public void createTreeViewerComposite(Composite parent) {
        Composite treeViewerComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        treeViewerComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        treeViewerComposite.setLayoutData((Object)gridData);
        Label label = new Label(treeViewerComposite, 64);
        label.setText(this.title);
        label.setFont(treeViewerComposite.getFont());
        this.createTreeViewer(treeViewerComposite);
        Dialog.applyDialogFont((Control)treeViewerComposite);
    }

    public void setSelectedElement(Object[] selection) {
        if (selection == null) {
            return;
        }
        int i = 0;
        while (i < selection.length) {
            if (TreeViewerSelectionDialog.selection[i] != null) {
                this.treeViewer.expandToLevel(TreeViewerSelectionDialog.selection[i], 1);
            }
            ++i;
        }
        this.treeViewer.setSelection((ISelection)new StructuredSelection(selection), true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        area.setLayout((Layout)gridLayout);
        this.createTreeViewerComposite(area);
        this.statusImage = this.createLabel(area);
        this.statusImage.setImage(this.getMessageImage(2));
        this.statusLabel = this.createLabel(area);
        this.setTreeViewerProviders();
        return this.dialogArea;
    }

    private Label createLabel(Composite parent) {
        Label label = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        label.setText(this.statusMessage == null ? "" : this.statusMessage);
        return label;
    }

    private Object[] getSelectedElements(IStructuredSelection selection) {
        return selection.toArray();
    }

    public void setContentProvider(ITreeContentProvider provider) {
        this.contentProvider = provider;
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.labelProvider = provider;
    }

    public void setFilter(ViewerFilter filter) {
        this.filter = filter;
    }

    public void setViewerSorter(ViewerSorter sorter) {
        this.viewerSorter = sorter;
    }

    public void setStatusMessage(String message) {
        this.statusMessage = message;
    }

    private void updateStatus() {
        Object selection = TreeViewerSelectionDialog.selection;
        if (TreeViewerSelectionDialog.selection != null && TreeViewerSelectionDialog.selection.length == 1) {
            selection = TreeViewerSelectionDialog.selection[0];
        }
        if (this.isValidSelection(selection)) {
            this.statusImage.setVisible(false);
            this.statusLabel.setText("");
            this.getOkButton().setEnabled(true);
        } else {
            this.statusImage.setVisible(true);
            this.statusImage.setImage(this.getMessageImage(2));
            this.statusImage.redraw();
            this.statusLabel.setText(this.statusMessage);
            this.getOkButton().setEnabled(false);
        }
    }

    protected Image getMessageImage(int imageType) {
        switch (imageType) {
            case 2: {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
            case 3: {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            case 1: {
                return JFaceResources.getImage((String)"dialog_messasge_info_image");
            }
        }
        return null;
    }

    protected void okPressed() {
        ArrayList<Object> chosenContainerPathList = new ArrayList<Object>();
        if (selection != null) {
            chosenContainerPathList.addAll(Arrays.asList(selection));
        }
        this.setResult(chosenContainerPathList);
        super.okPressed();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (selection != null) {
            this.setSelectedElement(selection);
        }
        return control;
    }

    protected abstract boolean isValidSelection(Object var1);

    protected abstract Object findInputElement();
}

