/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.logging;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class Logger {
    private ResourceBundle resourceBundle;
    private ILog log;
    private String bundleId;

    public Logger(Bundle bundle, ResourceBundle resourceBundle) {
        this.log = Platform.getLog((Bundle)bundle);
        this.resourceBundle = resourceBundle;
        this.bundleId = bundle.getSymbolicName();
        if (resourceBundle == null) {
            Status status = new Status(4, this.bundleId, 0, "The resource Bundle for logger could not be null!", null);
            this.log.log((IStatus)status);
        }
    }

    public void info(String key, String arg0) {
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.resourceBundle.getString(key));
        String message = formatter.format(args);
        Status status = new Status(1, this.bundleId, 0, message, null);
        this.log.log((IStatus)status);
    }

    public void info(String key, Throwable e) {
        String message = this.resourceBundle.getString(key);
        Status status = new Status(1, this.bundleId, 0, message, e);
        this.log.log((IStatus)status);
    }

    public void error(String key) {
        String message = this.resourceBundle.getString(key);
        Status status = new Status(4, this.bundleId, 0, message, null);
        this.log.log((IStatus)status);
    }

    public void error(Throwable e) {
        Status status = new Status(4, this.bundleId, 0, "", e);
        this.log.log((IStatus)status);
    }

    public void error(String key, Throwable e) {
        String message = this.resourceBundle.getString(key);
        Status status = new Status(4, this.bundleId, 0, message, e);
        this.log.log((IStatus)status);
    }

    public void error(String key, String arg0) {
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.resourceBundle.getString(key));
        String message = formatter.format(args);
        Status status = new Status(4, this.bundleId, 0, message, null);
        this.log.log((IStatus)status);
    }

    public void error(String key, String arg, Throwable e) {
        Object[] args = new Object[]{arg};
        MessageFormat formatter = new MessageFormat(this.resourceBundle.getString(key));
        String message = formatter.format(args);
        Status status = new Status(4, this.bundleId, 0, message, e);
        this.log.log((IStatus)status);
    }

    public void error(String key, String arg0, String arg1, Throwable e) {
        Object[] args = new Object[]{arg0};
        args[1] = arg1;
        MessageFormat formatter = new MessageFormat(this.resourceBundle.getString(key));
        String message = formatter.format(args);
        Status status = new Status(4, this.bundleId, 0, message, e);
        this.log.log((IStatus)status);
    }
}

