/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.context.resolver.structureddocument.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wtp.jsf.context.IModelContext;
import org.eclipse.wtp.jsf.context.resolver.structureddocument.ITextRegionContextResolver;
import org.eclipse.wtp.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.wtp.jsf.context.structureddocument.IStructuredDocumentContextFactory;

class TextRegionContextResolver
implements ITextRegionContextResolver {
    private final IStructuredDocumentContext _context;
    static /* synthetic */ Class class$0;

    TextRegionContextResolver(IStructuredDocumentContext context) {
        this._context = context;
    }

    public String getRegionText() {
        ITextRegionCollection parent = this.getParentRegion();
        String text = null;
        if (parent != null) {
            ITextRegion me = parent.getRegionAtCharacterOffset(this._context.getDocumentPosition());
            text = parent.getText(me);
        }
        return text;
    }

    public int getEndOffset() {
        ITextRegionCollection parent = this.getParentRegion();
        int endOffset = -1;
        if (parent != null) {
            ITextRegion me = parent.getRegionAtCharacterOffset(this._context.getDocumentPosition());
            endOffset = parent.getEndOffset(me);
        }
        return endOffset;
    }

    public int getLength() {
        ITextRegionCollection parent = this.getParentRegion();
        int length = -1;
        if (parent != null) {
            ITextRegion me = parent.getRegionAtCharacterOffset(this._context.getDocumentPosition());
            length = me.getLength();
        }
        return length;
    }

    public int getStartOffset() {
        ITextRegionCollection parent = this.getParentRegion();
        int startOffset = -1;
        if (parent != null) {
            ITextRegion me = parent.getRegionAtCharacterOffset(this._context.getDocumentPosition());
            startOffset = parent.getStartOffset(me);
        }
        return startOffset;
    }

    public String getRegionType() {
        ITextRegion me;
        ITextRegionCollection parent = this.getParentRegion();
        String regionType = null;
        if (parent != null && (me = parent.getRegionAtCharacterOffset(this._context.getDocumentPosition())) != null) {
            regionType = me.getType();
        }
        return regionType;
    }

    public String[] getRegionTypePath() {
        ITextRegion[] path = this.createPathToContext();
        String[] typePath = new String[path.length];
        int i = 0;
        while (i < path.length) {
            typePath[i] = path[i].getType();
            ++i;
        }
        return typePath;
    }

    public IStructuredDocumentContext getNextContext() {
        ITextRegionCollection parent = this.getParentRegion();
        IStructuredDocumentContext newContext = null;
        if (parent != null) {
            ITextRegion me = parent.getRegionAtCharacterOffset(this._context.getDocumentPosition());
            ITextRegionList regions = parent.getRegions();
            ITextRegion nextRegion = null;
            Iterator it = regions.iterator();
            while (it.hasNext()) {
                if (it.next() != me || !it.hasNext()) continue;
                nextRegion = (ITextRegion)it.next();
            }
            if (nextRegion != null) {
                int documentPosition = parent.getStartOffset(nextRegion);
                newContext = IStructuredDocumentContextFactory.INSTANCE.getContext(this._context.getStructuredDocument(), documentPosition);
            }
        }
        return newContext;
    }

    public IStructuredDocumentContext getPreviousContext() {
        ITextRegionCollection parent = this.getParentRegion();
        IStructuredDocumentContext newContext = null;
        if (parent != null) {
            ITextRegion me = parent.getRegionAtCharacterOffset(this._context.getDocumentPosition());
            ITextRegionList regions = parent.getRegions();
            Iterator it = regions.iterator();
            ITextRegion prevRegion = null;
            ITextRegion nextRegion = null;
            while (it.hasNext()) {
                nextRegion = (ITextRegion)it.next();
                if (nextRegion == me) break;
                prevRegion = nextRegion;
            }
            if (prevRegion != null) {
                int documentPosition = parent.getStartOffset(prevRegion);
                newContext = IStructuredDocumentContextFactory.INSTANCE.getContext(this._context.getStructuredDocument(), documentPosition);
            }
        }
        return newContext;
    }

    private ITextRegionCollection getParentRegion() {
        ITextRegion[] path = this.createPathToContext();
        ITextRegionCollection parent = null;
        if (path.length > 0) {
            parent = (ITextRegionCollection)path[path.length - 1];
        }
        return parent;
    }

    public boolean matchesRelative(String[] path) {
        ITextRegion[] myPath = this.createPathToContext();
        return this.matchPath(myPath, path);
    }

    public boolean matchesAbsolute(String[] path) {
        ITextRegion[] myPath = this.createPathToContext();
        return myPath.length == path.length && this.matchPath(myPath, path);
    }

    private boolean matchPath(ITextRegion[] myPath, String[] path) {
        boolean matches = false;
        if (path.length <= myPath.length) {
            matches = true;
            int i = 1;
            while (i <= path.length) {
                if (!path[path.length - i].equals(myPath[myPath.length - i].getType())) {
                    matches = false;
                    break;
                }
                ++i;
            }
        }
        return matches;
    }

    public boolean canResolveContext(IModelContext modelContext) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.context.structureddocument.IStructuredDocumentContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return modelContext.getAdapter((Class)clazz) != null;
    }

    private ITextRegion[] createPathToContext() {
        ArrayList<IStructuredDocumentRegion> regionPath = new ArrayList<IStructuredDocumentRegion>();
        IStructuredDocument doc = (IStructuredDocument)this._context.getStructuredDocument();
        IStructuredDocumentRegion container = doc.getRegionAtCharacterOffset(this._context.getDocumentPosition());
        while (container != null && container instanceof ITextRegionCollection) {
            regionPath.add(container);
            container = ((ITextRegionCollection)container).getRegionAtCharacterOffset(this._context.getDocumentPosition());
        }
        return regionPath.toArray(new ITextRegion[0]);
    }
}

