/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.ComboDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.utils.ColorUtil;

public class ColorButtonDialogField
extends ComboDialogField {
    private Button button;
    private boolean buttonEnabled = true;
    private Color color;
    private RGB colorValue;
    private CCombo combo;
    private Image emptyImage;
    private Point extent;
    private Image image;

    public ColorButtonDialogField() {
        this(0);
    }

    public ColorButtonDialogField(int flags) {
        super(flags);
    }

    private void buttonPressed() {
        ColorDialog colorDialog = new ColorDialog(this.button.getShell());
        colorDialog.setRGB(this.colorValue);
        RGB newColor = colorDialog.open();
        if (newColor != null && !newColor.equals((Object)this.colorValue)) {
            this.colorValue = newColor;
            this.setText(ColorUtil.getStringColor(newColor));
            this.updateColorImage();
        }
    }

    private Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f = this.button.getFont();
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        Point p = new Point(height * 3 - 6, height - 2);
        gc.dispose();
        return p;
    }

    private void disposeResources() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if (this.emptyImage != null) {
            this.emptyImage.dispose();
            this.emptyImage = null;
        }
        if (this.color != null) {
            this.color.dispose();
            this.color = null;
        }
    }

    public Control[] doFillIntoGrid(FormToolkit toolkit, Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Control requiredLabel = this.getRequiredLabelControl(toolkit, parent);
        requiredLabel.setLayoutData((Object)ColorButtonDialogField.gridDataForLabel(1));
        Control label = this.getLabelControl(toolkit, parent);
        label.setLayoutData((Object)ColorButtonDialogField.gridDataForLabel(1));
        CCombo combo = this.getComboControl(toolkit, parent);
        combo.setLayoutData((Object)ColorButtonDialogField.gridDataForCombo(nColumns - 3));
        this.button = this.getChangeControl(toolkit, parent);
        this.button.setLayoutData((Object)this.gridDataForButton(1));
        return new Control[]{requiredLabel, label, combo, this.button};
    }

    public void enableButton(boolean enable) {
        if (this.isOkToUse((Control)this.button)) {
            this.button.setEnabled(this.isEnabled() && enable);
        }
        this.buttonEnabled = enable;
    }

    public Button getChangeControl(FormToolkit toolkit, Composite parent) {
        if (this.button == null) {
            this.assertCompositeNotNull(parent);
            this.button = toolkit != null ? toolkit.createButton(parent, "", 8) : new Button(parent, 8);
            this.button.setEnabled(this.isEnabled() && this.buttonEnabled);
            this.button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ColorButtonDialogField.this.buttonPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    ColorButtonDialogField.this.buttonPressed();
                }
            });
            this.button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ColorButtonDialogField.this.disposeResources();
                }
            });
            this.extent = this.computeImageSize((Control)parent);
            this.image = new Image((Device)parent.getDisplay(), this.extent.x, this.extent.y);
            this.emptyImage = new Image((Device)parent.getDisplay(), this.extent.x, this.extent.y);
            this.initEmptyImage((Control)this.button);
            this.updateColorImage();
        }
        return this.button;
    }

    private String[] getColorList() {
        Map map = ColorUtil.getCSSColorMap();
        ArrayList list = new ArrayList(map.keySet());
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    public CCombo getComboControl(FormToolkit toolkit, Composite parent) {
        if (this.combo == null) {
            this.combo = super.getComboControl(toolkit, parent);
            this.combo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ColorButtonDialogField.this.updateImageAfterChanged();
                }

                public void widgetSelected(SelectionEvent e) {
                    ColorButtonDialogField.this.updateImageAfterChanged();
                }
            });
            this.combo.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    ColorButtonDialogField.this.updateImageAfterChanged();
                }
            });
            this.combo.setItems(this.getColorList());
        }
        return this.combo;
    }

    public int getNumberOfControls() {
        return 4;
    }

    public CCombo getTextControl(FormToolkit toolkit, Composite parent) {
        return this.getComboControl(toolkit, parent);
    }

    protected GridData gridDataForButton(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.widthHint = LayoutUtil.getButtonWidthHint(this.button);
        gd.heightHint = this.combo.computeSize((int)-1, (int)-1).y;
        return gd;
    }

    private void initEmptyImage(Control parent) {
        Color transparentColor = parent.getForeground();
        ImageData imageData = this.emptyImage.getImageData();
        imageData.transparentPixel = 0;
        GC gc = new GC((Drawable)this.emptyImage);
        gc.setBackground(transparentColor);
        gc.fillRectangle(0, 0, this.emptyImage.getBounds().width, this.emptyImage.getBounds().height);
    }

    public void setColorValue(RGB rgb) {
        this.colorValue = rgb;
    }

    public void setTextWithoutUpdate(String text) {
        super.setTextWithoutUpdate(text);
        this.updateImageAfterChanged();
    }

    protected void updateColorImage() {
        if (this.colorValue == null) {
            this.button.setImage(this.emptyImage);
            return;
        }
        Display display = this.button.getDisplay();
        GC gc = new GC((Drawable)this.image);
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(0, 0, this.extent.x - 1, this.extent.y - 1);
        if (this.color != null) {
            this.color.dispose();
        }
        this.color = new Color((Device)display, this.colorValue);
        gc.setBackground(this.color);
        gc.fillRectangle(1, 1, this.extent.x - 2, this.extent.y - 2);
        gc.dispose();
        this.button.setImage(this.image);
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.button)) {
            this.button.setEnabled(this.isEnabled() && this.buttonEnabled);
        }
    }

    private void updateImageAfterChanged() {
        String newColor = this.getText().trim();
        this.setColorValue(ColorUtil.getColorRGB(newColor));
        this.updateColorImage();
    }
}

