/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wtp.jsf.facesconfig.editor.common.CommonPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.JavaClassWizardPage;

public class JavaClassWizard
extends Wizard {
    private static String STORE_SECTION = "JavaClassWizard";
    private JavaClassWizardPage mainPage;
    private String className;
    private String classArgs;
    private IProject project;
    private String superClass;
    private List interfaceList;
    private boolean autoOpenResource = true;

    public void setAutoOpenResource(boolean autoOpenResource) {
        this.autoOpenResource = autoOpenResource;
    }

    public JavaClassWizard(IProject project, String className) {
        this(project, className, null, null);
    }

    public JavaClassWizard(IProject project, String className, String superClass, List superInterfaces) {
        this.project = project;
        this.className = className;
        this.superClass = superClass;
        this.interfaceList = superInterfaces;
        IDialogSettings masterSettings = CommonPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setWindowTitle(CommonPlugin.getResourceString("DialogField.JavaClassWizard.NewClass"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.mainPage = new JavaClassWizardPage(this.project, this.className, this.superClass, this.interfaceList);
        this.addPage((IWizardPage)this.mainPage);
        this.mainPage.init();
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public boolean performFinish() {
        if (this.mainPage.getPackageText() != null && this.mainPage.getPackageText().length() > 0) {
            StringBuffer buffer = new StringBuffer(this.mainPage.getPackageText());
            buffer.append(".");
            buffer.append(this.mainPage.getTypeName());
            this.className = buffer.toString();
        } else {
            this.className = this.mainPage.getTypeName();
        }
        this.classArgs = this.mainPage.getClassArgs();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                JavaClassWizard.this.mainPage.createType(monitor);
                IResource resource = JavaClassWizard.this.mainPage.getModifiedResource();
                if (resource != null && JavaClassWizard.this.autoOpenResource) {
                    JavaClassWizard.this.selectAndReveal(resource);
                    if (JavaClassWizard.this.project.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject jProject = JavaCore.create((IProject)JavaClassWizard.this.project);
                        IJavaElement jElement = jProject.findElement(resource.getProjectRelativePath().removeFirstSegments(1));
                        if (jElement != null) {
                            JavaUI.openInEditor((IJavaElement)jElement);
                        }
                    } else if (resource instanceof IFile) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource), (boolean)true);
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)this.getWorkbenchWindow());
    }

    private IWorkbenchWindow getWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    protected ISchedulingRule getSchedulingRule() {
        return this.mainPage.getModifiedResource();
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassNameWithArgs() {
        if (this.classArgs != null && this.classArgs.length() > 0) {
            StringBuffer buffer = new StringBuffer(this.className);
            buffer.append(":");
            buffer.append(this.classArgs);
            return buffer.toString();
        }
        return this.getClassName();
    }
}

