/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wtp.jsf.facesconfig.editor.common.CommonPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IStringButtonAdapter;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;

public class StringButtonDialogField
extends StringDialogField {
    private Button browseButton;
    private String browseButtonLabel;
    private IStringButtonAdapter stringButtonAdapter;
    private boolean buttonEnabled;

    public StringButtonDialogField(IStringButtonAdapter adapter) {
        this.stringButtonAdapter = adapter;
        this.browseButtonLabel = CommonPlugin.getResourceString("DialogField.Browse");
        this.buttonEnabled = true;
    }

    public void setButtonLabel(String label) {
        this.browseButtonLabel = label;
    }

    public void changeControlPressed() {
        this.stringButtonAdapter.changeControlPressed(this);
    }

    public Control[] doFillIntoGrid(FormToolkit toolkit, Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Control requiredLabel = this.getRequiredLabelControl(toolkit, parent);
        requiredLabel.setLayoutData((Object)StringButtonDialogField.gridDataForLabel(1));
        Control label = this.getLabelControl(toolkit, parent);
        label.setLayoutData((Object)StringButtonDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(toolkit, parent);
        text.setLayoutData((Object)StringButtonDialogField.gridDataForText(nColumns - 3));
        Button button = this.getChangeControl(toolkit, parent);
        button.setLayoutData((Object)StringButtonDialogField.gridDataForButton(toolkit, button, text, 1));
        return new Control[]{requiredLabel, label, text, button};
    }

    public int getNumberOfControls() {
        return 4;
    }

    protected static GridData gridDataForButton(FormToolkit toolkit, Button button, Text text, int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.widthHint = LayoutUtil.getButtonWidthHint(button);
        gd.heightHint = LayoutUtil.getButtonHeightHint(toolkit, text);
        return gd;
    }

    public Button getChangeControl(FormToolkit toolkit, Composite parent) {
        if (this.browseButton == null) {
            this.assertCompositeNotNull(parent);
            if (toolkit != null) {
                this.browseButton = toolkit.createButton(parent, this.browseButtonLabel, 8);
            } else {
                this.browseButton = new Button(parent, 8);
                this.browseButton.setText(this.browseButtonLabel);
            }
            this.browseButton.setEnabled(this.isEnabled() && this.buttonEnabled);
            this.browseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    StringButtonDialogField.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    StringButtonDialogField.this.changeControlPressed();
                }
            });
        }
        return this.browseButton;
    }

    public void enableButton(boolean enable) {
        if (this.isOkToUse((Control)this.browseButton)) {
            this.browseButton.setEnabled(this.isEnabled() && enable);
        }
        this.buttonEnabled = enable;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.browseButton)) {
            this.browseButton.setEnabled(this.isEnabled() && this.buttonEnabled);
        }
    }

    public IStringButtonAdapter getStringButtonAdapter() {
        return this.stringButtonAdapter;
    }

    public void setStringButtonAdapter(IStringButtonAdapter buttonAdapter) {
        this.stringButtonAdapter = buttonAdapter;
    }
}

